﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;


namespace CCSPrototypeCommon
{
    public enum LogLevel : byte
    {
        DEBUG = 0,

        INFO = 1,

        WARNING = 2,

        ERROR = 3,

        CRITICAL = 4
    }

    public class CCS_Logs_V1
    {
        


        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid LogsID { get; set; }
     
        public string ClassName { get; set; }

        public LogLevel Type { get; set; }

        public string Message { get; set; }

        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime ModifiedDate { get; set; }

    }
}
