﻿using System;
using System.Web;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Data.Entity.Spatial;

namespace CCSPrototypeCommon
{
    public class CCS_MeterData_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid MeterDataID { get; set; }
        [Required]
        [DisplayName("抄表类型")]
        public string MeterType { get; set; }
        [DisplayName("用户姓名")]
        public string UserName { get; set; }
        [Required]
        [DisplayName("收费号")]
        public string AccountNumber { get; set; }
        [DisplayName("户号")]
        public string UserNumber { get; set; }
        [DisplayName("表SN")]
        public string MeterSN { get; set; }
        [DisplayName("表ID")]
        public string MeterID { get; set; }
        [DisplayName("表号")]
        public string MeterNumber { get; set; }
        [DisplayName("地址")]
        public string Address { get; set; }
        [DisplayName("门牌")]
        public string ApartmentNumber { get; set; }
        [DisplayName("用户类型")]
        public string UserType { get; set; }
        [DisplayName("营业所")]
        public string Office { get; set; }
        [DisplayName("联系电话")]
        public string PhoneNumber { get; set; }
        [DisplayName("备注")]
        public string Memo1 { get; set; }
        [DisplayName("冻结日期")]
        public DateTime CutoffDate { get; set; }
        [DisplayName("抄表方式")]
        public string CollectType { get; set; }
        [DisplayName("终端号码")]
        public string TerminalNumber { get; set; }
        [DisplayName("终端地址")]
        public string TerminalAddress { get; set; }
        [DisplayName("终端设备号")]
        public string TerminalEquipmentID { get; set; }
        [DisplayName("备注")]
        public string Memo2 { get; set; }
        public double Latitude { get; set; }
        public double Longitude { get; set; }

        public DbGeography geography  { get; set; }

        [DisplayName("创建时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime? CreationDate { get; set; }
        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime? ModifiedDate { get; set; }

    }
}
