﻿using System;
using System.Web;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace CCSPrototypeCommon
{
    public class CCS_Payment_AliPayNotif_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid PaymentNotifID { get; set; }

        public Guid PaymentInfoID { get; set; }

        [ForeignKey("PaymentInfoID")]
        public virtual CCS_PaymentInfo_V1 PaymentInfo { get; set; }

        [DisplayName("Payment TradeNo")]
        public string PaymentTradeNo { get; set; }

        [DisplayName("Payment Buyer_email")]
        public string PaymentBuyerEmail { get; set; }

        [DisplayName("Payment Subject")]
        public string PaymentSubject { get; set; }

        [DisplayName("Payment Discount")]
        public double? PaymentDiscount { get; set; }
       
        [DisplayName("Payment Type")]
        public int? PaymentType { get; set; }



        [DisplayName("Payment Notify Type")]
        public string PaymentNotifyType { get; set; }

       
        [DisplayName("Payment Quantity")]
        public int? PaymentQuantity { get; set; }

        [DisplayName("Payment Create Time")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}")]
        public DateTime PaymentCreateTime { get; set; }

        [DisplayName("Payment Seller ID")]
        public string PaymentSellerID { get; set; }

        [DisplayName("Payment Notify Time")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}")]
        public DateTime PaymentNotifyTime { get; set; }

        [DisplayName("Payment Body")]
        public string PaymentBody { get; set; }

        [DisplayName("Payment Trade Status")]
        public string PaymentTradeStatus { get; set; }

        [DisplayName("Payment Is Total Fee Adjust")]
        public string PaymentIsTotalFeeAdjust { get; set; }

        [DisplayName("Payment Total Fee")]
        public double? PaymentTotalFee{ get; set; }

        [DisplayName("Payment GMT Payment Time")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}")]
        public DateTime PaymentGMTPayment { get; set; }
        
        [DisplayName("Payment Seller Email")]
        public string PaymentSellerEmail { get; set; }

        [DisplayName("Payment Price")]
        public double? PaymentPrice{ get; set; }

        [DisplayName("Payment NotifyID")]
        public string PaymentNotifyID { get; set; }

        [DisplayName("Payment UseCoupon")]
        public string PaymentUseCoupon { get; set; }

        [DisplayName("Payment SignType")]
        public string PaymentSignType { get; set; }

        [DisplayName("Payment Sign")]
        public string PaymentSign { get; set; }

        [DisplayName("Wechat App Id")]
        public string WeChatAppId { get; set; }

        [DisplayName("Wechat Bank Type")]
        public string WeChatBankType { get; set; }

        [DisplayName("Wechat Cash Fee")]
        public double WeChatCashFee { get; set; }

        [DisplayName("Wechat Fee Type")]
        public string WeChatFeeType { get; set; }

        [DisplayName("Wechat Is Subscribe")]
        public string WeChatIsSubscribe { get; set; }

        [DisplayName("Wechat Merchant Id")]
        public string WeChatMchId { get; set; }

        [DisplayName("Wechat Nonce")]
        public string WeChatNonce { get; set; }

        [DisplayName("Wechat OpenId")]
        public string WeChatOpenId { get; set; }

        [DisplayName("Wechat ResultCode")]
        public string WeChatResultCode { get; set; }

        [DisplayName("Wechat Return Code")]
        public string WeChatReturnCode { get; set; }

        [DisplayName("Wechat Sign")]
        public string WeChatSign { get; set; }

        [DisplayName("Wechat Time End")]
        public string WeChatTimeEnd { get; set; }

        [DisplayName("Wechat Total Fee")]
        public double WeChatTotalFee { get; set; }

        [DisplayName("Wechat Trade Type")]
        public string WeChatTradeType { get; set; }

        [DisplayName("Wechat Transaction Id")]
        public string WeChatTransactionId { get; set; }
    }
}
