﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Web;
    using System.Linq;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;


    public enum PayMethod
    {
        [Display(Name = "尚未支付 Not paid")]
        NotPaid,
        [Display(Name = "代缴点代付 Pay by Vendor in store")]
        ByVendor,
        [Display(Name = "代缴点用户代付 Pay by user with Vendor in store")]
        SelfAtVendor,
        [Display(Name = "用户直付 Pay by User")]
        ByUser,
        [Display(Name = "催缴代付 Pay by Vendor at door")]
        ByVendorAtDoor
    }

    public class CCS_Payment_V1
    {
        /// <summary>
        /// Payment ID is the primary key of this table
        /// </summary>
        [Key]
        public Guid PaymentID { get; set; }

        [DisplayName("缴费类型")]
        public string PaymentType { get; set; }

        [DisplayName("缴费形式")]
        public PayMethod? PaymentMethod { get; set; }

        [DisplayName("支付手机")]
        public string PaymentCellNumber { get; set; }

        [DisplayName("支付时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}", ApplyFormatInEditMode = true)]
        public DateTime PaySubmitTime { get; set; }

        [DisplayName("支付金额")]
        [DisplayFormat(DataFormatString = "{0:F2}", ApplyFormatInEditMode = true)]
        public double Amount { get; set; }

        public Guid BillID { get; set; }

        [ForeignKey("BillID")]
        public virtual CCS_Bill_V1 PaymentBill { get; set; }


        [NotMapped]
        public string UserInputAccountID { get; set; }
    }
}