﻿using System;
using System.Web;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace CCSPrototypeCommon
{
    public class CCS_PhoneMeterProfile_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid PhoneMeterProfileID { get; set; }

        [MaxLength(20)]
        public string PhoneUUID { get; set; }

        [ForeignKey("PhoneUUID")]
        public virtual CCS_PhoneData_V1 PhoneDataTable { get; set; }

        public Guid MeterDataID { get; set; }

        [ForeignKey("MeterDataID")]
        public virtual CCS_MeterData_V1 MeterDataTable { get; set; }

        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime ModifiedDate { get; set; }

    }
}
