﻿namespace CCSPrototypeCommon
{

    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;


    public class CCS_RawData_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid RawDataID { get; set; }

        [DisplayName("计量类型")]
        public string MeasureType { get; set; }
        [DisplayName("表ID")]
        public string MeterID { get; set; }
        [DisplayName("表类型")]
        public string MeterType { get; set; }
        [DisplayName("表型号")]
        public string MeterModel { get; set; }
        [DisplayName("生产厂家")]
        public string Manufacturer { get; set; }
        [DisplayName("使用性质")]
        public string RateSchedule { get; set; }
        [DisplayName("抄表方式")]
        public string ReadType { get; set; }
        [DisplayName("营业所")]
        public string Office { get; set; }
        [DisplayName("表地址")]
        public string MeterAddress { get; set; }
        //[DisplayName("抄见方式")]
        //public string ReadType { get; set; }
        [DisplayName("表读数")]
        public double Read { get; set; }
        [DisplayName("倍率")]
        public double Factor { get; set; }
        [DisplayName("用量")]
        public double Consumption { get; set; }
        [DisplayName("状态")]
        public string Status { get; set; }

        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime UpdateTimeStamp { get; set; }
    }
}
