﻿namespace CCSPrototypeCommon
{

    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public class CCS_StaffInfo_V1
    {

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long StaffInfoID { get; set; }

        public Guid StaffID { get; set; }

        [ForeignKey("StaffID")]
        public virtual CCS_Staff_V1 StaffTable { get; set; }

        [MinLength(1)]
        [MaxLength(255)]
        [Display(Name = "项名/类别", Prompt = "项名/类别")]
        public string Name { get; set; }

        [MaxLength(255)]
        [Display(Name = "值/内容", Prompt = "值/内容")]
        public string Value { get; set; }

        [DefaultValue(DBItemState.Valid)]
        public DBItemState Status { get; set; }

        public CCS_StaffInfo_V1()
        {
            Status = DBItemState.Valid;
        }
    }
}
