﻿
namespace CCSPrototypeCommon
{


    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using System.Data.Entity.Spatial;
    using System.Web.Mvc;

    public class CCS_Staff_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid StaffID { get; set; }

        public Guid CustomerID { get; set; }

        [ForeignKey("CustomerID")]
        public virtual CCS_Customer_V1 CustomerTable { get; set; }

        [Required]
        [MinLength(3)]
        [MaxLength(255)]
        [DisplayName("名称")]
        public string Name { get; set; }

        [Required]
        [MinLength(8)]
        [MaxLength(255)]
        [DisplayName("电话")]
        [Remote("CheckPhoneNumberAvailable", "Merchant", HttpMethod = "POST", ErrorMessage = "该手机号已被注册")]
        [RegularExpression(@"^[1-9][0-9]*$", ErrorMessage = "仅限数字")]
        public string Cellphone { get; set; }

        [DisplayName("账户类型")]
        public OperationLevel Role { get; set; }

        [MinLength(8)]
        [MaxLength(255)]
        [DisplayName("云子SN")]
        public string SNyunzi { get; set; }

        [MaxLength(255)]
        public string ADAccount { get; set; }

        [MaxLength(255)]
        public string ADDomain { get; set; }

        public double latitude { get; set; }

        public double longitude { get; set; }

        public DbGeography geography { get; set; }

        [MaxLength(256)]
        public string Address { get; set; }

        [DefaultValue(CustomerAccountState.Active)]
        public CustomerAccountState State { get; set; }

        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}")]
        public DateTime LastUpdatedDate { get; set; }

        public virtual ICollection<CCS_StaffInfo_V1> StaffInfos { get; set; }

        public CCS_Staff_V1()
        {
            State = CustomerAccountState.Active;
        }


    }

}
