﻿namespace CCSPrototypeCommon
{

    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public class CCS_UserInfo_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long UserInfoID { get; set; }

        public Guid UserID { get; set; }

        [ForeignKey("UserID")]
        public virtual CCS_User_V1 UserTable { get; set; }

        [MinLength(1)]
        [MaxLength(255)]
        [Display(Name = "项名/类别", Prompt = "项名/类别")]
        public string Name { get; set; }

        [MaxLength(255)]
        [Display(Name = "值/内容", Prompt = "值/内容")]
        public string Value { get; set; }

        public DBItemState Status { get; set; }


        [Display(Name = "Device Token", Prompt = "Device Token")]
        public string iOSDeviceToken { get; set; }

    }
}
