﻿
namespace CCSPrototypeCommon
{
    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public enum FavoriteStatus
    {
        [Display(Name = "NoFavorite")]
        NoFavorite = 0,

        [Display(Name = "Favorite")]
        Favorite,

        [Display(Name = "Neutral")]
        Neutral
    }


    public class CCS_UserStaffFavorites_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid UserStaffFavoritesID { get; set; }

        public Guid UserID { get; set; }

        [ForeignKey("UserID")]
        public virtual CCS_User_V1 UserTable { get; set; }

        public Guid StaffID { get; set; }

        [ForeignKey("StaffID")]
        public virtual CCS_Staff_V1 StaffTable { get; set; }

        [DisplayName("Favorite Status")]
        public FavoriteStatus FavoriteStatus { get; set; }

        public DateTime ModifiedDate { get; set; }
    }
}
