﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using Microsoft.WindowsAzure.Storage.Queue;
using CCSPrototypeCommon.Query;
using System.Reflection;
using System.ComponentModel.DataAnnotations;
namespace CCSPrototypeCommon
{
    [Serializable]
    public class FilterCriteriaMsg<T>
    {
        public List<T> filterCriteria { get; set; }
        public string msgID { get; set; }
        public string queryType { get; set; }
        public string subType { get; set; }

        public FilterCriteriaMsg(string id, string queryType, string subType, List<T> filterCriterias)
        {
            this.msgID = id;
            this.queryType = queryType;
            this.subType = subType;
            this.filterCriteria = filterCriterias;
        }
    }

    public static class Extensions
    {
        public static IQueryable<T> ApplySearchCriteria<T>(this IQueryable<T> query, IEnumerable<AbstractFilter> searchCriterias)
        {
            foreach (var criteria in searchCriterias)
            {
                query = criteria.ApplyToQuery(query);
            }

            return query;
        }


        public static byte[] SerializeFilterCriterias<T>(this FilterCriteriaMsg<T> ls)
        {
            BinaryFormatter bf = new BinaryFormatter();
            byte[] output = null;
            using (MemoryStream ms = new MemoryStream())
            {
                ms.Position = 0;
                bf.Serialize(ms, ls);
                output = ms.GetBuffer();
            }
            return output;
        }

        public static FilterCriteriaMsg<T> DeserializeFilterCriteria<T>(this CloudQueueMessage m)
        {
            byte[] buffer = m.AsBytes;
            FilterCriteriaMsg<T> returnValue = default(FilterCriteriaMsg<T>);
            using (MemoryStream ms = new MemoryStream(buffer))
            {
                ms.Position = 0;
                BinaryFormatter bf = new BinaryFormatter();
                returnValue = (FilterCriteriaMsg<T>)bf.Deserialize(ms);
            }
            return returnValue;
        }

        public static string GetDisplayName(this Enum value)
        {
            Type enumType = value.GetType();
            var enumValue = Enum.GetName(enumType, value);
            MemberInfo member = enumType.GetMember(enumValue)[0];

            var attrs = member.GetCustomAttributes(typeof(DisplayAttribute), false);
            var result = ((DisplayAttribute)attrs[0]).Name;

            if (((DisplayAttribute)attrs[0]).ResourceType != null)
            {
                result = ((DisplayAttribute)attrs[0]).GetName();
            }

            return result;
        }

    }
}