﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPrototypeCommon
{
    public class Loggable
    {
        public String getName()
        {
            return this.GetType().Name;
        }

        public void logError(string message)
        {
            var logsContext = (LogsContext)LogsContextFactory.GetInstance().GetDBEFContext();

            if (logsContext == null
               || logsContext.Database == null
               || !logsContext.Database.Exists())
            {
                return ;
            }

            logsContext.SaveChanges();
            CCS_Logs_V1 logItem = new CCS_Logs_V1();
            logItem.LogsID = Guid.NewGuid();
            logItem.Type = LogLevel.ERROR;
            logItem.ClassName = getName();
            logItem.Message = message;
            logItem.ModifiedDate = DateTime.UtcNow;
            logsContext.LogsTable.Add(logItem);
            logsContext.SaveChangesAsync();
            
        }

        public void logException(Exception e)
        {
            String message = "Exception - " + (e != null ? String.Format("Type {0}, Message {1}, StackTrace {2}", e.GetType(), e.Message, e.StackTrace) : "Undefined");

            if (e != null)
            {
                e = e.InnerException;
                message += " InnerException - " + (e != null ? String.Format("Type {0}, Message {1}, StackTrace {2}", e.GetType(), e.Message, e.StackTrace) : "Undefined");
            }

            var logsContext = (LogsContext)LogsContextFactory.GetInstance().GetDBEFContext();

            if (logsContext == null
               || logsContext.Database == null
               || !logsContext.Database.Exists())
            {
                return;
            }

            logsContext.SaveChanges();
            CCS_Logs_V1 logItem = new CCS_Logs_V1();
            logItem.LogsID = Guid.NewGuid();
            logItem.Type = LogLevel.ERROR;
            logItem.ClassName = getName();
            logItem.Message = message;
            logItem.ModifiedDate = DateTime.UtcNow;
            logsContext.LogsTable.Add(logItem);
            logsContext.SaveChangesAsync();

        }



    }
}
