﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel.DataAnnotations;
using System.Linq.Expressions;

namespace CCSPrototypeCommon.Query
{
    public enum TextComparators
    {
        [Display(Name = "Contains")]
        Contains,

        [Display(Name = "==")]
        Equals
    }

    [Serializable]
    public class TextFilter : AbstractFilter
    {
        public string SearchTerm { get; set; }

        public TextComparators Comparator { get; set; }

        public TextFilter()
        {

        }

        public TextFilter(Guid baseSearchID)
        {
            this.BaseSearchID = baseSearchID;
        }

        protected override Expression BuildFilterExpression(Expression property)
        {
            if (this.SearchTerm == null)
            {
                return null;
            }

            var searchExpression = Expression.Call(
                property,
                typeof(string).GetMethod(this.Comparator.ToString(), new[] { typeof(string) }),
                Expression.Constant(this.SearchTerm));

            return searchExpression;
        }

    }
}
