﻿namespace CCSPrototypeCommon
{
    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using System.Data.Entity;
    using System.Linq;
    using System.Web;

    public class UserPasswordContext : DbContext
    {
        private static UserPasswordContext db = null;
        private CookieHelper _cookieHelper = new CookieHelper();
        // Your context has been configured to use a 'Customer' connection string from your application's 
        // configuration file (App.config or Web.config). By default, this connection string targets the 
        // 'HomeWeb.Models.Customer' database on your LocalDb instance. 
        // 
        // If you wish to target a different database and/or database provider, modify the 'Customer' 
        // connection string in the application configuration file.
        public  UserPasswordContext()
            : base("name=BillDbConnectionString")
        {
        }

        private UserPasswordContext(string dbConnString)
            : base(dbConnString)
        {
        }

        public static UserPasswordContext GetInstance()
        {
            if (db == null)
            {
                string dbConnString = Microsoft.Azure.CloudConfigurationManager.GetSetting("BillDbConnectionString");
                db = new UserPasswordContext(dbConnString);
                db.Database.CreateIfNotExists();
            }
            return db;
        }
        // Add a DbSet for each entity type that you want to include in your model. For more information 
        // on configuring and using a Code First model, see http://go.microsoft.com/fwlink/?LinkId=390109.

        public virtual DbSet<CCS_UserPasswords_V1> UserPasswordTable { get; set; }
        public void SetTempVerificationCode(string MobilePhone, string code)
        {
            var record = UserPasswordTable.Where(item => item.MobilePhone == MobilePhone).FirstOrDefault();
            if (record == null)
            {
                UserPasswordTable.Add(new CCS_UserPasswords_V1
                {
                    VerificationCode = code,
                    MobilePhone = MobilePhone,
                    VerificationCodeExpiration = DateTime.Now.AddMinutes(10),
                    Password = ""// empty initial password, invalid for login.
                });
            }
            else
            {
                // record exists, only update verification code, don't touch permant password.
                record.VerificationCode = code;
                record.VerificationCodeExpiration = DateTime.Now.AddMinutes(10);
            }
            this.SaveChangesAsync();
        }

        public bool ReadPasswordFromCookie(HttpRequestBase request, out string mobilePhone, out string password)
        {
            return _cookieHelper.ReadPasswordFromCookie(request, out mobilePhone, out password);
        }

        public enum VerificationFailure
        {
            Passed,
            CodeExpired,
            CodeNotMatch
        }
        public VerificationFailure IsUserAuthenticatedByVerificationCode(string mobilePhone, string code)
        {
            var record = UserPasswordTable.Where(item => item.MobilePhone == mobilePhone).FirstOrDefault();
            if (record != null && record.VerificationCode == code)
            {
                if (record.VerificationCodeExpiration > DateTime.Now)
                    return VerificationFailure.Passed;
                else
                {
                    return VerificationFailure.CodeExpired;
                }
            }

            return VerificationFailure.CodeNotMatch;
        }


        public bool IsUserAuthenticatedByPassword(string mobilePhone, string password)
        {
            var record = UserPasswordTable.Where(item => item.MobilePhone == mobilePhone).FirstOrDefault();
            // password defaults to empty, which is invalid for log in.
            if (record != null && !string.IsNullOrWhiteSpace(record.Password) && record.Password == password)
            {
                return true;
            }

            return false;
        }

        public void CreatePermantPasswordAndWriteIntoCookie(HttpResponseBase response, string mobilePhone)
        {
            var password = CreatePermantPassword();
            var record = UserPasswordTable.Where(item => item.MobilePhone == mobilePhone).FirstOrDefault();
            if (record == null)
            {
                // record must not be null.
               // log the error
                throw new Exception("can't get permant password without verification code.");
            }
            else
            {
                record.Password = password;
            }
            this.SaveChangesAsync();
            _cookieHelper.WritePasswordIntoCookie(response, mobilePhone, password, DateTime.Now.AddYears(1));
        }

        public void InvalidateCookieAndLogOut(HttpSessionStateBase session, HttpResponseBase response)
        {            
            session.Remove("IsUserAuthenticatedByPassword");
            session.Remove("UserMobilePhone");
            session.Remove("IsUserAuthenticatedByVerificationCode");
            _cookieHelper.WritePasswordIntoCookie(response, "", "", DateTime.Now.AddYears(-1));
        }

        static public string CreateRandomVerificationCode()
        {
            return new Random().Next(100000, 999999).ToString();
        }

        static private string CreatePermantPassword()
        {
            return System.Web.Security.Membership.GeneratePassword(8 /*length*/, 2 /*numberOfNonAlphanumericCharacters*/);
        }
    }

    public class CCS_UserPasswords_V1
    {

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid UserPasswordID { get; set; }

        [Required]
        [DisplayName("MobilePhone")]
        public string MobilePhone { get; set; }

        [Required]
        [DisplayName("Code")]
        public string VerificationCode { get; set; }

        [Required]
        [DisplayName("Expiration")]

        public DateTime VerificationCodeExpiration { get; set; }

        [DisplayName("Password")]
        public string Password { get; set; }
    }

}