﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPrototypeCommon
{
    public static partial class Constants
    {
        public const string DataTemplateTableName = "rowdatacolumnmapping";
        public const string AdsBlobContainerName = "advertising";
        public const string AdsBlobArchiveContainerName = "advertisingarchive";
        public const string AdsMultimediaBlobContainerName = "advertisingmedia";
        public const string VendorProfilePictureBlobContainerName = "vendorprofilepic";
        public const string BillStorageName = "bill";
        public const string RawDataStorageName = "rawdata";
        public const string QueryStorageName = "query";
        public const string QueryInitStorageName = "queryinit";
        public const string QueryDownloadStorageName = "querydownload";
        public const string MeterProfileStorageName = "meterprofile";
        public const string PaymentStorageName = "payment";
        public const string NewBillTypeDeclaration = "Create a new bill type";

        public const string AliPayNotifSubject = "subject";
        public const string AliPayNotifTradeNo = "trade_no";
        public const string AliPayNotifBuyerEmail = "buyer_email";

        public const string AliPayNotifDiscount = "discount";
        public const string AliPayNotifType = "payment_type";
        public const string AliPayNotifCreateTime = "gmt_create";
        public const string AliPayNotifNotifyType = "notify_type";
        public const string AliPayNotifQuantity = "quantity";
        public const string AliPayNotifSellerID = "seller_id";
        public const string AliPayNotifNotifyTime = "notify_time";
        public const string AliPayNotifBody = "body";
        public const string AliPayNotifTradeStatus = "trade_status";
        public const string AliPayNotifIsTotalFeeAdjust = "is_total_fee_adjust";
        public const string AliPayNotifTotalFee = "total_fee";
        public const string AliPayNotifGMTPayment = "gmt_payment";
        public const string AliPayNotifSellerEmail = "seller_email";
        public const string AliPayNotifPrice = "price";
        public const string AliPayNotifNotifyID = "notify_id";
        public const string AliPayNotifUseCoupon = "use_coupon";
        public const string AliPayNotifSignType = "sign_type";
        public const string AliPayNotifSign = "sign";

        public const string WeChatAppId = "appid";
        public const string WeChatBankType = "bank_type";
        public const string WeChatCashFee = "cash_fee";
        public const string WeChatFeeType = "fee_type";
        public const string WeChatIsSubscribe = "is_subscribe";
        public const string WeChatMchId = "mch_id";
        public const string WeChatNonce = "nonce_str";
        public const string WeChatOpenId = "openid";
        public const string WeChatResultCode = "result_code";
        public const string WeChatReturnCode = "return_code";
        public const string WeChatSign = "sign";
        public const string WeChatTimeEnd = "time_end";
        public const string WeChatTotalFee = "total_fee";
        public const string WeChatTradeType = "trade_type";
        public const string WeChatTransactionId = "transaction_id";

        // we don't have a customer ID associated with WaterCompany user, for now use below hardcoded value.
        public const string DefaultWaterCompanyCustomerID = "E1581298-5894-44EE-8FE3-7017D09B206B";
    }

    // the constants that used as Session keys
    public static partial class SessionConstants
    {
        public const string CustomerID = "CustomerID";
        public const string CustomerName = "CustomerName";
        public const string CompanyLogo = "CompanyLogo";  //To be used in the future.
    }

    public static partial class ErrorConstants
    {
        public const string NoAssociatedCompany = "Can't find an associated company for this user.";
    }
}
