﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace CCSPrototypeCommon
{
    public static partial class Utility
    {
        public static int ConvertExcelColumnToNum(string column)
        {
            if (string.IsNullOrWhiteSpace(column))
            {
                return -1;
            }
            column = column.ToUpper();
            int result = 0;
            int sequence = 0;
            char[] charArray = column.ToCharArray();
            for (var index = charArray.Length - 1; index >= 0; --index )
            {
                int columnNum = charArray[index] - 'A' + 1;
                if (sequence == 0)
                {
                    result = columnNum;
                    sequence = 26;
                }
                else
                {
                    result += sequence * columnNum;
                    sequence *= 26;
                }
            }
            return result - 1;
        }

        public static string GetCustomerIDFromBlobName(string blobName)
        {
            // Blob path format: CustomerID/yyyy/MMdd/HHmmss.fileExtension
            int index = blobName.IndexOf('/');

            return (index < 0) ? blobName : blobName.Remove(index);
        }

        public static List<string> GetCsvTableHeader(string[] columnArray)
        {
            var result = new List<string>();
            foreach (var column in columnArray)
            {
                if (string.IsNullOrWhiteSpace(column))
                {
                    continue;
                }
                result.Add(column);
            }
            return result;
        }

        public static int GetColumnByHeader(List<string> headerList, string header)
        {
            int result = -1;
            for(int index = 0; index < headerList.Count; ++index)
            {
                if (headerList[index].Equals(header))
                {
                    if (result != -1)
                    {
                        throw new BillDataException("Duplicate header");
                    }
                    result = index;
                }
            }
            if (result == -1)
            {
                throw new BillDataException("Missing header");
            }
            return result;
        }

        public static Dictionary<string, int> GetColumnMappingByHeader(List<string> billHeaderList, List<string> templateHeaderList)
        {
            var result = new Dictionary<string, int>();
            foreach (var templateHeader in templateHeaderList)
            {
                int column = GetColumnByHeader(billHeaderList, templateHeader);
                result.Add(templateHeader, column);
            }
            return result;
        }

        public static BillTemplateTableEntity GetTemplateEntity(string billType, List<BillTemplateTableEntity> templateList)
        {
            if (string.IsNullOrWhiteSpace(billType))
            {
                throw new BillDataException("Not existent bill type");
            }
            if (templateList.Count == 0)
            {
                throw new BillDataException("No template defined");
            }
            foreach (var template in templateList)
            {
                if (template.RowKey.Equals(billType, StringComparison.OrdinalIgnoreCase))
                {
                    return template;
                }
            }
            throw new BillDataException("Not existent bill type");
        }


        public static int GuessColumnByHeaderNames(List<string> headerList, List<string> headerNames)
        {
            for (int index = 0; index < headerList.Count; ++index)
            {
                foreach (var header in headerNames)
                {
                    if (headerList[index].Equals(header))
                    {
                        return index;
                    }
                }
            }
            throw new BillDataException("Missing header");
        }

        public static T ParseEnum<T>(string value)
        {
            return (T)Enum.Parse(typeof(T), value, true);
        }
        

    }
}