﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Configuration;
using CCSAdmin;

namespace CcsAdminTests
{
    [TestClass]
    public class TestInit
    {
        private static readonly string clientId = ConfigurationManager.AppSettings["ida:ClientId"];
        private static readonly string appKey = ConfigurationManager.AppSettings["ida:AppKey"];
        private static readonly string aadInstance = ConfigurationManager.AppSettings["ida:AADInstance"];
        private static readonly string aadTenant = ConfigurationManager.AppSettings["ida:Tenant"];
        private static readonly string aadTenantId = ConfigurationManager.AppSettings["ida:TenantId"];

        private static readonly string graphRoot = ConfigurationManager.AppSettings["ida:GraphUrl"];

        [AssemblyInitialize]
        public static void Setup(TestContext context)
        {
            CcsAdmin.Instance.InitAdminCredentials(clientId, appKey, aadInstance, graphRoot, aadTenant, aadTenantId);

        }
    }
}
