USE [cloudcomspace]
GO

/***CCS_User_V1***/
CREATE TABLE [dbo].[CCS_User_V1] (
    [UserID]       UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [FirstName]    NVARCHAR (MAX)   NULL,
    [MiddleName]   NVARCHAR (MAX)   NULL,
    [LastName]     NVARCHAR (MAX)   NULL,
    [Cellphone]    NVARCHAR (MAX)   NULL,
    [SecondPhone]  NVARCHAR (MAX)   NULL,
    [Email]        NVARCHAR (MAX)   NULL,
    [Address]      NVARCHAR (MAX)   NULL,
    [IDNumber]     NVARCHAR (MAX)   NULL,
    [iOSDeviceToken]      NVARCHAR (MAX)   NULL,
    [ModifiedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_User_V1] PRIMARY KEY CLUSTERED ([UserID] ASC)
);

/***CCS_UserInfo_V1***/
CREATE TABLE [dbo].[CCS_UserInfo_V1] (
    [UserInfoID] BIGINT           IDENTITY (1, 1) NOT NULL,
    [UserID]     UNIQUEIDENTIFIER NOT NULL,
    [Name]       NVARCHAR (MAX)   NULL,
    [Value]      NVARCHAR (MAX)   NULL,
    [Status]     TINYINT          NOT NULL,
    CONSTRAINT [PK_dbo.CCS_UserInfo_V1] PRIMARY KEY CLUSTERED ([UserInfoID] ASC),
    CONSTRAINT [FK_dbo.CCS_UserInfo_V1_dbo.CCS_User_V1_UserID] FOREIGN KEY ([UserID]) REFERENCES [dbo].[CCS_User_V1] ([UserID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_UserID]
    ON [dbo].[CCS_UserInfo_V1]([UserID] ASC);


/***CCS_UserPasswords_V1***/
CREATE TABLE [dbo].[CCS_UserPasswords_V1] (
    [UserPasswordID]             UNIQUEIDENTIFIER NOT NULL,
    [MobilePhone]                NVARCHAR (MAX)   NULL,
    [VerificationCode]           NVARCHAR (MAX)   NULL,
    [Password]                   NVARCHAR (MAX)   NULL,
    [VerificationCodeExpiration] DATETIME         NULL
);


GO
CREATE NONCLUSTERED INDEX [IX_UserPasswordID]
    ON [dbo].[CCS_UserPasswords_V1]([UserPasswordID] ASC);


GO
ALTER TABLE [dbo].[CCS_UserPasswords_V1]
    ADD CONSTRAINT [PK_dbo.UserPassword] PRIMARY KEY CLUSTERED ([UserPasswordID] ASC);


/***CCS_Bill_V1***/
CREATE TABLE [dbo].[CCS_Bill_V1] (
    [BillID]       UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [AmountDue]    FLOAT (53)       NOT NULL,
    [BillType]     NVARCHAR (MAX)   NULL,
    [CustomerID]   UNIQUEIDENTIFIER NOT NULL,
    [UserID]       UNIQUEIDENTIFIER NOT NULL,
    [ModifiedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_Bill_V1] PRIMARY KEY CLUSTERED ([BillID] ASC),
    CONSTRAINT [FK_dbo.CCS_Bill_V1_dbo.CCS_User_V1_UserID] FOREIGN KEY ([UserID]) REFERENCES [dbo].[CCS_User_V1] ([UserID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_UserID]
    ON [dbo].[CCS_Bill_V1]([UserID] ASC);

/***CCS_BillInfo_V1***/
CREATE TABLE [dbo].[CCS_BillInfo_V1] (
    [BillInfoID] BIGINT           IDENTITY (1, 1) NOT NULL,
    [BillID]     UNIQUEIDENTIFIER NOT NULL,
    [Name]       NVARCHAR (MAX)   NULL,
    [Value]      NVARCHAR (MAX)   NULL,
    [Status]     TINYINT          NOT NULL,
    CONSTRAINT [PK_dbo.CCS_BillInfo_V1] PRIMARY KEY CLUSTERED ([BillInfoID] ASC),
    CONSTRAINT [FK_dbo.CCS_BillInfo_V1_dbo.CCS_Bill_V1_BillID] FOREIGN KEY ([BillID]) REFERENCES [dbo].[CCS_Bill_V1] ([BillID]) ON DELETE CASCADE
);

GO
CREATE NONCLUSTERED INDEX [IX_BillID]
    ON [dbo].[CCS_BillInfo_V1]([BillID] ASC);

	
/***CCS_BillTemplate_V1***/
CREATE TABLE [dbo].[CCS_BillTemplate_V1] (
    [BillTemplateID] BIGINT           IDENTITY (1, 1) NOT NULL,
    [CustomerID] UNIQUEIDENTIFIER NOT NULL,
    [BillType]   NVARCHAR (MAX)   NULL,
    [Column]     NVARCHAR (MAX)   NULL,
    [ColumnType] NVARCHAR (MAX)   NULL,
);

GO
CREATE NONCLUSTERED INDEX [IX_BillTemplateID]
    ON [dbo].[CCS_BillTemplate_V1]([BillTemplateID] ASC);

/***CCS_Bill_Joined_V1***/
CREATE TABLE [dbo].[CCS_Bill_Joined_V1] (
    [BillRecID]   BIGINT           IDENTITY (1, 1) NOT NULL,
    [BillID]      UNIQUEIDENTIFIER NOT NULL,
    [CustomerID]  UNIQUEIDENTIFIER NOT NULL,
    [UserID]      UNIQUEIDENTIFIER NOT NULL,
    [FirstName]   NVARCHAR (MAX)   NULL,
    [MiddleName]  NVARCHAR (MAX)   NULL,
    [LastName]    NVARCHAR (MAX)   NULL,
    [Cellphone]   NVARCHAR (MAX)   NULL,
    [SecondPhone] NVARCHAR (MAX)   NULL,
    [Email]       NVARCHAR (MAX)   NULL,
    [Address]     NVARCHAR (MAX)   NULL,
    [IDNumber]    NVARCHAR (MAX)   NULL,
    [Name]        NVARCHAR (MAX)   NULL,
    [Value]       NVARCHAR (MAX)   NULL
);
	
/***CCS_RawData_V1***/
CREATE TABLE [dbo].[CCS_RawData_V1] (
	[RawDataID]		UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
	[MeasureType]		NVARCHAR (MAX)   NOT NULL,
	[MeterID]			NVARCHAR (MAX)   NOT NULL,
	[MeterType]			NVARCHAR (MAX)   NULL,
	[MeterModel]		NVARCHAR (MAX)   NULL,
	[Manufacturer]		NVARCHAR (MAX)   NULL,
    [RateSchedule]		NVARCHAR (MAX)   NULL,
    [ReadType]			NVARCHAR (MAX)   NULL,
	[Office]			NVARCHAR (MAX)   NULL,
	[MeterAddress]		NVARCHAR (MAX)   NULL,
	[Read]				FLOAT (53)   NOT NULL,
    [Factor]			FLOAT (53)   NULL,
	[Consumption]		FLOAT (53)   NOT NULL,
	[Status]			NVARCHAR (MAX)   NULL,
    [UpdateTimeStamp]	DateTime	NULL,
	CONSTRAINT [PK_dbo.CCS_RawData_V1] PRIMARY KEY CLUSTERED ([RawDataID] ASC)
);
	
/***CCS_Customer_V1***/
CREATE TABLE [dbo].[CCS_Customer_V1] (
    [CustomerID]      UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [Name]            NVARCHAR (255)   NOT NULL,
	[DomainName]      NVARCHAR (255)   NOT NULL,
    [Region]          INT              NOT NULL,
    [State]           TINYINT          NOT NULL,
    [LastUpdatedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_Customer_V1] PRIMARY KEY CLUSTERED ([CustomerID] ASC)
);

/***CCS_CustomerInfo_V1***/
CREATE TABLE [dbo].[CCS_CustomerInfo_V1] (
    [CustomerInfoID] BIGINT           IDENTITY (1, 1) NOT NULL,
    [CustomerID]     UNIQUEIDENTIFIER NOT NULL,
    [Name]           NVARCHAR (255)   NULL,
    [Value]          NVARCHAR (255)   NULL,
    [Status]         TINYINT          NOT NULL,
    CONSTRAINT [PK_dbo.CCS_CustomerInfo_V1] PRIMARY KEY CLUSTERED ([CustomerInfoID] ASC),
    CONSTRAINT [FK_dbo.CCS_CustomerInfo_V1_dbo.CCS_Customer_V1_CustomerID] FOREIGN KEY ([CustomerID]) REFERENCES [dbo].[CCS_Customer_V1] ([CustomerID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_CustomerID]
    ON [dbo].[CCS_CustomerInfo_V1]([CustomerID] ASC);

/***CCS_Staff_V1***/
CREATE TABLE [dbo].[CCS_Staff_V1] (
    [StaffID]         UNIQUEIDENTIFIER  DEFAULT (newsequentialid()) NOT NULL,
    [CustomerID]      UNIQUEIDENTIFIER  NOT NULL,
    [Name]            NVARCHAR (255)    NOT NULL,
    [Cellphone]       NVARCHAR (255)    NOT NULL,
    [Role]            TINYINT           NULL,
    [SNyunzi]         NVARCHAR (255)    NULL,
    [ADAccount]       NVARCHAR (255)    NULL,
    [ADDomain]        NVARCHAR (255)    NULL,
    [latitude]        FLOAT (53)        NOT NULL,
    [longitude]       FLOAT (53)        NOT NULL,
    [geography]       [sys].[geography] NULL,
    [Address]         NVARCHAR (256)    NULL,
    [State]           TINYINT           NOT NULL,
    [LastUpdatedDate] DATETIME          NOT NULL,
    CONSTRAINT [PK_dbo.CCS_Staff_V1] PRIMARY KEY CLUSTERED ([StaffID] ASC),
    CONSTRAINT [FK_dbo.CCS_Staff_V1_dbo.CCS_Customer_V1_CustomerID] FOREIGN KEY ([CustomerID]) REFERENCES [dbo].[CCS_Customer_V1] ([CustomerID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_CustomerID]
    ON [dbo].[CCS_Staff_V1]([CustomerID] ASC);

/***CCS_Payment_V1***/
CREATE TABLE [dbo].[CCS_Payment_V1] (
    [PaymentID]         UNIQUEIDENTIFIER NOT NULL,
    [PaymentType]       NVARCHAR (MAX)   NULL,
    [PaymentMethod]     INT              NULL,
    [PaymentCellNumber] NVARCHAR (MAX)   NULL,
    [PaySubmitTime]     DATETIME         NOT NULL,
    [Amount]            FLOAT (53)       NOT NULL,
    [BillID]            UNIQUEIDENTIFIER NOT NULL,
    CONSTRAINT [PK_dbo.CCS_Payment_V1] PRIMARY KEY CLUSTERED ([PaymentID] ASC),
    CONSTRAINT [FK_dbo.CCS_Payment_V1_dbo.CCS_Bill_V1_BillID] FOREIGN KEY ([BillID]) REFERENCES [dbo].[CCS_Bill_V1] ([BillID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_BillID]
    ON [dbo].[CCS_Payment_V1]([BillID] ASC);

/***CCS_PaymentInfo_V1***/
CREATE TABLE [dbo].[CCS_PaymentInfo_V1] (
    [PaymentInfoID]     UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [PaymentID]         UNIQUEIDENTIFIER NOT NULL,
    [PaymentOutTradeNo] NVARCHAR (MAX)   NULL,
    [result]            NVARCHAR (MAX)   NULL,
    CONSTRAINT [PK_dbo.CCS_PaymentInfo_V1] PRIMARY KEY CLUSTERED ([PaymentInfoID] ASC),
    CONSTRAINT [FK_dbo.CCS_PaymentInfo_V1_dbo.CCS_Payment_V1_PaymentID] FOREIGN KEY ([PaymentID]) REFERENCES [dbo].[CCS_Payment_V1] ([PaymentID]) ON DELETE CASCADE
);


GO
CREATE NONCLUSTERED INDEX [IX_PaymentID]
    ON [dbo].[CCS_PaymentInfo_V1]([PaymentID] ASC);



/***CCS_MeterData_V1***/
CREATE TABLE [dbo].[CCS_MeterData_V1] (
    [MeterDataID]  UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [MeterType]    NVARCHAR (MAX) NOT NULL,
    [UserName]    NVARCHAR (MAX) NULL,
    [AccountNumber]  NVARCHAR (MAX) NOT NULL,
    [UserNumber]  NVARCHAR (MAX) NULL,
    [MeterSN]  NVARCHAR (MAX) NULL,
    [MeterID]  NVARCHAR (MAX) NOT NULL,
    [MeterNumber]  NVARCHAR (MAX) NULL,
    [Address]  NVARCHAR (MAX) NULL,
    [ApartmentNumber]  NVARCHAR (MAX) NULL,
    [UserType]    NVARCHAR (MAX) NULL,
    [Office]    NVARCHAR (MAX) NULL,
    [PhoneNumber]    NVARCHAR (MAX) NULL,
    [Memo1]    NVARCHAR (MAX) NULL,
    [Memo2]    NVARCHAR (MAX) NULL,
    [CutoffDate] DATETIME  NULL,
    [CollectType]    NVARCHAR (MAX) NULL,
    [TerminalNumber]    NVARCHAR (MAX) NULL,
    [TerminalAddress]   NVARCHAR (MAX) NULL,
    [TerminalEquipmentID]   NVARCHAR (MAX) NULL,
    [Latitude]   FLOAT (53) NULL,
    [Longitude]  FLOAT (53) NULL,
	[geography]       [sys].[geography] NULL,
    [CreationDate] DATETIME NULL,
    [ModifiedDate] DATETIME NULL,
    CONSTRAINT [PK_dbo.CCS_MeterData_V1] PRIMARY KEY CLUSTERED ([MeterDataID] ASC)
);

/***CCS_MeterData_Sub_V1***/
CREATE TABLE [dbo].[CCS_MeterData_Sub_V1] (
    [MeterDataSubID]    UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [MeterDataID] UNIQUEIDENTIFIER NOT NULL,
    [PictureBlobUri] NVARCHAR (MAX)   NULL,
    CONSTRAINT [PK_dbo.CCS_MeterData_Sub_V1] PRIMARY KEY CLUSTERED ([MeterDataSubID] ASC),
    CONSTRAINT [FK_dbo.CCS_MeterData_Sub_V1_dbo.CCS_MeterData_V1_MeterDataID] FOREIGN KEY ([MeterDataID]) REFERENCES [dbo].[CCS_MeterData_V1] ([MeterDataID]) ON DELETE CASCADE
);


/***CCS_PhoneData_V1***/
CREATE TABLE [dbo].[CCS_PhoneData_V1] (

    [PhoneUUID] NVARCHAR (20)   UNIQUE  NOT NULL,
    [PhoneAccessCode] NVARCHAR (MAX)   NULL,
    [PhoneInfo] NVARCHAR (MAX)   NULL,
    [ModifiedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_PhoneData_V1] PRIMARY KEY CLUSTERED ([PhoneUUID] ASC)
);



/***CCS_PhoneMeterProfile_V1***/
CREATE TABLE [dbo].[CCS_PhoneMeterProfile_V1] (
    [PhoneMeterProfileID]    UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [MeterDataID]      UNIQUEIDENTIFIER  NOT NULL,
    [PhoneUUID]     NVARCHAR (20)   NOT NULL,
    [ModifiedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_PhoneMeterProfile_V1] PRIMARY KEY CLUSTERED 

([PhoneMeterProfileID] ASC),

    CONSTRAINT [FK_dbo.CCS_PhoneMeterProfile_V1_dbo.CCS_PhoneData_V1_PhoneUUID] 

FOREIGN KEY ([PhoneUUID]) REFERENCES [dbo].[CCS_PhoneData_V1] ([PhoneUUID]) ON DELETE 

CASCADE,
    CONSTRAINT [FK_dbo.CCS_PhoneMeterProfile_V1_dbo.CCS_MeterData_V1_MeterDataID] 

FOREIGN KEY ([MeterDataID]) REFERENCES [dbo].[CCS_MeterData_V1] ([MeterDataID]) ON 

DELETE CASCADE
);

GO
CREATE NONCLUSTERED INDEX [IX_PhoneUUID]
    ON [dbo].[CCS_PhoneMeterProfile_V1]([PhoneUUID] ASC);
CREATE NONCLUSTERED INDEX [IX_MeterDataID]
    ON [dbo].[CCS_PhoneMeterProfile_V1]([MeterDataID] ASC);



/***CCS_Payment_AliPayNotif_V1***/
CREATE TABLE [dbo].[CCS_Payment_AliPayNotif_V1] (
    [PaymentNotifID]     UNIQUEIDENTIFIER DEFAULT (newsequentialid()) NOT NULL,
    [PaymentInfoID]         UNIQUEIDENTIFIER NOT NULL,
    [PaymentTradeNo] NVARCHAR (MAX)   NULL,
    [PaymentBuyerEmail]            NVARCHAR (MAX)   NULL,
    [PaymentSubject]            NVARCHAR (MAX)   NULL,
    [PaymentDiscount]       FLOAT (53)        NULL,
    [PaymentType]       INT        NULL,
    [PaymentNotifyType]            NVARCHAR (MAX)   NULL,
    [PaymentQuantity]       INT         NULL,
    [PaymentCreateTime]     DATETIME         NULL,
    [PaymentSellerID]            NVARCHAR (MAX)   NULL,
    [PaymentNotifyTime]     DATETIME         NULL,
    [PaymentBody]            NVARCHAR (MAX)   NULL,
    [PaymentTradeStatus]            NVARCHAR (MAX)   NULL,
    [PaymentIsTotalFeeAdjust]            NVARCHAR (MAX)   NULL,
    [PaymentTotalFee]       FLOAT (53)        NULL,
    [PaymentGMTPayment]     DATETIME         NULL,
    [PaymentSellerEmail]            NVARCHAR (MAX)   NULL,
    [PaymentPrice]       FLOAT (53)        NULL,
    [PaymentNotifyID]     NVARCHAR (MAX)   NULL,
    [PaymentUseCoupon]      NVARCHAR (MAX)   NULL,
    [PaymentSignType]     NVARCHAR (MAX)   NULL,
    [PaymentSign]      NVARCHAR (MAX)   NULL,
    [WeChatAppId]      NVARCHAR (MAX)   NULL,
    [WeChatBankType]      NVARCHAR (MAX)   NULL,
    [WeChatCashFee]      FLOAT (53)   NULL,
    [WeChatFeeType]      NVARCHAR (MAX)   NULL,
    [WeChatIsSubscribe]      NVARCHAR (MAX)   NULL,
    [WeChatMchId]      NVARCHAR (MAX)   NULL,
    [WeChatNonce]      NVARCHAR (MAX)   NULL,
    [WeChatOpenId]      NVARCHAR (MAX)   NULL,
    [WeChatResultCode]      NVARCHAR (MAX)   NULL,
    [WeChatReturnCode]      NVARCHAR (MAX)   NULL,
    [WeChatSign]      NVARCHAR (MAX)   NULL,
    [WeChatTimeEnd]      NVARCHAR (MAX)   NULL,
    [WeChatTotalFee]      FLOAT (53)   NULL,
    [WeChatTradeType]      NVARCHAR (MAX)   NULL,
    [WeChatTransactionId]      NVARCHAR (MAX)   NULL,

    CONSTRAINT [PK_dbo.CCS_Payment_AliPayNotif_V1] PRIMARY KEY CLUSTERED ([PaymentNotifID] ASC),
    CONSTRAINT [FK_dbo.CCS_Payment_AliPayNotif_V1_dbo.CCS_Payment_AliPayNotif_V1_PaymentInfoID] FOREIGN KEY ([PaymentInfoID]) REFERENCES [dbo].[CCS_PaymentInfo_V1] ([PaymentInfoID]) ON DELETE CASCADE
);

GO
CREATE NONCLUSTERED INDEX [IX_PaymentInfoID]
    ON [dbo].[CCS_Payment_AliPayNotif_V1]([PaymentInfoID] ASC);


/***CCS_UserStaffFavorites_V1***/
CREATE TABLE [dbo].[CCS_UserStaffFavorites_V1] (
    [UserStaffFavoritesID]         UNIQUEIDENTIFIER  DEFAULT (newsequentialid()) NOT NULL,
    [UserID]      UNIQUEIDENTIFIER  NOT NULL,
    [StaffID]      UNIQUEIDENTIFIER  NOT NULL,
    [FavoriteStatus]            INT    NULL,
    [ModifiedDate] DATETIME         NOT NULL,
    CONSTRAINT [PK_dbo.CCS_UserStaffFavorites_V1] PRIMARY KEY CLUSTERED ([UserStaffFavoritesID] ASC),
    CONSTRAINT [FK_dbo.CCS_UserStaffFavorites_V1_dbo.CCS_Staff_V1_StaffID] FOREIGN KEY ([StaffID]) REFERENCES [dbo].[CCS_Staff_V1] ([StaffID]) ON DELETE CASCADE,
	CONSTRAINT [FK_dbo.CCS_UserStaffFavorites_V1_dbo.CCS_User_V1_UserID] FOREIGN KEY ([UserID]) REFERENCES [dbo].[CCS_User_V1] ([UserID]) ON DELETE CASCADE
);

	
GO
INSERT INTO [dbo].[CCS_Customer_V1] ([CustomerID], [Name], [DomainName]，[Region], [State], [LastUpdatedDate]) 
VALUES (N'e1581298-5894-44ee-8fe3-7017d09b206b', N'DefaultWaterCompanyCustomerID', N'infoxus.com', 1, 1, N'2008-11-11 13:23:44')

GO

CREATE TABLE [dbo].[CCS_StaffInfo_V1] (
    [StaffInfoID] BIGINT           IDENTITY (1, 1) NOT NULL,
    [StaffID]     UNIQUEIDENTIFIER NOT NULL,
    [Name]        NVARCHAR (255)   NULL,
    [Value]       NVARCHAR (255)   NULL,
    [Status]      TINYINT          NOT NULL
);


GO
CREATE NONCLUSTERED INDEX [IX_StaffID]
    ON [dbo].[CCS_StaffInfo_V1]([StaffID] ASC);


GO
ALTER TABLE [dbo].[CCS_StaffInfo_V1]
    ADD CONSTRAINT [PK_dbo.CCS_StaffInfo_V1] PRIMARY KEY CLUSTERED ([StaffInfoID] ASC);


GO
ALTER TABLE [dbo].[CCS_StaffInfo_V1]
    ADD CONSTRAINT [FK_dbo.CCS_StaffInfo_V1_dbo.CCS_Staff_V1_StaffID] FOREIGN KEY ([StaffID]) REFERENCES [dbo].[CCS_Staff_V1] ([StaffID]) ON DELETE CASCADE;

