﻿using CCSAdmin;
using Owin;
using System;
using System.Configuration;
using System.Globalization;
using System.Threading.Tasks;
using System.Web;
using HomeWeb.Utils;
using Microsoft.IdentityModel.Clients.ActiveDirectory;
using Microsoft.Owin.Security;
using Microsoft.Owin.Security.Cookies;
using Microsoft.Owin.Security.OpenIdConnect;
using Microsoft.Azure;

namespace HomeWeb
{

    public partial class Startup
    {
        //
        // The Client ID is used by the application to uniquely identify itself to Azure AD.
        // The App Key is a credential used to authenticate the application to Azure AD.  Azure AD supports password and certificate credentials.
        // The Metadata Address is used by the application to retrieve the signing keys used by Azure AD.
        // The AAD Instance is the instance of Azure, for example public Azure or Azure China.
        // The Authority is the sign-in URL of the tenant.
        // The Post Logout Redirect Uri is the URL where the user will be redirected after they sign out.
        //
        private static readonly string clientId = CloudConfigurationManager.GetSetting("AADClientId");
        private static readonly string appKey = CloudConfigurationManager.GetSetting("AADAppKey");
        private static readonly string aadInstance = CloudConfigurationManager.GetSetting("AADInstance");
        private static readonly string aadTenant = CloudConfigurationManager.GetSetting("AADTenant");
        private static readonly string postLogoutRedirectUri = CloudConfigurationManager.GetSetting("AADPostLogoutRedirectUri");
        private static readonly string graphRoot = CloudConfigurationManager.GetSetting("AADGraphUrl");
        private static readonly string defaultRoleForNewUser = CloudConfigurationManager.GetSetting("AADDefaultRoleForNewUser");
        private const string AuthorityStringFormat = "{0}/{1}"; //aadAuthRoot/aadTenantName

        public static readonly string Authority = String.Format(AuthorityStringFormat, aadInstance.Trim().TrimEnd('/'), aadTenant.Trim());
        public static OpenIdConnectAuthenticationOptions authenticationOptions = null;

        // This is the resource ID of the AAD Graph API.  We'll need this to request a token to call the Graph API.
//        string graphResourceId = ConfigurationManager.AppSettings["ida:GraphUrl"];
//        private static readonly string graphApiVersion = ConfigurationManager.AppSettings["ida:GraphApiVersion"];
//
        public void ConfigureAuth(IAppBuilder app)
        {
            CcsAdmin.Instance.InitAdminCredentials(clientId, appKey, aadInstance, graphRoot, aadTenant, defaultRoleForNewUser);
            
            AuthenticationHelper.AuthString = Authority;
            AuthenticationHelper.AppId = clientId;
            AuthenticationHelper.AppKey = appKey;

            app.SetDefaultSignInAsAuthenticationType(CookieAuthenticationDefaults.AuthenticationType);

            app.UseCookieAuthentication(new CookieAuthenticationOptions());
            authenticationOptions = new OpenIdConnectAuthenticationOptions
                {

                    ClientId = clientId,
                    Authority = Authority,
                    PostLogoutRedirectUri = postLogoutRedirectUri,

                    Notifications = new OpenIdConnectAuthenticationNotifications()
                    {
                        //
                        // If there is a code in the OpenID Connect response, redeem it for an access token and refresh token, and store those away.
                        //

                        AuthorizationCodeReceived = (context) =>
                        {
                            string code = context.Code;

                            ClientCredential credential = new ClientCredential(clientId, appKey);
                            string userObjectID = context.AuthenticationTicket.Identity.FindFirst(
                                    "http://schemas.microsoft.com/identity/claims/objectidentifier").Value;
                            AuthenticationContext authContext = new AuthenticationContext(Authority, new NaiveSessionCache(userObjectID));
                            AuthenticationResult result = authContext.AcquireTokenByAuthorizationCode(
                                code, new Uri(HttpContext.Current.Request.Url.GetLeftPart(UriPartial.Path)), credential, graphRoot);
                            AuthenticationHelper.Token = result.AccessToken;
                            return Task.FromResult(0);
                        }

                    }

                };
            app.UseOpenIdConnectAuthentication(authenticationOptions);
        }
    }
}