﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Data.Entity.Spatial;

using Newtonsoft.Json;
using CCSAdmin;
using CCSPrototypeCommon;
using Microsoft.Azure;
using HomeWeb.Models;

namespace HomeWeb.Controllers
{
    public class MapController : BaseController
    {
        //private static BillContext _billDB = (BillContext)BillContextFactory.GetInstance().GetDBEFContext();

        // GET: Map
        public ActionResult Index()
        {
            return RedirectToAction("ShowMap");
        }

        //YUZI delimiters
        public static char[] YunziInputDelims = new char[] { ',', '|', ';' };

        //public ActionResult ShowMapMerchantVendor(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
        //    int? StartIndex, int? Count, string ShowType, string Market, string UserId, bool? NavigateOnLoad)
        //{
        //    return ShowMap(CenterLatitude, CenterLongitude, YunziIDs,
        //        StartIndex, Count, ShowType, Market, "merchantvendor", UserId, NavigateOnLoad ?? false);
        //}
        public ActionResult ShowMapMerchantVendor(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
            int? StartIndex, int? Count, string ShowType, string Market, string MapStyle, string UserId, bool? NavigateOnLoad)
        {
            if (!string.IsNullOrEmpty(MapStyle))
            {
                if (MapStyle.ToLower().Contains("merchantfieldstaff"))
                {
                    return RedirectToAction("ShowMapMerchantFieldStaff",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
        }
                else if (MapStyle.ToLower().Contains("merchantmeter"))
                {
                    return RedirectToAction("ShowMapMerchantMeter",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
                }
            }

            int fetchCount = GetFetchCount(Count);
            SetViewBagCommonValues(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, ShowType, Market, UserId, NavigateOnLoad, fetchCount);
            ViewBag.MapStyle = string.IsNullOrEmpty(MapStyle) ? "merchantvendor" : MapStyle;

            List<VendorModel> StaffList = GetStaffList(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, fetchCount);

            return View(StaffList);
        }

        //public ActionResult ShowMapMerchantFieldStaff(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
        //    int? StartIndex, int? Count, string ShowType, string Market, string UserId, bool? NavigateOnLoad)
        //{
        //    return ShowMap(CenterLatitude, CenterLongitude, YunziIDs,
        //        StartIndex, Count, ShowType, Market, "merchantfieldstaff", UserId, NavigateOnLoad ?? false);
        //}
        public ActionResult ShowMapMerchantFieldStaff(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
            int? StartIndex, int? Count, string ShowType, string Market, string MapStyle, string UserId, bool? NavigateOnLoad)
        {

            if (!string.IsNullOrEmpty(MapStyle))
            {
                if (MapStyle.ToLower().Contains("merchantmeter"))
                {
                    return RedirectToAction("ShowMapMerchantMeter",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
        }
                else if (MapStyle.ToLower().Contains("merchantvendor"))
        {
                    return RedirectToAction("ShowMapMerchantVendor",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
                }

            }

            int fetchCount = GetFetchCount(Count);
            SetViewBagCommonValues(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, ShowType, Market, UserId, NavigateOnLoad, fetchCount);
            ViewBag.MapStyle = string.IsNullOrEmpty(MapStyle) ? "merchantfieldstaff" : MapStyle;

            // TO-DO select only Field Staffs only
            List<VendorModel> StaffList = GetStaffList(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, fetchCount);

            return View("ShowMapMerchantVendor", StaffList);

        }

        private List<VendorModel> GetStaffList(double? CenterLatitude, double? CenterLongitude, string YunziIDs, int? StartIndex, int fetchCount)
        {
            List<VendorModel> StaffList = null;

            if (string.IsNullOrEmpty(YunziIDs))
            {
                if (CenterLatitude == null && CenterLongitude == null)
                {
                    StaffList = new List<VendorModel>();
                }
                else
                {
                    StaffList = FetchNearestLocations((double)CenterLatitude, (double)CenterLongitude, fetchCount);
                }
            }
            else
            {
                StaffList = FetchYunziLocations(YunziIDs, StartIndex, fetchCount);
            }
            return StaffList;
        }

        private void SetViewBagCommonValues(double? CenterLatitude, double? CenterLongitude, string YunziIDs, 
            int? StartIndex, string ShowType, string Market, string UserId, bool? NavigateOnLoad, int fetchCount)
        {
            ViewBag.ShowType = ShowType;
            ViewBag.YunziIDs = YunziIDs;
            ViewBag.StartIndex = StartIndex;
            ViewBag.UserId = UserId;
            ViewBag.NavigateOnLoad = NavigateOnLoad ?? true;
            ViewBag.BingMapCred = CloudConfigurationManager.GetSetting("BingMapCredentialKey"); ;
            ViewBag.FetchCount = fetchCount;
            if (CenterLatitude == null || CenterLatitude == 0)
            {
                ViewBag.CenterLatitude = null;
            }
            else
            {
                ViewBag.CenterLatitude = CenterLatitude;
            }

            if (CenterLongitude == null || CenterLongitude == 0)
            {
                ViewBag.CenterLongitude = null;
            }
            else
            {
                ViewBag.CenterLongitude = CenterLongitude;
            }

            ViewBag.Market = GetMarketBasedOnCoordinates(Market, CenterLatitude, CenterLongitude);
        }

        // GET: VendorLocations
        public ActionResult ShowMap(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
            int? StartIndex, int? Count, string ShowType, string Market, string MapStyle, string UserId, bool? NavigateOnLoad)
            {
            if (!string.IsNullOrEmpty(MapStyle))
            {
                if (MapStyle.ToLower().Contains("merchantfieldstaff"))
                {
                    return RedirectToAction("ShowMapMerchantFieldStaff",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
                }
                else if (MapStyle.ToLower().Contains("merchantmeter"))
                {

                    return RedirectToAction("ShowMapMerchantMeter",
                        new
                        {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
                }
                else if (MapStyle.ToLower().Contains("merchant"))
                {
                    return RedirectToAction("ShowMapMerchantVendor",
                        new
                {
                            CenterLatitude = CenterLatitude,
                            CenterLongitude = CenterLongitude,
                            YunziIDs = YunziIDs,
                            StartIndex = StartIndex,
                            Count = Count,
                            ShowType = ShowType,
                            Market = Market,
                            MapStyle = MapStyle,
                            UserId = UserId,
                            NavigateOnLoad = NavigateOnLoad
                        });
                }
                }
                
            int fetchCount = GetFetchCount(Count);
            SetViewBagCommonValues(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, ShowType, Market, UserId, NavigateOnLoad, fetchCount);

            List<VendorModel> StaffList = GetStaffList(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, fetchCount);

            return View(StaffList);
        }

        [HttpPost]
        public JsonResult AddVendorToFavorites(string userid, string staffid)
        {
            try
            {
                using (var vendorEFContext = (BillContext)BillContextFactory.GetInstance().GetDBEFContext())
                {
                    var usersInfo = vendorEFContext.UserStaffFavoritesTable.Where(o => o.UserID.ToString() == userid && o.StaffID.ToString() == staffid).ToList();
                    if (usersInfo.Count() > 1)
                    {
                        return new JsonResult() { Data = new { statuscode = 0, statusmsg = "More than one record with the specified (user id, staff id) is found." }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                    }

                    if (usersInfo.Count() == 0)
                    {
                        CCS_UserStaffFavorites_V1 usersFavorites = new CCS_UserStaffFavorites_V1();
                        usersFavorites.UserID = Guid.Parse(userid);
                        usersFavorites.StaffID = Guid.Parse(staffid);
                        usersFavorites.ModifiedDate = DateTime.UtcNow;
                        usersFavorites.FavoriteStatus = FavoriteStatus.Favorite;

                        vendorEFContext.UserStaffFavoritesTable.Add(usersFavorites);
                        vendorEFContext.SaveChanges();
                        return new JsonResult() { Data = new { statuscode = 1, statusmsg = "It was successfully saved as a new record." }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                    }
                    else
                    {
                        CCS_UserStaffFavorites_V1 usersFavorites = usersInfo[0];
                        usersFavorites.ModifiedDate = DateTime.UtcNow;
                        usersFavorites.FavoriteStatus = FavoriteStatus.Favorite;

                        vendorEFContext.SaveChanges();
                        return new JsonResult() { Data = new { statuscode = 1, statusmsg = "It was successfully saved as an updated record." }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };

                    }
                }
                
            }
            catch (Exception e)
            {
                if(e.InnerException != null)
                    return new JsonResult() { Data = new { statuscode = 0, statusmsg = "InnerException: " + e.InnerException.Message }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                else
                    return new JsonResult() { Data = new { statuscode = 0, statusmsg = "Exception: " + e.Message }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }
            
        }

        private string GetMarketBasedOnCoordinates(string Market, double? CenterLatitude, double? CenterLongitude)
        {
            if (string.IsNullOrEmpty(Market))
            {
                if (CenterLongitude == null || CenterLongitude >= 0)
                {
                    return "zh-cn";
                }
                else
                {
                    return "en-us";
                }
            }
            else if (Market.Equals("en-us", StringComparison.OrdinalIgnoreCase))
            {
                return "en-us";
            }

            return "zh-cn";

        }

        private int GetFetchCount(int? Count)
        {
            int value = Count ?? 10;
            return (value > 50) ? 50 : value;
        }

        public JsonResult GetYunziLocations(string YunziIDs, int? StartIndex, int? Count)
        {
            var vendors = FetchYunziLocations(YunziIDs, StartIndex, Count);
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }

        private List<VendorModel> FetchYunziLocations(string YunziIDs, int? StartIndex, int? Count)
        {

            if (string.IsNullOrEmpty(YunziIDs))
            {
                return new List<VendorModel>();
            }
            int FetchCount = Count ?? 10;

            if (FetchCount < 0)
            {
                return new List<VendorModel>();
            }
            else if (FetchCount > 50)
            {
                FetchCount = 50;
            }
            int FetchStartIndex = StartIndex ?? 0;
            IEnumerable<string> YunziIDArray = YunziIDs.Split(YunziInputDelims, StringSplitOptions.RemoveEmptyEntries);
            IEnumerable<string> QueryArray = null;

            if (FetchStartIndex < 0 || FetchStartIndex >= YunziIDArray.Count())
            {
                return new List<VendorModel>();
            }
            else
            {
                QueryArray = YunziIDArray.Skip(FetchStartIndex).Take(FetchCount);
            }
            List<VendorModel> resultList = null;
            using (var vendorEFContext = (VendorContext)VendorContextFactory.GetInstance().GetDBEFContext())
            {
                vendorEFContext.Configuration.LazyLoadingEnabled = false;
                var staffs = (from b in vendorEFContext.StaffTable.AsNoTracking().Where(s => (s.State == CustomerAccountState.Active))
                    where QueryArray.Contains(b.SNyunzi)
                    select b);
                if (User.IsInRole(OperationLevel.Staff.ToString()))
                {
                    staffs = staffs.Where(r => (r.Role == OperationLevel.Vendor ||
                        r.Role == OperationLevel.Gatherer ||
                        r.Role == OperationLevel.MeterReader));
                }
                else if (User.IsInRole(OperationLevel.Admin.ToString()))
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Staff);
                }
                else
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Vendor);
                }
                foreach (var staff in staffs)
                {
                    staff.geography = null;
                    var vendorModel = new VendorModel();
                    vendorModel.StaffTable = staff;
                    vendorModel.ProfilePictureUri = GetProfilePictureUri(staff.StaffID.ToString());
                    resultList.Add(vendorModel);
                }
            }
            return CreateReturnList(resultList, QueryArray);
        }

        private List<VendorModel> CreateReturnList(List<VendorModel> SortTarget, IEnumerable<string> KeyArray)
        {
            var ResultList = new List<VendorModel>();
            if (SortTarget == null || SortTarget.Count() < 1
                || KeyArray == null || KeyArray.Count() < 1)
            {
                return ResultList;
            }
            var dic = new Dictionary<string, VendorModel>();

            foreach (VendorModel staff in SortTarget)
            {
                if (dic.ContainsKey(staff.StaffTable.SNyunzi))
                {
                    continue;
                }
                else
                {
                    staff.StaffTable.geography = null;
                    dic.Add(staff.StaffTable.SNyunzi, staff);
                }
            }

            foreach (string key in KeyArray)
            {
                if (dic.ContainsKey(key))
                {
                    ResultList.Add(dic[key]);
                }
            }
            return ResultList;
        }


        public JsonResult GetLocations(double latitude, double longitude, int? Count)
        {
            var vendors = FetchNearestLocations(latitude, longitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }


        public JsonResult GetMoreLocations(double latitude, double longitude, double? beginLatitude, double? beginLongitude, int? Count)
        {
            var vendors = FetchNearestLocations(latitude, longitude, beginLatitude, beginLongitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }

        public JsonResult GetPreviousLocations(double latitude, double longitude, double? beginLatitude, double? beginLongitude, int? Count)
        {
            var vendors = FetchFarestLocations(latitude, longitude, beginLatitude, beginLongitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }

        private List<VendorModel> FetchNearestLocations(double centerLatitude, double centerLongitude, int Count)
        {
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));
            var returnList = new List<VendorModel>();
            using (var vendorEFContext = (VendorContext)VendorContextFactory.GetInstance().GetDBEFContext())
            {
                vendorEFContext.Configuration.LazyLoadingEnabled = false;
                var staffs = (from b in vendorEFContext.StaffTable.AsNoTracking().Where(s => (s.State == CustomerAccountState.Active))
                              where b.geography != null
                              orderby b.geography.Distance(defaultLoc)
                              select b).Take(Count);
                if (User.IsInRole(OperationLevel.Staff.ToString()))
                {
                    staffs = staffs.Where(r => (r.Role == OperationLevel.Vendor ||
                        r.Role == OperationLevel.Gatherer ||
                        r.Role == OperationLevel.MeterReader));
                }
                else if (User.IsInRole(OperationLevel.Admin.ToString()))
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Staff);
                }
                else
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Vendor);
                }
                foreach (var staff in staffs)
                {
                    staff.geography = null;
                    var vendorModel = new VendorModel();
                    vendorModel.StaffTable = staff;
                    vendorModel.ProfilePictureUri = GetProfilePictureUri(staff.StaffID.ToString());
                    returnList.Add(vendorModel);
                }
            }
            return returnList;
        }

        private List<VendorModel> FetchNearestLocations(double centerLatitude, double centerLongitude,
            double? beginLatitude, double? beginLongitude, int Count = 10)
        {

            if (beginLatitude == null || beginLongitude == null)
            {
                return FetchNearestLocations(centerLatitude, centerLongitude, Count);
            }
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));
            var beginLoc = DbGeography.FromText(string.Format("POINT({1} {0})", beginLatitude, beginLongitude));

            double? distance = beginLoc.Distance(defaultLoc);

            var returnList = new List<VendorModel>();
            using (var vendorEFContext = (VendorContext)VendorContextFactory.GetInstance().GetDBEFContext())
            {
                vendorEFContext.Configuration.LazyLoadingEnabled = false;
                var staffs = (from b in vendorEFContext.StaffTable.AsNoTracking().Where(s => (s.State == CustomerAccountState.Active))
                              where b.geography != null
                              where b.geography.Distance(defaultLoc) > distance
                              orderby b.geography.Distance(defaultLoc)
                              select b).Take(Count);
                if (User.IsInRole(OperationLevel.Staff.ToString()))
                {
                    staffs = staffs.Where(r => (r.Role == OperationLevel.Vendor ||
                        r.Role == OperationLevel.Gatherer ||
                        r.Role == OperationLevel.MeterReader));
                }
                else if (User.IsInRole(OperationLevel.Admin.ToString()))
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Staff);
                }
                else
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Vendor);
                }
                foreach (var staff in staffs)
                {
                    staff.geography = null;
                    var vendorModel = new VendorModel();
                    vendorModel.StaffTable = staff;
                    vendorModel.ProfilePictureUri = GetProfilePictureUri(staff.StaffID.ToString());
                    returnList.Add(vendorModel);
                }
            }
            return returnList;
        }

        private List<VendorModel> FetchFarestLocations(double centerLatitude, double centerLongitude,
            double? endLatitude, double? endLongitude, int Count)
        {

            if (endLatitude == null || endLongitude == null)
            {
                return FetchNearestLocations(centerLatitude, centerLongitude, Count);
            }
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));
            var beginLoc = DbGeography.FromText(string.Format("POINT({1} {0})", endLatitude, endLongitude));

            double? distance = beginLoc.Distance(defaultLoc);

            var returnList = new List<VendorModel>();

            using (var vendorEFContext = (VendorContext)VendorContextFactory.GetInstance().GetDBEFContext())
            {
                vendorEFContext.Configuration.LazyLoadingEnabled = false;
                var staffs = (from b in vendorEFContext.StaffTable.AsNoTracking().Where(s => (s.State == CustomerAccountState.Active))
                              where b.geography != null
                              where b.geography.Distance(defaultLoc) < distance
                              orderby b.geography.Distance(defaultLoc) descending
                              select b).Take(Count);
                if (User.IsInRole(OperationLevel.Staff.ToString()))
                {
                    staffs = staffs.Where(r => (r.Role == OperationLevel.Vendor ||
                        r.Role == OperationLevel.Gatherer ||
                        r.Role == OperationLevel.MeterReader));
                }
                else if (User.IsInRole(OperationLevel.Admin.ToString()))
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Staff);
                }
                else
                {
                    staffs = staffs.Where(r => r.Role == OperationLevel.Vendor);
                }
                foreach (var staff in staffs)
                {
                    staff.geography = null;
                    var vendorModel = new VendorModel();
                    vendorModel.StaffTable = staff;
                    vendorModel.ProfilePictureUri = GetProfilePictureUri(staff.StaffID.ToString());
                    returnList.Add(vendorModel);
                }
                returnList.Reverse();
            }
            return returnList;
        }


        public ActionResult ShowMapMerchantMeter(double? CenterLatitude, double? CenterLongitude, string YunziIDs,
            int? StartIndex, int? Count, string ShowType, string Market, string MapStyle, string UserId, bool? NavigateOnLoad)
        {
            int fetchCount = GetFetchCount(Count);
            SetViewBagCommonValues(CenterLatitude, CenterLongitude, YunziIDs, StartIndex, ShowType, Market, UserId, NavigateOnLoad, fetchCount);
            ViewBag.MapStyle = string.IsNullOrEmpty(MapStyle) ? "merchantmeter" : MapStyle;

            FillInAllGeo();

            List<CCS_MeterData_V1> MeterList = null;
            if (CenterLatitude == null && CenterLongitude == null)
            {
                MeterList = new List<CCS_MeterData_V1>();
            }
            else
            {
                MeterList = FetchNearestMeters((double)CenterLatitude, (double)CenterLongitude, fetchCount);
            }

            return View(MeterList);
            }

        private void FillInAllGeo()
        {
            using (var TempDBContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                TempDBContext.Configuration.LazyLoadingEnabled = false;
                var meters = (from b in TempDBContext.MeterDataTable
                              where b.Latitude != null && b.Longitude != null
                              && (b.geography == null || b.geography.Latitude != b.Latitude || b.geography.Longitude != b.Longitude)
                              select b);

                foreach (var m in meters)
            {
                    m.geography = DbGeography.FromText(string.Format("POINT({1} {0})", m.Latitude, m.Longitude));
                    TempDBContext.Entry(m).State = System.Data.Entity.EntityState.Modified;
            }

                if (meters.Count() > 0)
                {
                    TempDBContext.SaveChanges();
                }
                }
        }

        private List<CCS_MeterData_V1> FetchNearestMeters(double centerLatitude, double centerLongitude, int Count)
        {
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));

            List<CCS_MeterData_V1> returnList = new List<CCS_MeterData_V1>();
            using (var TempDBContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                TempDBContext.Configuration.LazyLoadingEnabled = false;
                var meters = (from b in TempDBContext.MeterDataTable
                              where b.Latitude != null && b.Longitude != null
                              orderby defaultLoc.Distance(b.geography)
                              select b).Take(Count);

                foreach (var m in meters)
                {
                    m.geography = null;
                }

                returnList = meters.ToList();
            }

            return returnList;
        }

        public JsonResult GetMeters(double latitude, double longitude, int? Count)
        {
            var vendors = FetchNearestMeters(latitude, longitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }


        public JsonResult GetMoreMeters(double latitude, double longitude, double? beginLatitude, double? beginLongitude, int? Count)
        {
            var vendors = FetchNearestMeters(latitude, longitude, beginLatitude, beginLongitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }

        public JsonResult GetPreviousMeters(double latitude, double longitude, double? beginLatitude, double? beginLongitude, int? Count)
        {
            var vendors = FetchFarestMeters(latitude, longitude, beginLatitude, beginLongitude, GetFetchCount(Count));
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }


        private List<CCS_MeterData_V1> FetchNearestMeters(double centerLatitude, double centerLongitude,
            double? beginLatitude, double? beginLongitude, int Count = 10)
        {

            if (beginLatitude == null || beginLongitude == null)
            {
                return FetchNearestMeters(centerLatitude, centerLongitude, Count);
            }
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));
            var beginLoc = DbGeography.FromText(string.Format("POINT({1} {0})", beginLatitude, beginLongitude));

            double? distance = beginLoc.Distance(defaultLoc);

            List<CCS_MeterData_V1> returnList = new List<CCS_MeterData_V1>();
            using (var TempDBContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                TempDBContext.Configuration.LazyLoadingEnabled = false;
                var meters = (from b in TempDBContext.MeterDataTable
                              where b.Latitude != null && b.Longitude != null
                                && defaultLoc.Distance(b.geography) > distance
                              orderby defaultLoc.Distance(b.geography)
                              select b).Take(Count);

                foreach (var m in meters)
                {
                    m.geography = null;
                }

                returnList = meters.ToList();
            }

            return returnList;
        }

        private List<CCS_MeterData_V1> FetchFarestMeters(double centerLatitude, double centerLongitude,
            double? endLatitude, double? endLongitude, int Count)
        {

            if (endLatitude == null || endLongitude == null)
            {
                return FetchNearestMeters(centerLatitude, centerLongitude, Count);
            }
            var defaultLoc = DbGeography.FromText(string.Format("POINT({1} {0})", centerLatitude, centerLongitude));
            var beginLoc = DbGeography.FromText(string.Format("POINT({1} {0})", endLatitude, endLongitude));

            double? distance = beginLoc.Distance(defaultLoc);

            List<CCS_MeterData_V1> returnList = new List<CCS_MeterData_V1>();

            using (var TempDBContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                TempDBContext.Configuration.LazyLoadingEnabled = false;
                var meters = (from b in TempDBContext.MeterDataTable

                              where b.Latitude != null && b.Longitude != null
                                && defaultLoc.Distance(b.geography) < distance
                              orderby defaultLoc.Distance(b.geography) descending
                              select b).Take(Count);

                foreach (var m in meters)
                {
                    m.geography = null;
                }

                returnList = meters.ToList();
                returnList.Reverse();

            }

            return returnList;
        }


        public JsonResult GetsMeterPhotos(string MeterID)
        {
            var vendors = FetchMeterSubInfos(MeterID);
            return Json(vendors, JsonRequestBehavior.AllowGet);
        }

        private List<CCS_MeterData_Sub_V1> FetchMeterSubInfos(string MeterID)
        {
            Guid QueryGuid = new Guid();
            if (string.IsNullOrEmpty(MeterID)
                && !Guid.TryParse(MeterID,out QueryGuid))
            {
                return new List<CCS_MeterData_Sub_V1>();
            }

            List<CCS_MeterData_Sub_V1> returnList = new List<CCS_MeterData_Sub_V1>();
            using (var TempDBContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                TempDBContext.Configuration.LazyLoadingEnabled = false;
                var meters = from b in TempDBContext.MeterDataSubTable
                             where b.MeterDataID == QueryGuid
                             select b;

                returnList = meters.ToList();
            }

            return returnList;
        }

    }
}
