﻿using System.Web;
using System.Web.Mvc;
using System.Security.Claims;
using Microsoft.IdentityModel.Clients.ActiveDirectory;
using Microsoft.Owin.Security;
using Microsoft.Owin.Security.Cookies;
using Microsoft.Owin.Security.OpenIdConnect;
using HomeWeb.Utils;
using HomeWeb.Models;
namespace HomeWeb.Controllers
{
    public class PartnerController : Controller
    {

        public ActionResult Index()
        {
            return View();
        }

        public void SignIn()
        {
            // Send an OpenID Connect sign-in request.
            if (!Request.IsAuthenticated)
            {
                HttpContext.GetOwinContext()
                    .Authentication.Challenge(new AuthenticationProperties { RedirectUri = Request.Headers["Referer"] },
                        OpenIdConnectAuthenticationDefaults.AuthenticationType);
                Startup.authenticationOptions.PostLogoutRedirectUri = Request.Headers["Referer"];
            }
        }

        public void SignOut()
        {
            // should move customerID to claims, instead of keeping it in session.
            Session.Remove(CCSPrototypeCommon.SessionConstants.CustomerID);

            // Remove all cache entries for this user and send an OpenID Connect sign-out request.
            string userObjectID =
                ClaimsPrincipal.Current.FindFirst("http://schemas.microsoft.com/identity/claims/objectidentifier").Value;
            AuthenticationContext authContext = new AuthenticationContext(Startup.Authority,
                new NaiveSessionCache(userObjectID));
            authContext.TokenCache.Clear();
            AuthenticationHelper.Token = null;
            HttpContext.GetOwinContext().Authentication.SignOut(
                OpenIdConnectAuthenticationDefaults.AuthenticationType, CookieAuthenticationDefaults.AuthenticationType);
        }


    }
}
