﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Microsoft.Azure;
using System.Collections.Specialized;

using CCSAdmin;
using CCSPrototypeCommon;
using CCSPrototypeCommon.Query;
using HomeWeb.Models;
using System.Reflection;
using PagedList;
namespace HomeWeb.Controllers
{
    public class PaymentsController : QueryableController
    {
        private PaymentContext _paymentDB = null;

        public PaymentsController()
        {
            _paymentDB = (PaymentContext)PaymentContextFactory.GetInstance().GetDBEFContext();
        }

        public ActionResult QueryPayments()
        {
            return this.RedirectToAction("QueryFiltersUI", new { queryType = "PaymentQuery" });
        }

        //protected override IEnumerable<string> FillQueryBaseTypeList()
        //{
        //    List<string> QueryTypes = new List<string>();
        //    QueryTypes.Add("用户缴费历史");
        //    QueryTypes.Add("代缴点缴费历史");
        //    QueryTypes.Add("催缴员缴费历史");
        //    return QueryTypes;
        //}

        protected override IEnumerable<PropertyInfo> GetProperties(QueryType queryType)
        {
            List<PropertyInfo> result = new List<PropertyInfo>();
            result.AddRange((typeof(CCS_Payment_V1)).GetProperties().Where(x => x.Name != "UserInputAccountID" && x.Name != "PaymentCellNumber"));
            return result;
        }

        protected override string GetAssemblyQualifiedName()
        {
            return typeof(CCS_Payment_V1).AssemblyQualifiedName;
        }

        public override ActionResult QueryBillResultPaged(int? page)
        {
            IEnumerable<CCS_Payment_V1> result = (IEnumerable<CCS_Payment_V1>)Session["filterResults"];

            int pageNumber = page ?? 1;

            return PartialView("_QueryResults", result.ToPagedList(pageNumber, PageList_PageSize));
        }
        public override ActionResult QueryBillResult(FormCollection collection)
        {

            
            IEnumerable<CCS_Payment_V1> result = FilterApplied<CCS_Payment_V1>(collection);

            


            int pageNumber = 1;

            return PartialView("_QueryResults", result.ToPagedList(pageNumber, PageList_PageSize));
        }

        [HttpPost]
        public ActionResult QueryResultWithID(string UserIDForPaymentQuery)
        {
            //string UserID = collection["UserIDForPaymentQuery"] as string;

            if (string.IsNullOrEmpty(UserIDForPaymentQuery))
            {
                return PartialView("_QueryResults");
            }

            IEnumerable<CCS_Payment_V1> result = (from p in _paymentDB.PaymentTable
                                                  where p.PaymentCellNumber == UserIDForPaymentQuery
                                                  select p).ToList();
            int pageSize = 6;
            int pageNumber = 1;
            ViewBag.Title = "缴费历史记录";

            return PartialView("_QueryResults", result.ToPagedList(pageNumber, pageSize));
        }

        public override IEnumerable<T> GetQueryResult<T>(FormCollection collection, List<AbstractFilter> searchCriteria, QueryType queryType)
        {
            IQueryable<CCS_Payment_V1> payments;
            IEnumerable<CCS_Payment_V1> result = null;

            string UserID = collection["UserIDForPaymentQuery"] as string;

            if (string.IsNullOrEmpty(UserID))
            {
                return new List<T>();
            }

            var TType = typeof(T);
            if (TType != typeof(CCS_Payment_V1))
            {
                return new List<T>();
            }

            try
            {
                payments = (from p in _paymentDB.PaymentTable
                            //where p.PaymentType == BaseType
                            where p.PaymentCellNumber == UserID
                            select p).ApplySearchCriteria(searchCriteria.AsEnumerable());

            }
            catch (Exception e)
            {
                throw new HttpException(500, e.Message);
            }
            result = payments.ToList();
            return result as IEnumerable<T>;
        }

        /*/ GET: Payments
        public ActionResult Index()
        {
            return View(BillCommon.getPaymentsWithLinkingToBill(db));
        }
        */

        // GET: Payments/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            CCS_Payment_V1 payment = _paymentDB.PaymentTable.Find(id);
            if (payment == null)
            {
                return HttpNotFound();
            }
            return View(payment);
        }
        /*
        public ActionResult PayBalance(int? id)
        {
            if (id == null)
            {
                return RedirectToAction("Index", "Bills");
            }
            Bill bill = db.Bills.Find(id);

            if (bill == null)
            {
                return RedirectToAction("Index", "Bills");
            }
            Payment newPayment = new Payment();
            newPayment.PaymentBill = bill;
            newPayment.BillID = bill.BillID;
            newPayment.Amount = bill.AmountDue;

            //return View(newPayment);
            return View("Create", newPayment);
        }*/

        public ActionResult PayBalance(Guid id)
        {
            if (id == null)
            {
                return RedirectToAction("Index", "Bills");
            }
            CCS_Bill_V1 ccsBill = _paymentDB.BillTable.Find(id);

            if (ccsBill == null)
            {
                return RedirectToAction("Index", "Bills");
            }


            CCS_Payment_V1 newPayment = new CCS_Payment_V1();
            newPayment.BillID = id;
            newPayment.Amount = ccsBill.AmountDue;

            //return View(newPayment);
            //return View("Create", newPayment);
            return View("Details", newPayment);
        }


        //// GET: Payments/Create
        //public ActionResult Create()
        //{
        //    return View();
        //}

        // POST: Payments/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public JsonResult Create([Bind(Include = "PaymentID,PaymentType,PaymentMethod,PaymentCellNumber,Amount,BillID")] CCS_Payment_V1 payment)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    payment.PaymentID = Guid.NewGuid();
                    payment.PaySubmitTime = DateTime.Now;
                    _paymentDB.PaymentTable.Add(payment);
                    _paymentDB.SaveChanges();
                }
            }
            catch (Exception)
            {

            }


            return new JsonResult() { Data = new { paymentId = payment.PaymentID, amount = payment.Amount }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
        }

        // POST: Payments/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public JsonResult CreatePaymentAliPay([Bind(Include = "PaymentID,PaymentType,PaymentMethod,PaymentCellNumber,Amount,BillID")] CCS_Payment_V1 payment)
        {
            String paymentOutTradeNo = null;
            try
            {
                if (ModelState.IsValid)
                {
                    payment.PaymentID = Guid.NewGuid();
                    payment.PaySubmitTime = DateTime.Now;
                    _paymentDB.PaymentTable.Add(payment);
                    CCS_PaymentInfo_V1 paymentInfo = new CCS_PaymentInfo_V1();
                    paymentInfo.PaymentID = payment.PaymentID;
                    paymentInfo.PaymentOutTradeNo = getOutTradeNoAliPay();
                    _paymentDB.PaymentInfoTable.Add(paymentInfo);

                    paymentOutTradeNo = paymentInfo.PaymentOutTradeNo;


                    _paymentDB.SaveChanges();
                }
            }
            catch (Exception)
            {

            }

            if (payment == null || paymentOutTradeNo == null)
            {
                return null;
            }


            return new JsonResult() { Data = new { paymentId = payment.PaymentID, amount = payment.Amount, outTradeNo = paymentOutTradeNo }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
        }

        // POST: Payments/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public JsonResult CreatePaymentWeChat([Bind(Include = "PaymentID,PaymentType,PaymentMethod,PaymentCellNumber,Amount,BillID")] CCS_Payment_V1 payment)
        {
            String paymentOutTradeNo = null;
            try
            {
                if (ModelState.IsValid)
                {
                    payment.PaymentID = Guid.NewGuid();
                    payment.PaySubmitTime = DateTime.Now;
                    _paymentDB.PaymentTable.Add(payment);

                    CCS_PaymentInfo_V1 paymentInfo = new CCS_PaymentInfo_V1();
                    paymentInfo.PaymentID = payment.PaymentID;
                    paymentInfo.PaymentOutTradeNo = getOutTradeNoWeChat();
                    _paymentDB.PaymentInfoTable.Add(paymentInfo);

                    paymentOutTradeNo = paymentInfo.PaymentOutTradeNo;



                    _paymentDB.SaveChanges();
                }
            }
            catch (Exception)
            {

            }


            if (payment == null || paymentOutTradeNo == null)
            {
                return null;
            }


            return new JsonResult() { Data = new { paymentId = payment.PaymentID, amount = payment.Amount, outTradeNo = paymentOutTradeNo }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };

        }

        /**
        * get the out_trade_no for an order. 生成商户订单号，该值在商户端应保持唯一（可自定义格式规范）
        *
        */
        public String getOutTradeNoAliPay()
        {
            /*String key = DateTime.UtcNow.ToString("MMddHHmmss");
            Random rnd = new Random();
            key += rnd.Next(Int32.MinValue, Int32.MaxValue);
            key = key.Substring(0, 15);
            return key;*/
            return Guid.NewGuid().ToString().Replace("-", "");
        }

        public String getOutTradeNoWeChat()
        {
            return Guid.NewGuid().ToString().Replace("-", "");
        }



        //// GET: Payments/Edit/5
        //public ActionResult Edit(long? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Payment payment = db.Payments.Find(id);
        //    if (payment == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(payment);
        //}

        //// POST: Payments/Edit/5
        //// To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        //// more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public ActionResult Edit([Bind(Include = "PaymentID,PaymentType,PaymentMethod,PaymentCellNumber,PaySubmitTime")] Payment payment)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Entry(payment).State = EntityState.Modified;
        //        db.SaveChanges();
        //        return RedirectToAction("Index");
        //    }
        //    return View(payment);
        //}

        //// GET: Payments/Delete/5
        //public ActionResult Delete(long? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Payment payment = db.Payments.Find(id);
        //    if (payment == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(payment);
        //}

        // POST: Payments/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        //public ActionResult DeleteConfirmed(long id)
        //{
        //    Payment payment = db.Payments.Find(id);
        //    db.Payments.Remove(payment);
        //    db.SaveChanges();
        //    return RedirectToAction("Index");
        //}


        //public ActionResult PayAll(string userInputID)
        //{
        //    List<Bill> bills = BillCommon.getBillListWithInputID(db, userInputID);

        //    if (bills == null)
        //    {
        //        return RedirectToAction("Index", "Bills", new { userInputID = userInputID });
        //    }

        //    foreach (Bill oneBill in bills)
        //    {
        //        oneBill.AmountDue = 0;
        //        //account.UserInputAccountID = UserInputAccountID;
        //        db.Entry(oneBill).State = System.Data.Entity.EntityState.Modified;
        //    }

        //    db.SaveChanges();
        //    return View("Index", "Bills", bills);
        //}

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                _paymentDB.Dispose();
            }
            base.Dispose(disposing);
        }


        [HttpPost]
        public void PaymentNotifyAction(string trade_status, string out_trade_no, string trade_no)
        {

            var paymentsInfo = _paymentDB.PaymentInfoTable.Where(o => o.PaymentOutTradeNo == out_trade_no).ToList();
            if (paymentsInfo.Count() != 1)
                return;
            //paymentsInfo[0].result = trade_status + " " + trade_no;

            paymentsInfo[0].result = "start result";
            _paymentDB.SaveChanges();

            CCS_Payment_AliPayNotif_V1 paymentAliPayNotif = new CCS_Payment_AliPayNotif_V1();
            paymentAliPayNotif.PaymentInfoID = paymentsInfo[0].PaymentInfoID;

            paymentsInfo[0].result += "start result2";
            _paymentDB.SaveChanges();

            SortedDictionary<string, string> sArray = new SortedDictionary<string, string>();
            NameValueCollection coll;
            //Load Form variables into NameValueCollection variable.
            coll = Request.Form;
            if (ContainsKey(coll, Constants.AliPayNotifSubject))
            {
                paymentAliPayNotif.PaymentSubject = coll[Constants.AliPayNotifSubject];
                paymentsInfo[0].result += "s" + paymentAliPayNotif.PaymentSubject;
                _paymentDB.SaveChanges();
            }
            if (ContainsKey(coll, Constants.AliPayNotifTradeNo))
            {
                paymentAliPayNotif.PaymentTradeNo = coll[Constants.AliPayNotifTradeNo];
                paymentsInfo[0].result += "s2" + paymentAliPayNotif.PaymentTradeNo;
                _paymentDB.SaveChanges();
            }
            if (ContainsKey(coll, Constants.AliPayNotifBuyerEmail))
            {
                paymentAliPayNotif.PaymentBuyerEmail = coll[Constants.AliPayNotifBuyerEmail];
                paymentsInfo[0].result += "s3" + paymentAliPayNotif.PaymentBuyerEmail;
                _paymentDB.SaveChanges();
            }

            if (ContainsKey(coll, Constants.AliPayNotifDiscount))
            {
                double num;
                if (double.TryParse(coll[Constants.AliPayNotifDiscount], out num))
                {
                    paymentAliPayNotif.PaymentDiscount = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifType))
            {
                int num;
                if (int.TryParse(coll[Constants.AliPayNotifType], out num))
                {
                    paymentAliPayNotif.PaymentType = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifNotifyType))
            {
                paymentAliPayNotif.PaymentNotifyType = coll[Constants.AliPayNotifNotifyType];
            }


            if (ContainsKey(coll, Constants.AliPayNotifQuantity))
            {
                int num;
                if (int.TryParse(coll[Constants.AliPayNotifQuantity], out num))
                {
                    paymentAliPayNotif.PaymentQuantity = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifCreateTime))
            {
                DateTime num;
                if (DateTime.TryParse(coll[Constants.AliPayNotifCreateTime], out num))
                {
                    paymentAliPayNotif.PaymentCreateTime = num;
                }
            }


            if (ContainsKey(coll, Constants.AliPayNotifSellerID))
            {
                paymentAliPayNotif.PaymentSellerID = coll[Constants.AliPayNotifSellerID];
            }

            if (ContainsKey(coll, Constants.AliPayNotifNotifyTime))
            {
                DateTime num;
                if (DateTime.TryParse(coll[Constants.AliPayNotifNotifyTime], out num))
                {
                    paymentAliPayNotif.PaymentNotifyTime = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifBody))
            {
                paymentAliPayNotif.PaymentBody = coll[Constants.AliPayNotifBody];
            }

            if (ContainsKey(coll, Constants.AliPayNotifTradeStatus))
            {
                paymentAliPayNotif.PaymentTradeStatus = coll[Constants.AliPayNotifTradeStatus];
            }

            if (ContainsKey(coll, Constants.AliPayNotifIsTotalFeeAdjust))
            {
                paymentAliPayNotif.PaymentIsTotalFeeAdjust = coll[Constants.AliPayNotifIsTotalFeeAdjust];
            }

            if (ContainsKey(coll, Constants.AliPayNotifTotalFee))
            {
                double num;
                if (double.TryParse(coll[Constants.AliPayNotifTotalFee], out num))
                {
                    paymentAliPayNotif.PaymentTotalFee = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifGMTPayment))
            {
                DateTime num;
                if (DateTime.TryParse(coll[Constants.AliPayNotifGMTPayment], out num))
                {
                    paymentAliPayNotif.PaymentGMTPayment = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifSellerEmail))
            {
                paymentAliPayNotif.PaymentSellerEmail = coll[Constants.AliPayNotifSellerEmail];
            }

            if (ContainsKey(coll, Constants.AliPayNotifPrice))
            {
                double num;
                if (double.TryParse(coll[Constants.AliPayNotifPrice], out num))
                {
                    paymentAliPayNotif.PaymentPrice = num;
                }
            }

            if (ContainsKey(coll, Constants.AliPayNotifNotifyID))
            {
                paymentAliPayNotif.PaymentNotifyID = coll[Constants.AliPayNotifNotifyID];
            }

            if (ContainsKey(coll, Constants.AliPayNotifUseCoupon))
            {
                paymentAliPayNotif.PaymentUseCoupon = coll[Constants.AliPayNotifUseCoupon];
            }

            if (ContainsKey(coll, Constants.AliPayNotifSignType))
            {
                paymentAliPayNotif.PaymentSignType = coll[Constants.AliPayNotifSignType];
            }

            if (ContainsKey(coll, Constants.AliPayNotifSign))
            {
                paymentAliPayNotif.PaymentSign = coll[Constants.AliPayNotifSign];
            }

            paymentsInfo[0].result += "s7";
            _paymentDB.SaveChanges();

            //paymentsInfo[0].result = trade_status + " " + trade_no;


            _paymentDB.PaymentAliPayNotif.Add(paymentAliPayNotif);
            _paymentDB.SaveChanges();

        }
        private static bool ContainsKey(NameValueCollection collection, string key)
        {
            if (collection.Get(key) == null)
            {
                return collection.AllKeys.Contains(key);
            }

            return true;
        }


        [HttpPost]
        public void PaymentNotifyActionWeChat()//(string trade_status, string out_trade_no, string trade_no)
        {


            //接收从微信后台POST过来的数据
            System.IO.Stream s = Request.InputStream;
            int count = 0;
            byte[] buffer = new byte[1024];
            System.Text.StringBuilder builder = new System.Text.StringBuilder();
            while ((count = s.Read(buffer, 0, 1024)) > 0)
            {
                builder.Append(System.Text.Encoding.UTF8.GetString(buffer, 0, count));
            }
            s.Flush();
            s.Close();
            s.Dispose();

            //转换数据格式并验证签名
            WxPayData data = new WxPayData();
            try
            {
                data.FromXml(builder.ToString());
            }
            catch (Exception ex)
            {

                //若签名错误，则立即返回结果给微信支付后台
                WxPayData res = new WxPayData();
                res.SetValue("return_code", "FAIL");
                res.SetValue("return_msg", ex.Message);

            }

            //检查支付结果中transaction_id是否存在
            if (!data.IsSet("out_trade_no"))
            {


                //若out_trade_no不存在，则立即返回结果给微信支付后台
                WxPayData res = new WxPayData();
                res.SetValue("return_code", "FAIL");
                res.SetValue("return_msg", "out_trade_no is not set");

            }

            string out_trade_no = data.GetValue("out_trade_no").ToString();

            var paymentsInfo = _paymentDB.PaymentInfoTable.Where(o => o.PaymentOutTradeNo == out_trade_no).ToList();
            if (paymentsInfo.Count() != 1)
            {
                paymentsInfo[0].result = out_trade_no + " out_trade_no is not in our database or is in more than one row";

                _paymentDB.SaveChanges();

                return;
            }
            try
            {


                CCS_Payment_AliPayNotif_V1 paymentAliPayNotif = new CCS_Payment_AliPayNotif_V1();

                paymentAliPayNotif.PaymentInfoID = paymentsInfo[0].PaymentInfoID;

                paymentsInfo[0].result += "result";


                SortedDictionary<string, string> coll = new SortedDictionary<string, string>();
                foreach (KeyValuePair<string, object> kv in data.m_values)
                {
                    string key = kv.Key;
                    string value = kv.Value as string;
                    if (value != null)
                    {
                        coll.Add(key, value);
                    }
                }

                if (coll.ContainsKey(Constants.WeChatAppId))
                {
                    paymentAliPayNotif.WeChatAppId = coll[Constants.WeChatAppId];

                }

                if (coll.ContainsKey(Constants.WeChatBankType))
                {
                    paymentAliPayNotif.WeChatBankType = coll[Constants.WeChatBankType];

                }

                if (coll.ContainsKey(Constants.WeChatFeeType))
                {
                    paymentAliPayNotif.WeChatFeeType = coll[Constants.WeChatFeeType];

                }

                if (coll.ContainsKey(Constants.WeChatIsSubscribe))
                {
                    paymentAliPayNotif.WeChatIsSubscribe = coll[Constants.WeChatIsSubscribe];

                }

                if (coll.ContainsKey(Constants.WeChatMchId))
                {
                    paymentAliPayNotif.WeChatMchId = coll[Constants.WeChatMchId];

                }

                if (coll.ContainsKey(Constants.WeChatNonce))
                {
                    paymentAliPayNotif.WeChatNonce = coll[Constants.WeChatNonce];

                }

                if (coll.ContainsKey(Constants.WeChatResultCode))
                {
                    paymentAliPayNotif.WeChatResultCode = coll[Constants.WeChatResultCode];

                }

                if (coll.ContainsKey(Constants.WeChatReturnCode))
                {
                    paymentAliPayNotif.WeChatReturnCode = coll[Constants.WeChatReturnCode];

                }

                if (coll.ContainsKey(Constants.WeChatSign))
                {
                    paymentAliPayNotif.WeChatSign = coll[Constants.WeChatSign];

                }

                if (coll.ContainsKey(Constants.WeChatTimeEnd))
                {
                    paymentAliPayNotif.WeChatTimeEnd = coll[Constants.WeChatTimeEnd];

                }

                if (coll.ContainsKey(Constants.WeChatOpenId))
                {
                    paymentAliPayNotif.WeChatOpenId = coll[Constants.WeChatOpenId];

                }

                if (coll.ContainsKey(Constants.WeChatTradeType))
                {
                    paymentAliPayNotif.WeChatTradeType = coll[Constants.WeChatTradeType];

                }

                if (coll.ContainsKey(Constants.WeChatTransactionId))
                {
                    paymentAliPayNotif.WeChatTransactionId = coll[Constants.WeChatTransactionId];

                }

                if (coll.ContainsKey(Constants.WeChatTotalFee))
                {
                    double num;
                    if (double.TryParse(coll[Constants.WeChatTotalFee], out num))
                    {
                        paymentAliPayNotif.WeChatTotalFee = num;
                    }

                }

                if (coll.ContainsKey(Constants.WeChatCashFee))
                {
                    double num;
                    if (double.TryParse(coll[Constants.WeChatCashFee], out num))
                    {
                        paymentAliPayNotif.WeChatCashFee = num;
                    }

                }


                string result = "";
                foreach (KeyValuePair<string, object> kv in data.m_values)
                {
                    string key = kv.Key;
                    result += "Key: " + key;
                    string value = kv.Value as string;
                    if (value == null)
                    {
                        result += " Value: NULL\n";
                    }
                    else
                    {
                        result += " Value: " + value + "\n";
                    }
                }
                paymentsInfo[0].result = result;

                DateTime num2;
                if (DateTime.TryParse("1/1/2015", out num2))
                {
                    paymentAliPayNotif.PaymentGMTPayment = num2;
                }
                if (DateTime.TryParse("1/1/2015", out num2))
                {
                    paymentAliPayNotif.PaymentNotifyTime = num2;
                }

                if (DateTime.TryParse("1/1/2015", out num2))
                {
                    paymentAliPayNotif.PaymentCreateTime = num2;
                }


                _paymentDB.PaymentAliPayNotif.Add(paymentAliPayNotif);
                _paymentDB.SaveChanges();

            }
            catch (Exception e)
            {
                paymentsInfo[0].result += e.Message;

                _paymentDB.SaveChanges();
            }

        }


    }
}