﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CCSPrototypeCommon;
using System.Net;
using System.Web.Script.Serialization;
using System.Threading.Tasks;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage.Queue;
using Microsoft.WindowsAzure.Storage.RetryPolicies;
using Microsoft.WindowsAzure.Storage.Table;
using Microsoft.WindowsAzure.ServiceRuntime;
using System.IO;
using Newtonsoft.Json;

namespace HomeWeb.Controllers
{
    public class RawDataController : QueryableController
    {
        private RawDataContext _rawDataDB = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext();

        static private CloudBlobContainer _meterProfileBlobContainer;
        static private CloudQueue _meterProfileQueue;

        public class AccessCodeModel
        {
            public string AccessCode { get; set; }
            public string DeviceId { get; set; }
        }

        public class MeterProfileModel
        {
            public string MeterID { get; set; }
            public string MeterType { get; set; }
            public double Latitude { get; set; }
            public double Longitude { get; set; }

            public string PhoneUUID { get; set; }

            public MeterProfileModel(string MeterID, string MeterType, double Latitude, double Longitude, string PhoneUUID)
            {
                this.MeterID = MeterID;
                this.MeterType = MeterType;
                this.Latitude = Latitude;
                this.Longitude = Longitude;
                this.PhoneUUID = PhoneUUID;
            }
        }


         public RawDataController() : base()
         {
             InitializeCloudStorage();
         }

        // GET: Phone
        public ActionResult Index()
        {
            long? id = 1;
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            var phoneData = _rawDataDB.PhoneDataTable.All(x => x.PhoneUUID == "cc357fbf4895fd6e");
            if (phoneData == null)
            {
                return HttpNotFound();
            }
            return View(phoneData);

       
        }

        [HttpPost]
        public JsonResult VerifyAccessCode(AccessCodeModel accessCodeModel)
        {
            try
            {
                if (accessCodeModel == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(access code model)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                string DeviceId = accessCodeModel.DeviceId;
                string AccessCode = accessCodeModel.AccessCode;

                if (DeviceId == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(device id)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (AccessCode == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(accesscode)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (String.IsNullOrEmpty(DeviceId))
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDEMPTY + "(device id)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (String.IsNullOrEmpty(AccessCode))
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDEMPTY + "(access code)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (_rawDataDB.PhoneDataTable == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone data table)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                var phoneData = _rawDataDB.PhoneDataTable.Where(x => x.PhoneUUID == DeviceId).ToList();

                if (phoneData == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone data)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if(phoneData.Count == 0)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.DEVICEIDNOTWHITELISTED }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (phoneData.Count > 1)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.CONSISTENCYERROR }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }


                var phoneInfo = phoneData.First();

                if (phoneInfo == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone info)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if(phoneInfo.PhoneAccessCode == AccessCode)
                {

                    if (_rawDataDB.PhoneMeterProfileTable == null)
                    {
                        return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone meter profile table)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                    }

                    var metersInfo = _rawDataDB.PhoneMeterProfileTable.Where(x => x.PhoneUUID == phoneInfo.PhoneUUID).ToList();
                    List<MeterProfileModel> list = new List<MeterProfileModel>();
                    foreach (var m in metersInfo)
                    {
                        if(m != null && m.MeterDataTable != null)
                            list.Add(new MeterProfileModel(m.MeterDataTable.MeterID, m.MeterDataTable.MeterType, m.MeterDataTable.Latitude, m.MeterDataTable.Longitude, DeviceId));
                    }
                    var jsonMeterProfiles = new JavaScriptSerializer().Serialize(list);


                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.SUCCESS, statusMsg = GetMeterProfilesStatusMsg.SUCCESSACCESSCODE, meterData = jsonMeterProfiles }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }
                return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.ACCESSCODEINCORRECT,}, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }
            catch (Exception ex)
            {
                return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDEXCPETION + ex.Message }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }

        }

        enum GetMeterProfilesStatusCode
        {
            FAILURE = -1,
            SUCCESS = 200
        };

        static class GetMeterProfilesStatusMsg
        {
            
            static public String DEVICEIDNOTWHITELISTED = "Device id is not whitelisted";
            static public String ACCESSCODEINCORRECT = "Incorrect access code";
            static public String UNEXPECTEDNULL = "Object is null";
            static public String UNEXPECTEDEMPTY = "Object is empty";
            static public String UNEXPECTEDEXCPETION = "Exception is thrown: ";
            static public String CONSISTENCYERROR = "Consistency error(more than on device with this id is found)"; static public String PHONEDATAISNULLOREMPTY = "No phone data record found/undefined";
            static public String SUCCESSACCESSCODE = "Access code verified successfully.";
            static public String SUCCESSDOWNLOADMETERS = "Meter data have been successfully downloaded.";
        }

        [HttpPost]
        public JsonResult GetMeterProfiles(AccessCodeModel accessCodeModel)
        {
            try{
                if (accessCodeModel == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(access code model)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                string DeviceId = accessCodeModel.DeviceId;
  
                if(DeviceId == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(device id)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (String.IsNullOrEmpty(DeviceId))
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDEMPTY + "(device id)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if(_rawDataDB.PhoneDataTable == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone data table)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                var phoneData = _rawDataDB.PhoneDataTable.Where(x => x.PhoneUUID == DeviceId).ToList();
            
                if (phoneData == null)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone data)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if(phoneData.Count == 0)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.DEVICEIDNOTWHITELISTED }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }

                if (phoneData.Count > 1)
                {
                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.CONSISTENCYERROR }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }


                var phoneInfo = phoneData.First();

                if (phoneInfo != null)
                {

                    if (_rawDataDB.PhoneMeterProfileTable == null)
                    {
                        return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone meter profile table)" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                    }

                    var metersInfo = _rawDataDB.PhoneMeterProfileTable.Where(x => x.PhoneUUID == phoneInfo.PhoneUUID).ToList();
                    List<MeterProfileModel> list = new List<MeterProfileModel>();
                    foreach (var m in metersInfo)
                    {
                        if(m != null && m.MeterDataTable != null)
                            list.Add(new MeterProfileModel(m.MeterDataTable.MeterID, m.MeterDataTable.MeterType, m.MeterDataTable.Latitude, m.MeterDataTable.Longitude, DeviceId));
                    }
                    var jsonMeterProfiles = new JavaScriptSerializer().Serialize(list);


                    return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.SUCCESS, statusMsg = GetMeterProfilesStatusMsg.SUCCESSDOWNLOADMETERS, meterData = jsonMeterProfiles }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                }
                return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDNULL + "(phone info)", meterData = GetMeterProfilesStatusMsg.SUCCESSDOWNLOADMETERS }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }
            catch(Exception ex)
            {
                return new JsonResult() { Data = new { statusCode = GetMeterProfilesStatusCode.FAILURE, statusMsg = GetMeterProfilesStatusMsg.UNEXPECTEDEXCPETION + ex.Message }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }
            
            
        }

        //[Authorize(Roles = "Staff, Admin, SysAdmin")]
        public ActionResult ViewMeterInfo(Guid? MeterDataID)
        {
            if (MeterDataID == null)
            {
                return PartialView("_ViewMeterInfo");
            }
            List<CCS_MeterData_Sub_V1> MeterSubInfos = null;
            using (var dbContext = (RawDataContext)RawDataContextFactory.GetInstance().GetDBEFContext())
            {
                dbContext.Configuration.LazyLoadingEnabled = false;
                var temp = dbContext.MeterDataSubTable.Where(x => x.MeterDataID == MeterDataID);

                if (temp.Count() < 1)
                {
                    CCS_MeterData_Sub_V1 EmptySubInfo = new CCS_MeterData_Sub_V1();
                    EmptySubInfo.MeterDataID = MeterDataID ?? new Guid();
                    EmptySubInfo.MeterDataTable = dbContext.MeterDataTable.Find(MeterDataID);
                    MeterSubInfos = new List<CCS_MeterData_Sub_V1>();
                    if (EmptySubInfo.MeterDataTable != null)
                    {
                        MeterSubInfos.Add(EmptySubInfo);
                    }
                }
                else
                {
                    if (dbContext.Entry(temp.First()).Reference(x=>x.MeterDataTable).IsLoaded == false)
                    {
                        dbContext.Entry(temp.First()).Reference(x => x.MeterDataTable).Load();
                    }

                    MeterSubInfos = temp.ToList();
                }
            }

            //List<string> PhotoUrls = GetPhotoURLs(MeterSubInfos);

            return PartialView("_ViewMeterInfo", MeterSubInfos);

        }



        private List<string> GetPhotoURLs(List<CCS_MeterData_Sub_V1> MeterSubInfos)
        {
            List<string> PhotoUrls = new List<string>();

            foreach(CCS_MeterData_Sub_V1 info in MeterSubInfos)
            {
                PhotoUrls.Add(info.PictureBlobUri);
            }

            return PhotoUrls;
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        //[Authorize(Roles = "Staff")]
        public async Task<ActionResult> UploadMeterProfile(HttpPostedFileBase uploadFile)
        {
            string nextView = "UploadMeterProfile";

            if (ModelState.IsValid)
            {
                if (uploadFile == null || uploadFile.ContentLength == 0)
                {
                    ViewBag.UploadMsg = "Nothing to upload. Please choose a file.";
                }
                else
                {
                    // Blob path format: CustomerID/yyyy/MMdd/HHmmss.fileExtension
                    string dateTimeFormat = "yyyy/MMdd/HHmmss";
                    const string prefix = "Meter Profile";
                    string blobName = String.Format("{0}-{1}{2}", prefix, DateTime.Now.ToString(dateTimeFormat), Path.GetExtension(uploadFile.FileName));
                    CloudBlockBlob fileBlob = _meterProfileBlobContainer.GetBlockBlobReference(blobName);

                    // Upload local csv file to blob storage
                    using (var fileStream = uploadFile.InputStream)
                    {
                        await fileBlob.UploadFromStreamAsync(fileStream);
                    }

                    if (fileBlob == null)
                    {
                        ViewBag.UploadMsg = string.Format("Uploading file '{0}' is unsuccessful", uploadFile.FileName);
                    }
                    else
                    {
                        string[] columns = null;
                        using (Stream fs = fileBlob.OpenRead())
                        {
                            StreamReader csv = new StreamReader(fs);
                            // Get header
                            string line = csv.ReadLine();
                            columns = line.Split(',');
                        }
                        if (columns == null)
                        {
                            ViewBag.UploadMsg = "This file is not supported";
                        }

                        MeterProfileQueueMsg queueMsg = new MeterProfileQueueMsg()
                        {
                            CustomerID = null,  // Reserved for now
                            BlobName = blobName
                        };
                        var queueMsgString = await Task.Factory.StartNew(() => JsonConvert.SerializeObject(queueMsg));
                        CloudQueueMessage queueMessage = new CloudQueueMessage(queueMsgString);
                        await _meterProfileQueue.AddMessageAsync(queueMessage);
                        return RedirectToAction(nextView, new { uploadMsg = "File uploaded" });
                    }
                }
            }
            return View(nextView);
        }

        public ActionResult UploadMeterProfile(string uploadMsg)
        {
            ViewBag.uploadMsg = uploadMsg;
            return View();
        }

        private void InitializeCloudStorage()
        {
            // Open storage account
            CloudStorageAccount storageAccount = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageConnectionString"));
            CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();
            blobClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);

            _meterProfileBlobContainer = blobClient.GetContainerReference(CCSPrototypeCommon.Constants.MeterProfileStorageName);
            _meterProfileBlobContainer.CreateIfNotExists();

            // Get queue context object
            CloudQueueClient queueClient = storageAccount.CreateCloudQueueClient();
            queueClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);
            _meterProfileQueue = queueClient.GetQueueReference(CCSPrototypeCommon.Constants.MeterProfileStorageName);
            _meterProfileQueue.CreateIfNotExists();
        }

        [HttpPost]
        public JsonResult UploadMeterInfoMobile()
        {
            string data = "NA";
            string responseMsg = "NA";
            try
            {
                data = new System.IO.StreamReader(Request.InputStream).ReadToEnd();
                /*System.IO.Stream stream = Request.InputStream;
                // Blob path format: CustomerID/yyyy/MMdd/HHmmss.fileExtension
                string dateTimeFormat = "yyyy/MMdd/HHmmss";
                // to do: remove customerID hardcode 
                var customerID = "EBCTest";
                const string prefix = "Raw Data";
                string blobName = String.Format("{0}-{1}/{2}{3}", prefix, customerID, DateTime.Now.ToString(dateTimeFormat), "Filename");
                CloudBlockBlob fileBlob = _rawDataBlobContainer.GetBlockBlobReference(blobName);
                responseMsg += " Uploading " + blobName;
                // Upload local csv file to blob storage

                using (var fileStream = stream)
                {
                    responseMsg += " start ";
                    fileBlob.UploadFromStream(fileStream);
                }
                responseMsg += " done ";
                if (fileBlob == null)
                {
                    responseMsg += " fileblob is null ";
                }
                else
                {
                    responseMsg += " fileblob is NOT null ";

                    string[] columns = null;
                    using (Stream fs = fileBlob.OpenRead())
                    {
                        StreamReader csv = new StreamReader(fs);
                        // Get header
                        string line = csv.ReadLine();
                        columns = line.Split(',');
                    }
                    if (columns == null)
                    {
                        responseMsg += " This file is not supported ";
                    }
                    else
                    {
                        responseMsg += " This file is  supported ";

                        RawDataQueueMsg queueMsg = new RawDataQueueMsg()
                        {
                            MeasureType = null,  // Reserved for now
                            BlobName = blobName
                        };
                        var queueMsgString = JsonConvert.SerializeObject(queueMsg);
                        CloudQueueMessage queueMessage = new CloudQueueMessage(queueMsgString);
                        _rawDataQueue.AddMessageAsync(queueMessage);
                        responseMsg += " File uploaded ";
                    }


                }*/

            }
            catch (Exception ex)
            {
                return new JsonResult() { Data = new { statusCode = "Sucess", statusMsg = ex.Message }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
            }
            responseMsg = "Successfully uploaded the data." + data.Length + " " + data.Substring(0,50);
            return new JsonResult() { Data = new { statusCode = "Sucess", statusMsg = responseMsg  }, JsonRequestBehavior = JsonRequestBehavior.AllowGet };
        }

      
    }
}