﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Threading.Tasks;
using System.IO;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.Storage.RetryPolicies;
using CCSPrototypeCommon;
using HomeWeb.Models;
using Microsoft.WindowsAzure.Storage.Queue;
using Newtonsoft.Json;
using Microsoft.WindowsAzure.Storage.Table;
namespace HomeWeb.Controllers
{
    public class SampleUploadController : Controller
    {

        private CloudBlobContainer _billBlobContainer;
        private CloudQueue _billQueue;
        static private CloudQueue filesQueue;
        private CloudTable _billTemplateTable;
        public SampleUploadController()
        {
            InitializeCloudStorage();
        }
        // GET: SampleUpload
        public ActionResult Index()
        {
            return View();
        }
        private void InitializeCloudStorage()
        {

            // Open storage account
            CloudStorageAccount storageAccount = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageConnectionString"));
            CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();
            blobClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);



            // Get queue context object
            CloudQueueClient queueClient = storageAccount.CreateCloudQueueClient();
            queueClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);
            filesQueue = queueClient.GetQueueReference(CCSPrototypeCommon.Constants.BillStorageName);

            //filesQueue.CreateIfNotExists();


            blobClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);
            _billBlobContainer = blobClient.GetContainerReference(CCSPrototypeCommon.Constants.BillStorageName);
            //_billBlobContainer.CreateIfNotExists();


            _billQueue = queueClient.GetQueueReference(CCSPrototypeCommon.Constants.BillStorageName);
            //_billQueue.CreateIfNotExists();


            CloudTableClient tableClient = storageAccount.CreateCloudTableClient();
            tableClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);
            _billTemplateTable = tableClient.GetTableReference(CCSPrototypeCommon.Constants.DataTemplateTableName);
            //_billTemplateTable.CreateIfNotExists();





        }
        //[Authorize(Roles = "Staff")]
        public ActionResult UploadData(string uploadMsg)
        {
            ViewBag.UploadMsg = uploadMsg;
            var customerId = "E1581298-5894-44EE-8FE3-7017D09B206B";
            var query = new TableQuery<BillTemplateTableEntity>().Where(
                TableQuery.GenerateFilterCondition("PartitionKey",
                QueryComparisons.Equal, customerId));
            var billTypeList = new List<string>();
            var billTemplateEntityList = new List<BillTemplateTableEntity>();
            foreach (var entity in _billTemplateTable.ExecuteQuery(query))
            {
                billTypeList.Add(entity.RowKey);
                billTemplateEntityList.Add(entity);
            }
            billTypeList.Add(CCSPrototypeCommon.Constants.NewBillTypeDeclaration);
            Session["BillTemplateTableEntity"] = billTemplateEntityList;
            var list = new SelectList(billTypeList);
            ViewBag.billTypeList = list;

            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> UploadData(HttpPostedFileBase uploadFile)
        {
            string nextView = "UploadData";
            string billType = "oneWater";
            if (ModelState.IsValid)
            {
                if (uploadFile == null || uploadFile.ContentLength == 0)
                {
                    ViewBag.UploadMsg = "Nothing to upload. Please choose a file.";
                }
                else
                {
                    if (billType.Equals(CCSPrototypeCommon.Constants.NewBillTypeDeclaration))
                    {
                        billType = string.Empty;
                    }
                    // Blob path format: CustomerID/yyyy/MMdd/HHmmss.fileExtension
                    string dateTimeFormat = "yyyy/MMdd/HHmmss";
                    // to do: remove customerID hardcode 
                    var customerID = "E1581298-5894-44EE-8FE3-7017D09B206B";
                    string blobName = String.Format("{0}/{1}{2}", customerID, DateTime.Now.ToString(dateTimeFormat), Path.GetExtension(uploadFile.FileName));
                    CloudBlockBlob fileBlob = _billBlobContainer.GetBlockBlobReference(blobName);

                    // Upload local csv file to blob storage
                    using (var fileStream = uploadFile.InputStream)
                    {
                        await fileBlob.UploadFromStreamAsync(fileStream);
                    }
                    if (fileBlob == null)
                    {
                        ViewBag.UploadMsg = string.Format("Uploading file '{0}' is unsuccessful", uploadFile.FileName);
                    }
                    else
                    {
                        if (Session["BillTemplateTableEntity"] == null)
                        {
                            return RedirectToAction(nextView, new { uploadMsg = "Please try again" });
                        }
                        var billTemplateEntityList = (List<BillTemplateTableEntity>)Session["BillTemplateTableEntity"];
                        string[] columns = null;
                        using (Stream fs = fileBlob.OpenRead())
                        {
                            StreamReader csv = new StreamReader(fs);
                            // Header
                            string line = csv.ReadLine();
                            columns = line.Split(',');
                        }
                        if (columns == null)
                        {
                            ViewBag.UploadMsg = "This file is not supported";
                        }
                        try
                        {
                            var billTemplate = Utility.GetTemplateEntity(billType, billTemplateEntityList);
                            var billTemplateMapping = Utility.GetColumnMappingByHeader(new List<string>(columns), billTemplate.GetColumnList());
                        }
                        catch (BillDataException billExp)
                        {
                            var billTemplateModel = new BillTemplateModel()
                            {
                                BillType = billType,
                                BillHeaderList = Utility.GetCsvTableHeader(columns),
                                BillTemplateColumnList = BillTemplateTableEntity.GetColumnDefinationList()
                            };
                            ViewBag.UploadMsg = billExp;
                            Session["uploadBlobName"] = blobName;
                            nextView = "SetBillTemplate";
                            return View(nextView, billTemplateModel);
                        }
                        var queueMsg = new BillQueueMsg()
                        {
                            BillType = billType,
                            BlobName = blobName
                        };
                        nextView = "UploadData";
                        var queueMsgString = await Task.Factory.StartNew(() => JsonConvert.SerializeObject(queueMsg));
                        CloudQueueMessage queueMessage = new CloudQueueMessage(queueMsgString);
                        await _billQueue.AddMessageAsync(queueMessage);
                        return RedirectToAction(nextView, new { uploadMsg = "File uploaded" });
                    }
                }
            }
            return View(nextView);
        }
    }
}