﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CCSPrototypeCommon;
namespace HomeWeb.Controllers
{
    public class SensoroController : Controller
    {
        // GET: Sensoro
        public ActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public ActionResult FilterBeaconsBySerialNumbers(string beaconsSerialNumbers)
        {
            List<Sensoro> sensoros = new List<Sensoro>();
            if (!string.IsNullOrEmpty(beaconsSerialNumbers))
            {
                string[] snArray = beaconsSerialNumbers.Split(new char[] { ',' });
                if(snArray != null)
                {
                    foreach (string sn in snArray)
                    {
                        if(sn != null && sn.Length != 0)
                        {
                            sensoros.Add(new Sensoro(sn));
                        }

                    }
                }

            }

            //ViewBag.Msg = beaconsSerialNumbers;
            return PartialView("~/Views/Shared/BeaconsList.cshtml", sensoros);

        }

        [HttpPost]
        public ActionResult BackToHome(string beaconsSerialNumbers)
        {
            return this.RedirectToAction("Index", "Home");

        }

    }
}