﻿using HomeWeb.Models;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage.RetryPolicies;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;

namespace HomeWeb.Controllers
{
    //this should not be used any more, keep it commented for a while, we can delete this file later.
#if false
    
    public class UserController : Controller
    {
        private CloudBlobContainer _adsBlobContainer;


        public UserController()
        {
            InitializeCloudStorage();
        }

        private void InitializeCloudStorage()
        {
            // Open storage account
            CloudStorageAccount storageAccount = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageConnectionString"));
            CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();
            blobClient.DefaultRequestOptions.RetryPolicy = new LinearRetry(TimeSpan.FromSeconds(3), 3);

            // Init Ads text container
            _adsBlobContainer = blobClient.GetContainerReference(CCSPrototypeCommon.Constants.AdsBlobContainerName);
            _adsBlobContainer.CreateIfNotExists();
        }

        //
        // GET: /User/

        // note the *value* property defined in the appRoles seciton in the JSON manifest file will be used,
        // note the display name or description.
        //[Authorize(Roles = "Consumers")]
        public async Task<ActionResult> Index()
        {
            // Blob path format: CustomerID/yyyy/MM/dd
            string dateTimeFormat = "yyyy/MM/dd";
            // to do: remove customerID hardcode 
            string customerID = "E1581298-5894-44EE-8FE3-7017D09B206B";
            // List blob in the past 5 days
            int listBlobInPastDays = 5;
            var msgList = new List<MerchantMsgModel>();
            for (int index = 0; index < listBlobInPastDays; index++)
            {
                string prefix = string.Format("{0}/{1}", customerID, DateTime.Now.AddDays(0 - index).ToString(dateTimeFormat));
                foreach(IListBlobItem item in _adsBlobContainer.ListBlobs(prefix, true))
                {
                    var blob = (CloudBlockBlob)item;
                    string blobContent = await blob.DownloadTextAsync();
                    MerchantMsgModel msgModel = JsonConvert.DeserializeObject<MerchantMsgModel>(blobContent);
                    msgList.Add(msgModel);
                }
            }

            return View(msgList);
        }

        //
        // GET: /User/Details/5

        public ActionResult Details(int id)
        {
            return View();
        }

        //
        // GET: /User/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /User/Create

        [HttpPost]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                // TODO: Add insert logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        //
        // GET: /User/Edit/5

        public ActionResult Edit(int id)
        {
            return View();
        }

        //
        // POST: /User/Edit/5

        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add update logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        //
        // GET: /User/Delete/5

        public ActionResult Delete(int id)
        {
            return View();
        }

        //
        // POST: /User/Delete/5

        [HttpPost]
        public ActionResult Delete(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add delete logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }
    }
#endif
}
