﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using  CCSAdmin;
using CCSPrototypeCommon;
using Microsoft.Azure;
using System.Threading.Tasks;


using PushSharp;
using PushSharp.Apple;
using System.Security.Cryptography.X509Certificates;
namespace HomeWeb.Models
{
    public class UserModelHomeController : Controller
    {
        //
        // GET: /UserModeHome/
         private static BillContext _billDB = (BillContext)BillContextFactory.GetInstance().GetDBEFContext();
        public ActionResult Index(string str)
        {
            // check session to see if this user is authenticated already.
            var isUserAuthenticatedByVerificationCode = Session["IsUserAuthenticatedByVerificationCode"];
            bool isUserAuthenticated = isUserAuthenticatedByVerificationCode != null && isUserAuthenticatedByVerificationCode.GetType() == typeof(bool) && (bool)isUserAuthenticatedByVerificationCode == true;

            if (!isUserAuthenticated)
            {
                var isUserAuthenticatedByPassword = Session["IsUserAuthenticatedByPassword"];
                isUserAuthenticated = isUserAuthenticatedByPassword != null && isUserAuthenticatedByPassword.GetType() == typeof(bool) && (bool)isUserAuthenticatedByPassword == true;
            }

            if (!isUserAuthenticated)
            {
                string mobilePhone, password;
                if (UserPasswordContext.GetInstance().ReadPasswordFromCookie(Request, out mobilePhone, out password))
                {
                    if (UserPasswordContext.GetInstance().IsUserAuthenticatedByPassword(mobilePhone, password))
                    {
                        Session["IsUserAuthenticatedByPassword"] = true;
                        Session["UserMobilePhone"] = mobilePhone;
                        isUserAuthenticated = true;
                    }
                }
            }
            if (isUserAuthenticated)
            {
                var mobilePhone = Session["UserMobilePhone"] as string;
                if (string.IsNullOrWhiteSpace(mobilePhone))
                {
                    //log error here
                    throw new Exception("mobile phone can't be empty");
                }
                
                return View("ShowUserBill", BillCommon.getCCSBillListWithInputID((BillContext)BillContextFactory.GetInstance().GetDBEFContext(), mobilePhone));
            }
            return View();
        }

        // GET: Home/ViewPayments
        public ActionResult ViewPayments()
        {
            return RedirectToAction("Index", "Payments");
        }

        // POST: UserModeHome/ViewBills
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult ViewBills(
            [Bind(Include = "UserInputAccountID")] UserModelHome userModelHome)
        {

            if(userModelHome == null)
            {
                ViewBag.Msg = "User model is undefined.";
                return View();
            }

            var userInputID = userModelHome.UserInputAccountID;
            var billsWithThisUser = BillCommon.getCCSUserListWithInputID((BillContext)BillContextFactory.GetInstance().GetDBEFContext(), userInputID);
            if (billsWithThisUser == null || billsWithThisUser.Count() == 0)
            {
                return RedirectToAction("GeneralError", "Error", new
                {
                    message = string.Format("Did not find any bills from the user:{0}", userInputID),
                    linkText = "try another user",
                    act = "Index",
                    ctrl = "UserModelHome"
                });
            }
            else
            {
                //return View(BillCommon.getBillListWithInputID(db, userInputID));

                try
                {
                    //register user in AAD
                    if (IsMobileNumber(userInputID))
                    {
                        string randPassword = UserPasswordContext.CreateRandomVerificationCode();

                        UserPasswordContext.GetInstance().SetTempVerificationCode(userInputID, randPassword);
                        
                        //send user one-time password
                        return View("SecretDisplayView", new LogInModel { UserName = userInputID, VerificationCode = randPassword, Mobile = userInputID });
                    }
                    else
                    {
                        ViewBag.Msg = "Only mobile phone users could be able to use this feature";
                        return View("Only mobile phone users could be able to use this feature");
                    }
                }
                catch (Exception e)
                {
                    ViewBag.Msg = e.Message + " " + (e.InnerException != null ? e.InnerException.Message : "");
                    System.Diagnostics.Trace.WriteLine(e);
                    return View(e);
                }

            }
        }

        
        public ActionResult ViewBillHistory(string UserAccountID, string UserBillType)
        {
            Guid UserGuid;

            if (string.IsNullOrEmpty(UserAccountID)
                || string.IsNullOrEmpty(UserBillType)
                || !Guid.TryParse(UserAccountID, out UserGuid))
            {
                return RedirectToAction("GeneralError", "Error", new
                {
                    message = "Unable to begin the query of Bill history, because your input is invalid. UserAccountID = '"
                        + UserAccountID + "', UserBillType = '" + UserBillType + "'",
                    linkText = " View Bill list",
                    act = "Index",
                    ctrl = "UserModelHome"
                });
            }

            var isUserAuthenticatedByVerificationCode = Session["IsUserAuthenticatedByVerificationCode"];
            bool isUserAuthenticated = isUserAuthenticatedByVerificationCode != null && isUserAuthenticatedByVerificationCode.GetType() == typeof(bool) && (bool)isUserAuthenticatedByVerificationCode == true;

            if (!isUserAuthenticated)
            {
                string mobilePhone, password;
                if (UserPasswordContext.GetInstance().ReadPasswordFromCookie(Request, out mobilePhone, out password))
                {
                    if (UserPasswordContext.GetInstance().IsUserAuthenticatedByPassword(mobilePhone, password))
                    {
                        Session["IsUserAuthenticatedByPassword"] = true;
                        Session["UserMobilePhone"] = mobilePhone;
                        isUserAuthenticated = true;
                    }
                }
            }

            if (isUserAuthenticated)
            {
                var billsWithThisUser = BillCommon.getCCSUserBillHistory(
                    (BillContext)BillContextFactory.GetInstance().GetDBEFContext(), UserGuid, UserBillType);
                return View(billsWithThisUser);
            }
            else
            {
                return RedirectToAction("Index");
            }
            
        }
        public ActionResult Logout()
        {
            UserPasswordContext.GetInstance().InvalidateCookieAndLogOut(Session, Response);
            // redirect back to user mode home so user can obtain verification code.            
            return RedirectToAction("Index", "UserModelHome");
        }

        [HttpPost]
        public JsonResult AddToken(string userid, string deviceToken)
        {
            var usersInfo = _billDB.UserTable.Where(o => o.UserID.ToString() == userid).ToList();
            if (usersInfo.Count() != 1) {


                return new JsonResult() { Data = new { statuscode = 0, statusmsg = "A record with the specified id cannot be found in our database or more than one is found."}, JsonRequestBehavior = JsonRequestBehavior.AllowGet }; 
            }
            try
            {
                if (!String.IsNullOrEmpty(deviceToken) && deviceToken != usersInfo[0].iOSDeviceToken)
                {
                    usersInfo[0].iOSDeviceToken = deviceToken;
                    usersInfo[0].ModifiedDate = DateTime.UtcNow;
                    _billDB.SaveChanges();
                    return new JsonResult() { Data = new { statuscode = 1, statusmsg = "It was successfully saved." }, JsonRequestBehavior = JsonRequestBehavior.AllowGet }; 
                }

               

            }
            catch(Exception e)
            {
                return new JsonResult() { Data = new { statuscode = 0, statusmsg = "Exception: " + e.InnerException.Message}, JsonRequestBehavior = JsonRequestBehavior.AllowGet }; 
            }
            return new JsonResult() { Data = new { statuscode = 1, statusmsg = "Sucess" }, JsonRequestBehavior = JsonRequestBehavior.AllowGet }; 
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult GetAuthenticatedBillsByVerificationCode(LogInModel loginInfo)
        {
            ViewBag.userid = null;
            CCSPrototypeCommon.UserPasswordContext.VerificationFailure failure = UserPasswordContext.GetInstance().IsUserAuthenticatedByVerificationCode(loginInfo.Mobile, loginInfo.VerificationCode);
            if (failure == UserPasswordContext.VerificationFailure.Passed)
            {
                Session["IsUserAuthenticatedByVerificationCode"] = true;
                Session["UserMobilePhone"] = loginInfo.Mobile;
                if (loginInfo.SaveCookie)
                {
                    UserPasswordContext.GetInstance().CreatePermantPasswordAndWriteIntoCookie(Response, loginInfo.Mobile);
                }
                ViewBag.userid = loginInfo.Mobile;
                var data = BillCommon.getCCSBillListWithInputID((BillContext)BillContextFactory.GetInstance().GetDBEFContext(), loginInfo.Mobile);
                return View("ShowUserBill", data);
            }
            else
            {
                return RedirectToAction("GeneralError", "Error", new
                {
                    message = failure == UserPasswordContext.VerificationFailure.CodeExpired ?
                        "Your verification code has expired!" : "Your verification code is not correct!",
                    linkText = "get a new verification code",
                    act = "Index",
                    ctrl = "UserModelHome"
                });
            }
        }


        private bool IsMobileNumber(string userInputId)
        {
            //Todo: Add intelegience here. 
            return true;
        }


        public ActionResult AboutUs()
        {
            return View();
        }

    }
}
