﻿#if false
using HomeWeb.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CCSPrototypeCommon;

namespace HomeWeb.Controllers
{
    //[Authorize(Roles="Vendor")]
    public class VendorController : Controller
    {
        // GET: Vendor
        public ActionResult Index()
        {
            return View();
        }

        [Authorize(Roles = "Vendor")]
        public ActionResult CreatePublicMsg()
        {
            return View();
        }
        [Authorize(Roles = "Vendor")]
        public ActionResult ManageMsg()
        {
            return View();
        }

        [Authorize(Roles = "Vendor")]
        public ActionResult CheckUserBill()
        {
            return View();
        }

        [Authorize(Roles = "Vendor")]
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult ViewUserBill(
            [Bind(Include = "UserInputAccountID")] UserModelHome userModelHome)
        {
            var userInputID = userModelHome.UserInputAccountID;
            var billContex = (BillContext)BillContextFactory.GetInstance().GetDBEFContext();
            var billsWithThisUser = BillCommon.getCCSBillListWithInputID(billContex, userInputID);
            if (billsWithThisUser == null || billsWithThisUser.Count() == 0)
            {
                return RedirectToAction("GeneralError", "Error", new
                {
                    message = string.Format("Did not find any bills from the user:{0}", userInputID),
                    linkText = "try another user",
                    act = "CheckUserBill",
                    ctrl = "Vendor"
                });
            }
            return View("ShowUserBill", billsWithThisUser);
        }
    }
}
#endif