﻿
namespace HomeWeb.Models
{
    using CCSPrototypeCommon;
    using System.Collections.Generic;
    using System.Web;

    public class CompanyModel
    {
        public virtual CCS_Customer_V1 CustomerTable {get; set;}

        public virtual List<CCS_CustomerInfo_V1> CustomerInfoList { get; set; }

        public CompanyModel()
        {
            CustomerTable = new CCS_Customer_V1();
            CustomerInfoList = new List<CCS_CustomerInfo_V1>();
        }

        public static CompanyModel Current
        {
            get
            {
                var company = HttpContext.Current.Session["CompanayModel"] as CompanyModel;
                if (company == null)
                {
                    company = new CompanyModel();
                    HttpContext.Current.Session["CompanayModel"] = company;
                }
                return company;
            }

            set
            {
                HttpContext.Current.Session["CompanayModel"] = value;
            }
        }
    }
}