﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using CCSPrototypeCommon;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;

namespace HomeWeb.Models
{
    public class CustomerModel
    {
        public virtual CCS_Customer_V1 CustomerTable { get; set; }

        public virtual CCS_Staff_V1 StaffTable { get; set; }

        [DisplayName("Password")]
        [RegularExpression(@"(?=^.{8,16}$)((?=.*\d)(?=.*[A-Z])(?=.*[a-z])|(?=.*\d)(?=.*[^A-Za-z0-9])(?=.*[a-z])|(?=.*[^A-Za-z0-9])(?=.*[A-Z])(?=.*[a-z])|(?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9]))^.*", ErrorMessage = "Passwords length to be between 8 and 16 characters; Please check https://msdn.microsoft.com/en-us/library/azure/jj943764.aspx for password policy")]
        public string Password { get; set; }

        [DisplayName("Re-enter Password")]
        [Compare("Password", ErrorMessage = "Passwords must match")]
        public string ComparePassword { get; set; }

        public virtual List<CCS_CustomerInfo_V1> CustomerInfoList { get; set; }

        public virtual List<CCS_StaffInfo_V1> StaffInfoList { get; set; }

        public CustomerModel()
        {
            this.CustomerTable = new CCS_Customer_V1();
            this.CustomerTable.State = CustomerAccountState.Active;
            this.StaffTable = new CCS_Staff_V1();
            this.StaffTable.State = CustomerAccountState.Active;
            this.CustomerInfoList = new List<CCS_CustomerInfo_V1>();
            this.StaffInfoList = new List<CCS_StaffInfo_V1>();
        }
    }
}