﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace HomeWeb.Models
{
    public class Category
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public Category(int Id, string Name)
        {
            this.Id = Id;
            this.Name = Name;
        }
    }
    public class HomeModel
    {
        private readonly List<Category> _categories;
        public IEnumerable<SelectListItem> CategoryItems
        {
            get 
            { 
                var allCategories = _categories.Select(category => new SelectListItem
                                    {
                                            Value  = category.Id.ToString(),
                                            Text = category.Name
                                    });
                return allCategories;
            }
        }

        public int ID { get; set; }

        public HomeModel(List<Category> categories)
        {
            this._categories = categories;
        }
        
    }
}