﻿
namespace HomeWeb.Models
{

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using CCSPrototypeCommon;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;

    public class VendorModel
    {
        public virtual CCS_Staff_V1 StaffTable { get; set; }

        public virtual List<CCS_StaffInfo_V1> StaffInfoList { get; set; }

        public string ProfilePictureUri { get; set; }

        public VendorModel()
        {
            this.StaffInfoList = new List<CCS_StaffInfo_V1>();
        }

        public static VendorModel Current
        {
            get
            {
                var vendor = HttpContext.Current.Session["VendorModel"] as VendorModel;
                if (vendor == null)
                {
                    vendor = new VendorModel();
                    HttpContext.Current.Session["VendorModel"] = vendor;
                }
                return vendor;
            }

            set
            {
                HttpContext.Current.Session["VendorModel"] = value;
            }
        }
    }
}