﻿#region

using System;
using System.Threading.Tasks;
using System.Web.WebPages;
using Microsoft.Azure.ActiveDirectory.GraphClient;

using Microsoft.IdentityModel.Clients.ActiveDirectory;

#endregion

namespace HomeWeb.Utils
{
    internal class AuthenticationHelper
    {
        public static string Token { get; set; }
        static public string AuthString { get; set; }
        static public string AppId  {get; set;}
        static public string AppKey { get; set; } 
        private static readonly string GraphApiRoot = "https://graph.windows.net";
        
        /// <summary>
        ///     Async task to acquire token for Application.
        /// </summary>
        /// <returns>Async Token for application.</returns>
        public static async Task<string> AcquireTokenAsync()
        {
            if (Token == null || Token.IsEmpty())
            {
                // Instantiate an AuthenticationContext for my directory (see authString above).
                AuthenticationContext authenticationContext = new AuthenticationContext(AuthString, false);

                // Create a ClientCredential that will be used for authentication.
                // This is where the Client ID and Key/Secret from the Azure Management Portal is used.
                ClientCredential clientCred = new ClientCredential(AppId, AppKey);

                // Acquire an access token from Azure AD to access the Azure AD Graph (the resource)
                // using the Client ID and Key/Secret as credentials.
                AuthenticationResult authenticationResult = await authenticationContext.AcquireTokenAsync(GraphApiRoot, clientCred);

                // Return the access token.
                Token = authenticationResult.AccessToken;
            }
            return Token;
        }

        /// <summary>
        ///     Get Active Directory Client for Application.
        /// </summary>
        /// <returns>ActiveDirectoryClient for Application.</returns>
        public static ActiveDirectoryClient GetActiveDirectoryClient()
        {
            Uri baseServiceUri = new Uri(Constants.ResourceUrl);
            ActiveDirectoryClient activeDirectoryClient =
                new ActiveDirectoryClient(new Uri(baseServiceUri, Constants.TenantId),
                    async () => await AcquireTokenAsync());
            return activeDirectoryClient;
        }
    }
}