﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.Storage;
using CCSPrototypeCommon;
using Microsoft.WindowsAzure.Storage.Blob;
using System.Text;
using System.IO;
using ThreadedWorkerRole;
using Microsoft.Azure;
namespace HomeWorker
{
    class GeneratePaymentBlobWorker : WorkerEntryPoint
    {
        private readonly CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        private readonly ManualResetEvent runCompleteEvent = new ManualResetEvent(false);

        private int RowNumber = 0;
        public override void Run()
        {
            Trace.TraceInformation("WorkerRoleGeneratePaymentBlob is running");
            try
            {
                // Open storage account
                CloudStorageAccount storageAccount = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageConnectionString"));


                var db = (PaymentContext)PaymentContextFactory.GetInstance().GetDBEFContext();

                // Create blob container
                CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();
                var container = blobClient.GetContainerReference("payments");
                if (container.CreateIfNotExists())
                {
                    container.SetPermissions(
                        new BlobContainerPermissions
                        {
                            PublicAccess = BlobContainerPublicAccessType.Blob
                        });


                }

                while (true)
                {

                    try
                    {
                        Trace.TraceInformation("while is running");

                        var paymentsList = (from o in db.PaymentTable select o).ToList();
                        if (paymentsList.Count != 0 && RowNumber != paymentsList.Count)
                        {
                            Trace.TraceInformation("start storing");
                            List<CCS_Payment_V1> paymentsSortedList = paymentsList.OrderBy(o => o.PaySubmitTime).ToList();
                            List<byte> blobBytes = new List<byte>();
                            foreach (var paymentItem in paymentsSortedList)
                            {
                                StringBuilder line = new StringBuilder();
                                line.Append(paymentItem.PaymentID + ",");
                                line.Append(paymentItem.PaymentType + ",");
                                line.Append(paymentItem.PaymentMethod + ",");
                                line.Append(paymentItem.PaymentCellNumber + ",");
                                line.Append(paymentItem.PaySubmitTime.ToShortDateString() + "\r\n");
                                // convert string to stream
                                blobBytes.AddRange(Encoding.UTF8.GetBytes(line.ToString()));

                            }
                            using (MemoryStream stream = new MemoryStream(blobBytes.ToArray()))
                            {
                                string dateTimeFormat = "yyyy-MM-ddTHH':'mm':'ss";
                                string blobName = String.Format("{0}-{1}", DateTime.Now.ToString(dateTimeFormat), Guid.NewGuid().ToString());

                                var blob = container.GetBlockBlobReference(blobName);
                                blob.UploadFromStream(stream);
                            }

                            RowNumber = paymentsList.Count;
                            Trace.TraceInformation("Done storing");
                        }




                        Thread.Sleep(2000);
                    }
                    catch (Exception e)
                    {
                        Trace.TraceError("Exception in HomeWorker: '{0}'", e.Message);
                        logException(e);
                    }
                }

            }
            catch (Exception e)
            {
                Trace.TraceInformation("Exception: " + e);
                logException(e);
            }

        }


        public override bool OnStart()
        {
            // Set the maximum number of concurrent connections
            ServicePointManager.DefaultConnectionLimit = 12;

            // For information on handling configuration changes
            // see the MSDN topic at http://go.microsoft.com/fwlink/?LinkId=166357.

            bool result = base.OnStart();

            Trace.TraceInformation("WorkerRoleGeneratePaymentBlob has been started");

            return result;
        }

        public override void OnStop()
        {
            Trace.TraceInformation("WorkerRoleGeneratePaymentBlob is stopping");

            this.cancellationTokenSource.Cancel();
            this.runCompleteEvent.WaitOne();

            base.OnStop();

            Trace.TraceInformation("WorkerRoleGeneratePaymentBlob has stopped");
        }

        private async Task RunAsync(CancellationToken cancellationToken)
        {
            // TODO: Replace the following with your own logic.
            while (!cancellationToken.IsCancellationRequested)
            {
                Trace.TraceInformation("Working");
                await Task.Delay(1000);
            }
        }
    }
}

