using System;
using System.IO;
using System.Collections.Generic;
using System.Diagnostics;
using System.Configuration;
using System.Linq;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using System.Data.Entity;
using System.Data;
using System.Web;
using CCSPrototypeCommon;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage.Queue;
using Microsoft.WindowsAzure.Storage.Table;
using Microsoft.WindowsAzure.Storage.Table.DataServices;
using Microsoft.WindowsAzure.Storage.RetryPolicies;
using ThreadedWorkerRole;
using Microsoft.Azure;


namespace HomeWorker
{
    public class WorkerRole : ThreadedRoleEntryPoint
    {
        public override void Run()
        {
            Trace.TraceInformation("WorkerRolese::Run is running", "Information");

            var workers = new List<WorkerEntryPoint>();

            workers.Add(new TransferBillToDBWorker());
            workers.Add(new TransferRawDataToDBWorker());
            workers.Add(new TransferMeterProfileToDBWorker());
            workers.Add(new BuildQueryBlobWorker());
            workers.Add(new GeneratePaymentBlobWorker());

            base.Run(workers.ToArray());
        }


        public override bool OnStart()
        {
            Trace.TraceInformation("WorkerRole::OnStart", "Information");

            var sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
            var allContext = new AllContext(sqlConnString);
            allContext.Database.CreateIfNotExists();

            return base.OnStart();
        }

        public override void OnStop()
        {
            Trace.TraceInformation("WorkerRole::OnStop", "Information");

            base.OnStop();
        }
    }
}
