package my.ccs.projectrawdata;


import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.baidu.mapapi.SDKInitializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import javax.net.ssl.HttpsURLConnection;

import my.ccs.projectrawdata.model.RawData;
import my.ccs.projectrawdata.sqlite.MySQLiteHelper;

public class HomeActivity extends Activity {

    ImageButton uploadDataBtn;
    ImageButton settingsBtn;
    ImageButton uploadMeterInfoBtn;
    ImageButton downloadMeterProfilesBtn;
    ImageButton viewMetersBtn;

    AlertDialog chooseCollectDataMethoDialog;

    static boolean isFirstCreate = true;
    String deviceId = null;

    int displayWidth;
    int displayHeight;
    @Override
    public void onCreate(Bundle savedInstanceState) {

        SDKInitializer.initialize(getApplicationContext());
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_home);

        DisplayMetrics metrics = new DisplayMetrics();
        getWindow().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        //getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(0));
        displayWidth = metrics.widthPixels;
        displayHeight = metrics.heightPixels;

        downloadMeterProfilesBtn = (ImageButton)findViewById(R.id.downloadMeterProfilesBtn);
        downloadMeterProfilesBtn.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                new SendPostTask().execute();
            }
        });


        viewMetersBtn = (ImageButton)findViewById(R.id.viewMetersBtn);
        viewMetersBtn.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                // custom dialog
                final Dialog dialog = new Dialog(HomeActivity.this);
                Window window = dialog.getWindow();
                window.requestFeature(Window.FEATURE_NO_TITLE);
                dialog.setContentView(R.layout.choose_meter_type);


                window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                dialog.setCancelable(true);

                ImageButton wirelessTypeOption = (ImageButton)dialog.findViewById(R.id.wirelessTypeOption);
                wirelessTypeOption.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 0);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);

                    }
                });

                TextView wirelessTypeOptionTxt = (TextView)dialog.findViewById(R.id.wirelessTypeOptionTxt);
                wirelessTypeOptionTxt.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 0);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);

                    }
                });

                ImageButton electronicTypeOption = (ImageButton)dialog.findViewById(R.id.electronicTypeOption);
                electronicTypeOption.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 1);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });
                TextView electronicTypeOptionTxt = (TextView)dialog.findViewById(R.id.electronicTypeOptionTxt);
                electronicTypeOptionTxt.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 1);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });

                ImageButton cableTypeOption = (ImageButton)dialog.findViewById(R.id.cableTypeOption);
                cableTypeOption.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 2);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });
                TextView cableTypeOptionTxt = (TextView)dialog.findViewById(R.id.cableTypeOptionTxt);
                cableTypeOptionTxt.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {
                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 2);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });


                ImageButton staffTypeOption = (ImageButton)dialog.findViewById(R.id.staffTypeOption);
                staffTypeOption.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {

                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 3);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });
                TextView staffTypeOptionTxt = (TextView)dialog.findViewById(R.id.staffTypeOptionTxt);
                staffTypeOptionTxt.setOnClickListener(new View.OnClickListener() {
                    public void onClick(View view) {

                        dialog.dismiss();
                        Bundle b = new Bundle();
                        b.putInt(Constants.ChosenMeterTypeKey, 3);
                        Intent nextScreen = new Intent(getApplicationContext(), MapActivity.class);
                        nextScreen.putExtras(b); //Put your id to your next Intent
                        startActivity(nextScreen);


                    }
                });


                dialog.show();

                window.setLayout((int)(displayWidth * 0.75), (int)(displayHeight * 0.55));


            }
        });

        uploadDataBtn = (ImageButton)findViewById(R.id.uploadDataBtn);
        uploadDataBtn.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                new SendPostUploadTask().execute();

            }
        });

        settingsBtn = (ImageButton)findViewById(R.id.settingsBtn);
        settingsBtn.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                Intent nextScreen = new Intent(getApplicationContext(), SettingsActivity.class);
                startActivity(nextScreen);
            }
        });

        uploadMeterInfoBtn = (ImageButton)findViewById(R.id.uploadMeterInfoBtn);
        uploadMeterInfoBtn.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {
                Intent nextScreen = new Intent(getApplicationContext(), UploadMeterInfoActivity.class);
                startActivity(nextScreen);

            }
        });
        android.text.format.DateFormat df = new android.text.format.DateFormat();
        df.format("yyyyMMddhhmmss", new java.util.Date());
        TextView versionNumberTxt = (TextView) findViewById(R.id.versionNumberTxtHome);
        String versionName = BuildConfig.VERSION_NAME;
        versionNumberTxt.setText(versionName);//+"(" + df.format("yyyyMMddhhmmss", new java.util.Date()) + ")");

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    private String sendPost() {

        String response = "No Response";
        try {
            deviceId = Settings.Secure.getString(getContentResolver(),
                    Settings.Secure.ANDROID_ID);

            if(deviceId != null && deviceId.length() != 0) {
                URL url = new URL(Constants.getMeterProfilesUrl);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("User-Agent", Constants.userAgentString);
                conn.setRequestProperty("Content-Type","application/json");
                /*List<Pair<String, String>> params = new ArrayList<>();
                params.add(new Pair<>("AccessCode", accessCode));
                params.add(new Pair<>("DeviceId", deviceId));*/
                JSONObject jsonParam = new JSONObject();
                jsonParam.put(Constants.JSONReqDeviceIDTag, deviceId);
                /*printout = new DataOutputStream(urlConn.getOutputStream ());
                printout.write(URLEncoder.encode(jsonParam.toString(),"UTF-8"));
                printout.flush ();
                printout.close ();*/
                OutputStream os = conn.getOutputStream();
                BufferedWriter writer = new BufferedWriter(
                        new OutputStreamWriter(os, "UTF-8"));
                writer.write(jsonParam.toString());
                writer.flush();
                writer.close();
                os.close();

                //read response from the server
                int responseCode=conn.getResponseCode();
                if (responseCode == HttpsURLConnection.HTTP_OK) {

                    String line;
                    BufferedReader br=new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    response = "";
                    while ((line=br.readLine()) != null) {
                        response+=line;
                    }
                }
                else {
                    response="Failed with response code: " + responseCode;
                }

            }
        }
        catch ( android.os.NetworkOnMainThreadException e)
        {
        }
        catch (Exception e)
        {
        }
        return response;
    }

    private class SendPostTask extends AsyncTask<Void, Void, String> {

        ProgressDialog pleaseWaitDialog;
        String result= "";

        @Override
        protected void onPreExecute() {

            pleaseWaitDialog = ProgressDialog.show(HomeActivity.this, Constants.DIALOGTITLE, Constants.DOWNLOADINGMSG, true, true);
            pleaseWaitDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {

                public void onCancel(DialogInterface dialog) {
                    Log.d(Constants.MyTag, "onCancel");
                    SendPostTask.this.cancel(true);
                }
            });
        }

        @Override
        protected void onPostExecute(final String result) {

            Log.d(Constants.MyTag, "onPostExecute");
            pleaseWaitDialog.dismiss();

            String responseMsg = "Undefined response.";
            this.result = result;
            JSONObject json = null;
            try {
                Log.d(Constants.MyTag, result);

                json = new JSONObject(this.result);
                final String statusCode = json.getString(Constants.JSONRespStatusCodeTag);
                final String statusMsg = json.getString(Constants.JSONRespStatusMsgTag);
                Log.i(Constants.MyTag, "Status Code: " + statusCode + " Status Message: " + statusMsg);
                if(statusCode.equals("200")) {
                    String meterData =  json.has(Constants.JSONRespMeterDataTag)? json.getString(Constants.JSONRespMeterDataTag) : null;
                    if(meterData != null)
                    {
                        JSONArray data = new JSONArray(meterData);
                        final LinkedList<MeterProfileModel> listMeters = new LinkedList<MeterProfileModel>();
                        if(data != null)
                        {
                            for(int ii=0; ii < data.length(); ii++)
                            {
                                JSONObject jsonItem =data.getJSONObject(ii);
                                String meterId = jsonItem.getString(Constants.JSONRespMeterIDTag);
                                String phoneUUId = jsonItem.getString(Constants.JSONRespPhoneUUIDTag);
                                double latitude = jsonItem.getDouble(Constants.JSONRespMeterLatitudeTag);
                                double longitude = jsonItem.getDouble(Constants.JSONRespMeterLongitudeTag);
                                listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId, false));

                            }
                            responseMsg = Constants.DOWNLOADSUCCESS;
                        }
                        else
                        {
                            responseMsg  = Constants.DOWNLOADFAIL;//"WARNING! Server response is success however data is not jsonarray parsable.";
                        }
                        //MeterProfilesDataHolder.getInstance().setListMeters(listMeters);
                        //Utilities.showToastMsg(HomeActivity.this, "Meter profiles have been refreshed!!!");
                    }
                    else
                    {
                        responseMsg  = Constants.DOWNLOADFAIL;//responseMsg = "WARNING! Meter data response from the server is null. Please try to download meters data again.";
                    }
                }
                else
                {
                    responseMsg  = Constants.DOWNLOADFAIL;//responseMsg = "ERROR! Response from the server " + statusMsg;
                }

            }
            catch (JSONException e) {
                final String eMessage = e != null ? e.getMessage() : "JSONException is NULL";
                responseMsg  = Constants.DOWNLOADFAIL;//responseMsg = "JSONException is thrown: " + eMessage;

            }
            catch (Exception e)
            {
                final String eMessage = e != null ? e.getMessage() : "Exception is NULL";
                responseMsg  = Constants.DOWNLOADFAIL;//responseMsg = "Exception is thrown: " + eMessage;

            }


            final String responseMsgFinal = responseMsg;
            HomeActivity.this.runOnUiThread(new Runnable() {
                public void run() {
                    Utilities.showAlertDialog("Response", responseMsgFinal, HomeActivity.this, getWindow(), false);
                }
            });

        }
        @Override
        protected void onCancelled() {
            super.onCancelled();
            //Utilities.hideProgressBar(progressBarDownloadMeters, getWindow(), true);
            Log.i(Constants.MyTag, "onCanceled");
            pleaseWaitDialog.dismiss();

        }

        @Override
        protected String  doInBackground(Void... params) {

            /*for(long i = 0;i < 1000000000 && !isCancelled(); i++)
            {
                if(i%100000000 == 0)
                    Log.e("MyTag", "Check" + i);
            }*/

            return sendPost();
        }
    }

    @Override
    public void onResume(){
        super.onResume();
        Log.i(Constants.MyTag, "Resume called");
        //Starting Home Activity
        if(Utilities.isAccessCodeExpired()) {
            Log.i(Constants.MyTag, "Access code is expired");
            Intent nextScreen = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(nextScreen);
        }
        else
        {
            if(isFirstCreate)
            {
                isFirstCreate = false;
                new SendPostTask().execute();



                //Create fake meter profiles
                final List<MeterProfileModel> listMeters = new LinkedList<>();
                List<String> meterNames = new LinkedList<>();
                meterNames.add("City1");
                meterNames.add("City2");
                meterNames.add("City3");
                meterNames.add("City4");
                meterNames.add("City5");
                String phoneUUId = "TestPhone";
                Random rand = new Random();
                // nextInt is normally exclusive of the top value,
                // so add 1 to make it inclusive
                for(int i = 0; i<500; i++) {
                    int randomNameInd = rand.nextInt(meterNames.size());
                    String meterName = meterNames.get(randomNameInd);
                    double latitude = 38 + (40 - 38) * rand.nextDouble();
                    double longitude = 115 + (117 - 115) * rand.nextDouble();
                    listMeters.add(new MeterProfileModel(meterName, latitude, longitude, phoneUUId, false));
                }
                MeterProfilesDataHolder.getInstance().setListMeters(listMeters);
            }
            MySharedPref.getInstance().setAccessCodeExpDate();

        }

    }

    static class DataUploadStatus
    {
        public enum STATUS{
            NO_DATA,
            DB_DOESNOTEXIST,
            UNKNOWN_ERROR,
            SUCCESS
        }
        STATUS status;
        String msg;
        public DataUploadStatus(STATUS status, String msg)
        {
            this.status = status;
            this.msg = msg;
        }
    }
    private class SendPostUploadTask extends AsyncTask<Void, Void, DataUploadStatus> {

        ProgressDialog pleaseWaitDialog;
        String result= "";

        @Override
        protected void onPreExecute() {
            pleaseWaitDialog = ProgressDialog.show(HomeActivity.this, Constants.DIALOGTITLE, Constants.UPLOADINGMSG, true, true);
            pleaseWaitDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {

                public void onCancel(DialogInterface dialog) {
                    Log.i(Constants.MyTag, "onCancel");
                    SendPostUploadTask.this.cancel(true);
                }
            });
        }


        @Override
        protected void onPostExecute(final DataUploadStatus result) {

            Log.i(Constants.MyTag, "onPostExecute");
            pleaseWaitDialog.dismiss();

            String responseMsg = "Undefined response.";

            if(result != null && result.status == DataUploadStatus.STATUS.SUCCESS)
            {
                responseMsg = Constants.UPLOADSUCCESS;
                //responseMsg = result.status + " " + result.msg;
            }
            else
            {
                responseMsg = Constants.UPLOADFAIL;
            }

            final String responseMsgFinal = responseMsg ;
            HomeActivity.this.runOnUiThread(new Runnable() {
                public void run() {

                    Utilities.showAlertDialog("Response", responseMsgFinal, HomeActivity.this, getWindow(), false);

                }
            });

        }
        @Override
        protected void onCancelled() {
            super.onCancelled();
            //Utilities.hideProgressBar(progressBarDownloadMeters, getWindow(), true);
            Log.i(Constants.MyTag, "onCanceled");
            pleaseWaitDialog.dismiss();

        }

        String targetUrl = "http://cloudcomspace.cloudapp.net/merchant/UploadRawDataMobile";



        @Override
        protected DataUploadStatus  doInBackground(Void... params) {

            MySQLiteHelper dbhelper = new MySQLiteHelper(HomeActivity.this);
            // add Books
            dbhelper.addRawData(new RawData("measuretype", "meterid", "metertype", "metermodel","manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));
            dbhelper.addRawData(new RawData("measuretype2", "meterid", "metertype", "metermodel", "manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));
            dbhelper.addRawData(new RawData("measuretype3", "meterid", "metertype", "metermodel", "manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));

            int dataCount = 0;
            String response = "error";
            try {


                File sqliteDB = getDatabasePath(MySQLiteHelper.DATABASE_NAME);
                if(sqliteDB ==null ||  !sqliteDB.exists())
                    return  new DataUploadStatus(DataUploadStatus.STATUS.DB_DOESNOTEXIST, "SQLite database does not exist");

                dataCount = dbhelper.getAllRawData().size();
                if(dataCount == 0)
                {
                    return  new DataUploadStatus(DataUploadStatus.STATUS.NO_DATA, "There is no data to upload.");
                }

                dbhelper.exportDB();
                File csvDB = getDatabasePath(MySQLiteHelper.ExportCSVName);
                if(csvDB == null || !csvDB.exists())
                    return  new DataUploadStatus(DataUploadStatus.STATUS.DB_DOESNOTEXIST, "CSV database does not exist.");


                HttpURLConnection connection = null;
                DataOutputStream outputStream = null;

                String pathToOurFile = csvDB.getAbsolutePath();
                String urlServer = targetUrl;
                int bytesRead, bytesAvailable, bufferSize;
                byte[] buffer;
                int maxBufferSize = 1 * 1024;

                FileInputStream fileInputStream = new FileInputStream(new File(
                        pathToOurFile));

                URL url = new URL(urlServer);
                connection = (HttpURLConnection) url.openConnection();

                // Allow Inputs & Outputs
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setChunkedStreamingMode(1024);
                // Enable POST method
                connection.setRequestMethod("POST");

                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setRequestProperty("Content-Type",
                        "multipart/form-data");

                outputStream = new DataOutputStream(connection.getOutputStream());

                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                buffer = new byte[bufferSize];

                // Read file
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                Log.i(Constants.MyTag, bytesAvailable + " bytes available");
                try {
                    while (bytesRead > 0) {
                        try {
                            outputStream.write(buffer, 0, bufferSize);
                        } catch (OutOfMemoryError e) {
                            return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, "Out of memory error occur.");
                        }
                        bytesAvailable = fileInputStream.available();
                        bufferSize = Math.min(bytesAvailable, maxBufferSize);
                        bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                    }
                } catch (Exception e) {
                    Log.e(Constants.MyTag, "Exception in out is " + e.getMessage() + "");
                    return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, e.getMessage());
                }

                fileInputStream.close();
                outputStream.flush();
                outputStream.close();


                // Responses from the server (code and message)
                int responseCode=connection.getResponseCode();

                if (responseCode == HttpsURLConnection.HTTP_OK) {

                    response = "";
                    String line;
                    BufferedReader br=new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line=br.readLine()) != null) {
                        response+=line;
                    }

                    dbhelper.deleteAllRawData();
                }
                else {
                    return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, "Failed with response code: " + responseCode);
                }

                Log.i(Constants.MyTag, response);

            } catch (Exception ex) {
                return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, ex.getMessage());
            }

            return  new DataUploadStatus(DataUploadStatus.STATUS.SUCCESS, "Data have been uploaded successfully. Number of records " + dataCount);

        }
    }

    public static class DownloadMetersDialogFragment extends DialogFragment {

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

            View rootView = inflater.inflate(R.layout.download_meter_dialog_layout, container, false);
            getDialog().getWindow().requestFeature(Window.FEATURE_NO_TITLE);
            getDialog().getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
            // set color transpartent
            //getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            ProgressBar progressBar = (ProgressBar) rootView.findViewById(R.id.DownloadMetersProgressBarLarge);
            LinearLayout.LayoutParams progressBarPar = (LinearLayout.LayoutParams)progressBar.getLayoutParams();
            DisplayMetrics metrics = new DisplayMetrics();
            getDialog().getWindow().getWindowManager().getDefaultDisplay().getMetrics(metrics);
            //getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(0));
            int width = metrics.widthPixels;
            int height = metrics.heightPixels;
            progressBarPar.width= width/4;
            progressBarPar.height= height/4;
            progressBar.bringToFront();
            getDialog().setCanceledOnTouchOutside(false);
            getDialog().setCancelable(false);
            return rootView;
        }
    }
}