package my.ccs.projectrawdata;


import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Rect;
import android.net.rtp.RtpStream;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.mapapi.SDKInitializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import javax.net.ssl.HttpsURLConnection;

public class MainActivity extends Activity {


    Button submitButton;
    EditText accessCodeEditTxt;
    String deviceId = null;
    ProgressBar progressBar;
    TextView deviceIdLabel;
    ImageButton copyDeviceId;
    RelativeLayout mainLayout;
    StringBuilder result = new StringBuilder(); //stores query to be sent to the server

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        //requestWindowFeature(Window.FEATURE_NO_TITLE);

        SDKInitializer.initialize(getApplicationContext());
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        mainLayout = (RelativeLayout)findViewById(R.id.mainLayout);


        //Initialization
        progressBar = (ProgressBar) findViewById(R.id.progressBar);
        RelativeLayout.LayoutParams progressBarPar = (RelativeLayout.LayoutParams)progressBar.getLayoutParams();
        progressBarPar.width= Utilities.getWidth(this)/4;
        progressBarPar.height= Utilities.getHeight(this)/4;

        deviceIdLabel = (TextView) findViewById(R.id.deviceIdLabel);

        deviceId = Settings.Secure.getString(getContentResolver(),
                Settings.Secure.ANDROID_ID);
        if(deviceId != null)
        {
            deviceId = deviceId.toUpperCase();
            deviceIdLabel.setText(Constants.DEVICEIDCHINESE + " " + deviceId);
        }
        else
        {
            deviceIdLabel.setText(Constants.DEVICEIDCHINESE);
        }

        accessCodeEditTxt   = (EditText)findViewById(R.id.accessCodeEditTxt);


        submitButton = (Button)findViewById(R.id.btnSubmit);
        submitButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                String accessCode = accessCodeEditTxt.getText().toString();
                if(accessCode == null || accessCode.length() == 0)
                {
                    MainActivity.this.runOnUiThread(new Runnable() {
                        public void run() {
                            Utilities.showAlertDialog(Constants.DIALOGTITLE, "Access code is not specified.", MainActivity.this, getWindow(), false);
                        }
                    });
                }
                else if(deviceId == null  || deviceId.length() == 0)
                {
                    MainActivity.this.runOnUiThread(new Runnable() {
                        public void run() {
                            Utilities.showAlertDialog(Constants.DIALOGTITLE, "Incorrect device id.", MainActivity.this, getWindow(), false);
                        }
                    });
                }
                else{
                    new SendPostTask().execute();
                }



            }
        });

        copyDeviceId = (ImageButton)findViewById(R.id.deviceCopyBtn);
        copyDeviceId.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {

                MainActivity.this.runOnUiThread(new Runnable() {
                    public void run() {

                        String text = deviceId != null ? deviceId.trim() : null;
                        if(text != null && text.length() > 0) {
                            if(android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.HONEYCOMB) {
                                android.text.ClipboardManager clipboardMgr = (android.text.ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
                                clipboardMgr.setText(text);
                            } else {
                                // this api requires SDK version 11 and above, so suppress warning for now
                                android.content.ClipboardManager clipboardMgr = (android.content.ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
                                ClipData clip = ClipData.newPlainText("Copied text", text);
                                clipboardMgr.setPrimaryClip(clip);

                            }
                            Utilities.showAlertDialog(Constants.DIALOGTITLE, "Your device id is copied.", MainActivity.this, getWindow(), false);
                        }
                        else {
                            Utilities.showAlertDialog(Constants.DIALOGTITLE, "Unable to copy this device id.", MainActivity.this, getWindow(), false);
                        }


                    }
                });

            }
        });

        android.text.format.DateFormat df = new android.text.format.DateFormat();
        df.format("yyyyMMddhhmmss", new java.util.Date());


        TextView versionNumberTxt = (TextView) findViewById(R.id.versionNumberTxtMain);
        String versionName = BuildConfig.VERSION_NAME;
        versionNumberTxt.setText(versionName);

    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == MotionEvent.ACTION_DOWN) {
            if (accessCodeEditTxt!=null &&  accessCodeEditTxt.isFocused()) {
                Rect outRect = new Rect();
                accessCodeEditTxt.getGlobalVisibleRect(outRect);
                if (!outRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    accessCodeEditTxt.clearFocus();
                    //
                    // Hide keyboard
                    //
                    hideKeyboard();
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void hideKeyboard()
    {
        InputMethodManager inputMethodManager = (InputMethodManager)  this.getSystemService(Activity.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);

    }
    @Override
    protected void onPause() {
        super.onPause();

    }

    @Override
    protected void onResume() {
        super.onResume();

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        //Utilities.hideProgressBar(progressBar, getWindow(), true);
    }

    private String sendPost() {
        String response = "";
        try {
            String accessCode = accessCodeEditTxt.getText().toString();
            if(accessCode != null && accessCode.length() != 0 && deviceId != null && deviceId.length() != 0) {
                URL url = new URL(Constants.verifyAccessUrl);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("User-Agent", "USER_AGENT");
                conn.setRequestProperty("Content-Type","application/json");
                /*List<Pair<String, String>> params = new ArrayList<>();
                params.add(new Pair<>("AccessCode", accessCode));
                params.add(new Pair<>("DeviceId", deviceId));*/

                JSONObject jsonParam = new JSONObject();
                jsonParam.put(Constants.JSONReqAccessCodeTag, accessCode);
                jsonParam.put(Constants.JSONReqDeviceIDTag, deviceId);

                /*printout = new DataOutputStream(urlConn.getOutputStream ());
                printout.write(URLEncoder.encode(jsonParam.toString(),"UTF-8"));
                printout.flush ();
                printout.close ();*/


                OutputStream os = conn.getOutputStream();
                BufferedWriter writer = new BufferedWriter(
                        new OutputStreamWriter(os, "UTF-8"));
                //writer.write(getQuery(params));
                writer.write(jsonParam.toString());
                writer.flush();
                writer.close();
                os.close();

                int responseCode=conn.getResponseCode();

                //remove this code later

                if (responseCode == HttpsURLConnection.HTTP_OK) {

                    String line;
                    BufferedReader br=new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((line=br.readLine()) != null) {
                        response+=line;
                    }
                }
                else {
                    response="Failed with response code: " + responseCode;

                }

            }
        }
        catch ( android.os.NetworkOnMainThreadException e)
        {
        }
        catch (Exception e)
        {
        }
        return response;
    }

    private class SendPostTask extends AsyncTask<Void, Void, String> {

        String result= "";
        ProgressDialog pleaseWaitDialog;

        @Override
        protected void onPreExecute() {
            //Utilities.showProgressBar(progressBar, getWindow(), true);
            pleaseWaitDialog = ProgressDialog.show(MainActivity.this, Constants.DIALOGTITLE, Constants.ACCESSVERIFYMSG, true, true);
            pleaseWaitDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {

                public void onCancel(DialogInterface dialog) {
                    Log.d(Constants.MyTag, "onCancel");
                    SendPostTask.this.cancel(true);
                }
            });
        }

        @Override
        protected void onPostExecute(final String result) {

            Log.d(Constants.MyTag, "onPostExecute");
            pleaseWaitDialog.dismiss();

            String responseMsg = "Undefined response.";
            this.result = result;
            JSONObject json = null;
            try {
                Log.d(Constants.MyTag, result);

                json = new JSONObject(this.result);
                final String statusCode = json.getString(Constants.JSONRespStatusCodeTag);
                final String statusMsg = json.getString(Constants.JSONRespStatusMsgTag);
                Log.i(Constants.MyTag, "Status Code: " + statusCode + " Status Message: " + statusMsg);
                if(statusCode.equals("200") || true) {
                    String meterData =  json.has(Constants.JSONRespMeterDataTag)? json.getString(Constants.JSONRespMeterDataTag) : null;
                    if(meterData != null)
                    {
                        JSONArray data = new JSONArray(meterData);
                        final LinkedList<MeterProfileModel> listMeters = new LinkedList<MeterProfileModel>();
                        if(data != null)
                        {
                            for(int ii=0; ii < data.length(); ii++)
                            {
                                JSONObject jsonItem =data.getJSONObject(ii);
                                String meterId = jsonItem.getString(Constants.JSONRespMeterIDTag);
                                String phoneUUId = jsonItem.getString(Constants.JSONRespPhoneUUIDTag);
                                double latitude = jsonItem.getDouble(Constants.JSONRespMeterLatitudeTag);
                                double longitude = jsonItem.getDouble(Constants.JSONRespMeterLongitudeTag);
                                listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId, false));

                            }
                            responseMsg  = "Meter profiles have been downloaded successfully.";
                        }
                        else
                        {
                            responseMsg  = "WARNING! Server response is success however data is not jsonarray parsable.";
                        }
                        //MeterProfilesDataHolder.getInstance().setListMeters(listMeters);
                        //Utilities.showToastMsg(HomeActivity.this, "Meter profiles have been refreshed!!!");
                    }
                    else
                    {
                        responseMsg = "WARNING! Meter data response from the server is null. Please try to download meters data again.";
                    }
                    MySharedPref.getInstance().setAccessCodeExpDate();
                    finish();
                    return;
                }
                else
                {
                    responseMsg = "ERROR! Response from the server " + statusMsg;
                }

            }
            catch (JSONException e) {
                final String eMessage = e != null ? e.getMessage() : "JSONException is NULL";
                responseMsg = "JSONException is thrown: " + eMessage;

            }
            catch (Exception e)
            {
                final String eMessage = e != null ? e.getMessage() : "Exception is NULL";
                responseMsg = "Exception is thrown: " + eMessage;

            }


            final String responseMsgFinal = responseMsg;
            MainActivity.this.runOnUiThread(new Runnable() {
                public void run() {
                    Utilities.showAlertDialog("Response", responseMsgFinal, MainActivity.this, getWindow(), false);
                }
            });
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            //Utilities.hideProgressBar(progressBar, getWindow(), true);
            Log.i(Constants.MyTag, "onCanceled");
            pleaseWaitDialog.dismiss();
        }

        @Override
        protected String  doInBackground(Void... params) {

           return sendPost();
        }
    }

    private String getQuery(List<Pair<String, String>> params) throws UnsupportedEncodingException
    {

        result = new StringBuilder();
        boolean first = true;

        for (Pair<String, String> pair : params)
        {
            if (first)
                first = false;
            else
                result.append("&");

            result.append(URLEncoder.encode(pair.first, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(pair.second, "UTF-8"));
        }

        return result.toString();
    }


    @Override
    public void onBackPressed() {
        //we need to override this to prevent back button from access code page
    }


}
