package my.ccs.projectrawdata;

import android.app.AlertDialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.media.Image;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;


import android.app.Activity;
import android.app.ProgressDialog;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.model.LatLng;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import my.ccs.projectrawdata.model.RawData;
import my.ccs.projectrawdata.sqlite.MySQLiteHelper;


public class MapActivity extends Activity {


    /**
     * 构造广播监听类，监听 SDK key 验证以及网络异常广播
     */
    /*public class SDKReceiver extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String s = intent.getAction();

            TextView text = (TextView) findViewById(R.id.text_Info);
            text.setTextColor(Color.RED);
            if (s.equals(SDKInitializer.SDK_BROADTCAST_ACTION_STRING_PERMISSION_CHECK_ERROR)) {
                text.setText("key 验证出错! 请在 AndroidManifest.xml 文件中检查 key 设置");
            } else if (s
                    .equals(SDKInitializer.SDK_BROADTCAST_ACTION_STRING_PERMISSION_CHECK_OK)) {
                text.setText("key 验证成功! 功能可以正常使用");
                text.setTextColor(Color.YELLOW);
            }
            else if (s
                    .equals(SDKInitializer.SDK_BROADCAST_ACTION_STRING_NETWORK_ERROR)) {
                text.setText("网络出错");
            }
        }
    }*/

    //private SDKReceiver mReceiver;

    BitmapDescriptor bdred = BitmapDescriptorFactory
            .fromResource(R.drawable.icon_ball_red);
    BitmapDescriptor bdgreen = BitmapDescriptorFactory
            .fromResource(R.drawable.icon_ball_green);

    // 定位相关
    LocationClient mLocClient;
    public MyLocationListenner myListener = new MyLocationListenner();
    private MyLocationConfiguration.LocationMode mCurrentMode;


    MapView mMapView;
    BaiduMap mBaiduMap;
    ListView metersListview;
    private ArrayAdapter<String> metersListAdapter;

    FrameLayout mapFrame;
    FrameLayout listFrame;
    LinearLayout topHeader;

    // UI相关
    boolean isFirstLoc = true; // 是否首次定位
    EditText inputSearchEditText;

    ImageButton switchToListBtn;
    ImageButton collectDataBtn;

    final List<MeterProfileModel> listMeters = new ArrayList<MeterProfileModel>();
    List<MeterProfileModel> listMetersFiltered = new ArrayList<>();


    @Override
    public void onCreate(Bundle savedInstanceState) {

        SDKInitializer.initialize(getApplicationContext());

        super.onCreate(savedInstanceState);



        setContentView(R.layout.activity_map);

        Bundle b = getIntent().getExtras();
        MeterProfileModel.MeterTypes chosenMeterType = MeterProfileModel.MeterTypes.fromInteger(b.getInt(Constants.ChosenMeterTypeKey));


        mapFrame = (FrameLayout) findViewById(R.id.mapFrame);
        listFrame = (FrameLayout) findViewById(R.id.listFrame);
        topHeader = (LinearLayout) findViewById(R.id.topHeader);
        topHeader.bringToFront();
        //listFrame.setBackgroundColor(0x45c01a);
        listFrame.bringToFront();
        FrameLayout.LayoutParams listFramePar = (FrameLayout.LayoutParams)listFrame.getLayoutParams();
        DisplayMetrics metrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int height = metrics.heightPixels;
        listFramePar.topMargin = 2*height/3;
        listFrame.setLayoutParams(listFramePar);
        metersListview = (ListView) findViewById(R.id.metersListView);

        //获取地图控件引用
        mMapView = (MapView) findViewById(R.id.bmapView);
        mMapView.showZoomControls(false);


        mBaiduMap = mMapView.getMap();

        mCurrentMode = MyLocationConfiguration.LocationMode.NORMAL;

        mBaiduMap
                .setMyLocationConfigeration(new MyLocationConfiguration(
                        mCurrentMode, true, null));

        mBaiduMap.setOnMapClickListener(new BaiduMap.OnMapClickListener() {
            @Override
            public void onMapClick(LatLng latLng) {
                hideList();
            }

            @Override
            public boolean onMapPoiClick(MapPoi mapPoi) {
                return false;
            }
        });

        // 开启定位图层
        mBaiduMap.setMyLocationEnabled(true);
        // 定位初始化
        mLocClient = new LocationClient(this);
        mLocClient.registerLocationListener(myListener);
        LocationClientOption option = new LocationClientOption();
        option.setOpenGps(true); // 打开gps
        option.setCoorType("bd09ll"); // 设置坐标类型
        option.setScanSpan(1000);
        mLocClient.setLocOption(option);
        mLocClient.start();
        switchToListBtn = (ImageButton)findViewById(R.id.switchToListBtn);
        //switchToListBtn.bringToFront();
        //LinearLayout.LayoutParams switchToBtnLayoutPar = (LinearLayout.LayoutParams)switchToListBtn.getLayoutParams();

        //int topMargin = 20;
       inputSearchEditText = (EditText)findViewById(R.id.inputSearchEditTxt);
       // inputSearchEditText.bringToFront();
        //LinearLayout.LayoutParams inpuSearchEditTextPar = (LinearLayout.LayoutParams)inputSearchEditText.getLayoutParams();
        //switchToBtnLayoutPar.topMargin= inpuSearchEditTextPar.height + topMargin;


        collectDataBtn = (ImageButton)findViewById(R.id.collectDataBtn);
        //collectDataBtn.bringToFront();
        //LinearLayout.LayoutParams collectDataBtnPar = (LinearLayout.LayoutParams)collectDataBtn.getLayoutParams();

        //collectDataBtnPar.topMargin=  inpuSearchEditTextPar.height + topMargin;


        /*
        BDLocation location = new BDLocation();
        location.setLatitude(39.913818);
        location.setLongitude(116.363625);
        if (location == null || mMapView == null) {
            return;
        }
        MyLocationData locData = new MyLocationData.Builder()
                .accuracy(location.getRadius())
                        // 此处设置开发者获取到的方向信息，顺时针0-360
                .direction(100).latitude(location.getLatitude())
                .longitude(location.getLongitude()).build();
        mBaiduMap.setMyLocationData(locData);
        if (isFirstLoc) {
            isFirstLoc = false;
            LatLng ll = new LatLng(location.getLatitude(),
                    location.getLongitude());
            MapStatusUpdate u = MapStatusUpdateFactory.newLatLng(ll);
            mBaiduMap.animateMapStatus(u);
        }
        */
        //MapStatusUpdate msu = MapStatusUpdateFactory.zoomTo(14.0f);
        //mBaiduMap.setMapStatus(msu);
        //initOverlay();
        /*mBaiduMap.setOnMarkerClickListener(new BaiduMap.OnMarkerClickListener() {
            public boolean onMarkerClick(final Marker marker) {
                Button button = new Button(getApplicationContext());
                button.setBackgroundResource(R.drawable.popup);
                InfoWindow.OnInfoWindowClickListener listener = null;
                if (marker == mMarkerA || marker == mMarkerD) {
                    button.setText("更改位置");
                    listener = new InfoWindow.OnInfoWindowClickListener() {
                        public void onInfoWindowClick() {
                            LatLng ll = marker.getPosition();
                            LatLng llNew = new LatLng(ll.latitude + 0.005,
                                    ll.longitude + 0.005);
                            marker.setPosition(llNew);
                            mBaiduMap.hideInfoWindow();
                        }
                    };
                    LatLng ll = marker.getPosition();
                    mInfoWindow = new InfoWindow(BitmapDescriptorFactory.fromView(button), ll, -47, listener);
                    mBaiduMap.showInfoWindow(mInfoWindow);
                } else if (marker == mMarkerB) {
                    button.setText("更改图标");
                    button.setOnClickListener(new OnClickListener() {
                        public void onClick(View v) {
                            marker.setIcon(bd);
                            mBaiduMap.hideInfoWindow();
                        }
                    });
                    LatLng ll = marker.getPosition();
                    mInfoWindow = new InfoWindow(button, ll, -47);
                    mBaiduMap.showInfoWindow(mInfoWindow);
                } else if (marker == mMarkerC) {
                    button.setText("删除");
                    button.setOnClickListener(new OnClickListener() {
                        public void onClick(View v) {
                            marker.remove();
                            mBaiduMap.hideInfoWindow();
                        }
                    });
                    LatLng ll = marker.getPosition();
                    mInfoWindow = new InfoWindow(button, ll, -47);
                    mBaiduMap.showInfoWindow(mInfoWindow);
                }
                return true;
            }
        });*/


        /*
        String meterId = "China";
        String phoneUUId = "TestPhone";

        double latitude =  39.963175;
        double longitude = 116.400244;
        listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId));
        latitude = 39.942821;
        longitude = 116.369199;
        meterId = "England";
        listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId));
        latitude = 39.939723;
        longitude = 116.425541;
        meterId = "America";
        listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId));
        latitude = 39.906965;
        longitude = 116.401394;
        meterId = "Armenia";
        listMeters.add(new MeterProfileModel(meterId, latitude, longitude, phoneUUId));


        MeterProfilesDataHolder.getInstance().setListMeters(listMeters);*/
        List<MeterProfileModel> allMeters = MeterProfilesDataHolder.getInstance().getListMeters();

        if(allMeters != null) {
            for (int i = 0; i < allMeters.size(); i++) {
                MeterProfileModel meter = allMeters.get(i);
                if (meter.MeterType == chosenMeterType) {
                    listMeters.add(meter);

                }
            }
        }
        listMetersFiltered = listMeters;
        initOverlay(listMeters);
        // get data from the table by the ListAdapter
        //MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, MeterProfilesDataHolder.getInstance().getListMeters());
        MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, listMeters);
        metersListview.setAdapter(customAdapter);

        //Utilities.showToastMsg(MapActivity.this, "Should show " + listMeters.size() + " meters.");





        inputSearchEditText.addTextChangedListener(new TextWatcher() {

            @Override
            public void onTextChanged(CharSequence cs, int arg1, int arg2, int arg3) {

                listMetersFiltered = filterMeters(listMeters, cs.toString());
                //Utilities.showToastMsg(MapActivity.this, cs.toString());
                //Utilities.showToastMsg(MapActivity.this, "After filtering " + listMetersFiltered.size());
                resetOverlay(listMetersFiltered);

                // get data from the table by the ListAdapter
                MetersListAdapter customAdapter = new MetersListAdapter(MapActivity.this, R.layout.meterlistrow, listMetersFiltered);

                metersListview.setAdapter(customAdapter);

            }

            @Override
            public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
                runOnUiThread(new Runnable() {
                    public void run() {
                    }
                });
            }

            @Override
            public void afterTextChanged(Editable arg0) {
                runOnUiThread(new Runnable() {
                    public void run() {
                    }
                });
            }
        });






        // 注册 SDK 广播监听者
        /*IntentFilter iFilter = new IntentFilter();
        iFilter.addAction(SDKInitializer.SDK_BROADTCAST_ACTION_STRING_PERMISSION_CHECK_OK);
        iFilter.addAction(SDKInitializer.SDK_BROADTCAST_ACTION_STRING_PERMISSION_CHECK_ERROR);
        iFilter.addAction(SDKInitializer.SDK_BROADCAST_ACTION_STRING_NETWORK_ERROR);
        mReceiver = new SDKReceiver();
        registerReceiver(mReceiver, iFilter);*/
    }


    public List<MeterProfileModel> filterMeters(List<MeterProfileModel> listMeters, String meterIdPattern) {


        List<MeterProfileModel> filteredListMeters = new LinkedList<>();
        if(listMeters != null) {
            Iterator<MeterProfileModel> carsIterator = listMeters.iterator();
            while (carsIterator.hasNext()) {
                MeterProfileModel c = carsIterator.next();
                if (c.MeterID.toLowerCase().contains(meterIdPattern.toLowerCase())) {
                    filteredListMeters.add(c);
                }
            }
        }
        return filteredListMeters;
    }

    public void collectData(View view) {
        //clearOverlay(null);
        //initOverlay();

        /*runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(MapActivity.this, "Collect Data", Toast.LENGTH_LONG).show();


            }
        });*/

        new CollectDataPostTask().execute();




        // Creating and Building the Dialog
        /*AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Select The Difficulty Level");
        builder.setSingleChoiceItems(Utilities.collectDataMethods, -1, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int item) {


                switch (item) {
                    case 0:
                        // Your code when first option seletced
                        break;
                    case 1:
                        // Your code when 2nd  option seletced

                        break;
                    case 2:
                        // Your code when 3rd option seletced
                        break;
                    case 3:
                        // Your code when 4th  option seletced
                        break;

                }
                chooseCollectDataMethoDialog.dismiss();
            }
        });
        chooseCollectDataMethoDialog = builder.create();
        chooseCollectDataMethoDialog.show();*/


    }


    private class CollectDataPostTask extends AsyncTask<Void, Void, String> {

        ProgressDialog pleaseWaitDialog;
        @Override
        protected void onPreExecute() {
            /*MapActivity.this.runOnUiThread(new Runnable() {
                public void run() {

                    Utilities.showAlertDialog("Response", "Data collection started.", MapActivity.this, getWindow(), false);

                }
            });
            if(collectDataProgressBar != null)
                collectDataProgressBar.setVisibility(View.VISIBLE);*/

            pleaseWaitDialog = ProgressDialog.show(MapActivity.this, Constants.DIALOGTITLE, "Collecting data...", true, true);
            pleaseWaitDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {

                public void onCancel(DialogInterface dialog) {
                    Log.e("MyTag", "onCancel");
                    CollectDataPostTask.this.cancel(true);
                }
            });

        }
        @Override
        protected void onPostExecute(final String result) {


            Log.i("MyTag", "onPostExecute");
            pleaseWaitDialog.dismiss();

            /*if(collectDataProgressBar != null)
                collectDataProgressBar.setVisibility(View.GONE);

            MapActivity.this.runOnUiThread(new Runnable() {
                public void run() {

                    Utilities.showAlertDialog("Response", "Data collection is finished.", MapActivity.this, getWindow(), false);

                }
            });*/

            if(listMetersFiltered != null ) {
                // get data from the table by the ListAdapter
                MetersListAdapter customAdapter = new MetersListAdapter(MapActivity.this, R.layout.meterlistrow, listMetersFiltered);

                metersListview.setAdapter(customAdapter);

                resetOverlay(listMetersFiltered);
            }



            MySQLiteHelper db = new MySQLiteHelper(MapActivity.this);

            //db.deleteAllRawData();

            /**
             * CRUD Operations
             * */
            // add Books
            db.addRawData(new RawData("measuretype", "meterid", "metertype", "metermodel",",manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));
            db.addRawData(new RawData("measuretype2", "meterid", "metertype", "metermodel", ",manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));
            db.addRawData(new RawData("measuretype3", "meterid", "metertype", "metermodel", ",manufacturer", "rateschedule", "readtype", "office", "MeterAddress", 1.2, 1.3, 1.4, "status", new Date()));


            // get all books


            final String responseMsgFinal = "Collected 3 records. Number of all raw data records is " + db.getAllRawData().size();
            MapActivity.this.runOnUiThread(new Runnable() {
                public void run() {

                    Utilities.showAlertDialog("Response", responseMsgFinal, MapActivity.this, getWindow(), false);

                }
            });




        }
        @Override
        protected void onCancelled() {
            super.onCancelled();

            Log.e("MyTag", "onCanceled");
            pleaseWaitDialog.dismiss();

        }

        @Override
        protected String  doInBackground(Void... params) {


            final int collectMetersCount = listMeters.size()/2;
            for(int i = 0; i< collectMetersCount; i++)
            {
                Random r = new Random();
                int i1 = r.nextInt(listMeters.size());
                listMeters.get(i1).isCollected = true;
            }



            return "NA";
        }
    }

    public void hideList() {



        if (isPanelShown()) {

            InputMethodManager inputMethodManager = (InputMethodManager)  this.getSystemService(Activity.INPUT_METHOD_SERVICE);
            inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);

            // Hide the Panel
            Animation bottomDown = AnimationUtils.loadAnimation(this,
                    R.anim.bottom_down);

            listFrame.startAnimation(bottomDown);
            listFrame.setVisibility(View.GONE);

            ResizeAnimation resizeAnimation = new ResizeAnimation(mapFrame, mapFrame.getWidth(), mapFrame.getHeight() + mapFrame.getHeight()/2);
            resizeAnimation.setDuration(500);
            mapFrame.startAnimation(resizeAnimation);
            //switchToListBtn.setText("Show the list");
            ((ImageButton) switchToListBtn).setImageResource(R.drawable.icon_checklist);
        }

    }


    public void switchToList(final View view) {

        InputMethodManager inputMethodManager = (InputMethodManager)  this.getSystemService(Activity.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);

        if (!isPanelShown()) {
            // Show the panel
            Animation bottomUp = AnimationUtils.loadAnimation(this,
                    R.anim.bottom_up);

            listFrame.startAnimation(bottomUp);
            listFrame.setVisibility(View.VISIBLE);
            //switchToListBtn.setText("Hide the list");


            final String str = mapFrame.getWidth() + " " + mapFrame.getHeight();
            final String str2 = listFrame.getWidth() + " " + listFrame.getHeight();
            runOnUiThread(new Runnable() {
                public void run() {
                    Toast.makeText(MapActivity.this, str, Toast.LENGTH_LONG).show();
                    Toast.makeText(MapActivity.this, str2, Toast.LENGTH_LONG).show();
                }
            });
            ResizeAnimation resizeAnimation = new ResizeAnimation(mapFrame, mapFrame.getWidth(), 2*mapFrame.getHeight()/3);
            resizeAnimation.setDuration(500);
            mapFrame.startAnimation(resizeAnimation);

            ((ImageButton) view).setImageResource(R.drawable.icon_earth);
        }
        else {
            // Hide the Panel
            Animation bottomDown = AnimationUtils.loadAnimation(this,
                    R.anim.bottom_down);

            listFrame.startAnimation(bottomDown);
            listFrame.setVisibility(View.GONE);

            final String str = mapFrame.getWidth() + " " + mapFrame.getHeight();
            final String str2 = listFrame.getWidth() + " " + listFrame.getHeight();
            runOnUiThread(new Runnable() {
                public void run() {
                    Toast.makeText(MapActivity.this, str, Toast.LENGTH_LONG).show();
                    Toast.makeText(MapActivity.this, str2, Toast.LENGTH_LONG).show();
                }
            });

            ResizeAnimation resizeAnimation = new ResizeAnimation(mapFrame, mapFrame.getWidth(), mapFrame.getHeight() + mapFrame.getHeight()/2);
            resizeAnimation.setDuration(500);
            mapFrame.startAnimation(resizeAnimation);
            //switchToListBtn.setText("Show the list");
            ((ImageButton) view).setImageResource(R.drawable.icon_checklist);
        }
    }

    private boolean isPanelShown() {
        return listFrame.getVisibility() == View.VISIBLE;
    }
    /*
    public void switchToMap(View view) {
        //clearOverlay(null);
        //initOverlay();

        runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(MapActivity.this, "Switch to Map", Toast.LENGTH_LONG).show();
            }
        });
        listFrame.setVisibility(View.INVISIBLE);
        mapFrame.setVisibility(View.VISIBLE);


    }

    public void switchToList(View view) {
        //clearOverlay(null);
        //initOverlay();

        runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(MapActivity.this, "Switch to List", Toast.LENGTH_LONG).show();
            }
        });
        mapFrame.setVisibility(View.INVISIBLE);
        listFrame.setVisibility(View.VISIBLE);

    }*/

    public void goToCurrentLocation(View view)
    {
        if(mBaiduMap != null)
        {
            MyLocationData currentLocation = mBaiduMap.getLocationData();
            if(currentLocation != null)
            {
                mBaiduMap.setMyLocationData(currentLocation);
                LatLng ll = new LatLng(currentLocation.latitude,
                        currentLocation.longitude);
                MapStatusUpdate u = MapStatusUpdateFactory.newLatLng(ll);
                mBaiduMap.animateMapStatus(u);
            }
        }
    }

    public void searchOverlay(View view) {
        //clearOverlay(null);
        //initOverlay();

        /*runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(MapActivity.this, "Search", Toast.LENGTH_LONG).show();
            }
        });*/

    }

    public void resetOverlay(List<MeterProfileModel> listMeters) {
        clearOverlay(null);
        initOverlay(listMeters);

    }


    /**
     * 定位SDK监听函数
     */
    public class MyLocationListenner implements BDLocationListener {

        @Override
        public void onReceiveLocation(BDLocation location) {
            // map view 销毁后不在处理新接收的位置

            location.setLatitude(39.913818);
            location.setLongitude(116.363625);

            if (location == null || mMapView == null) {
                return;
            }
            MyLocationData locData = new MyLocationData.Builder()
                    .accuracy(location.getRadius())
                            // 此处设置开发者获取到的方向信息，顺时针0-360
                    .direction(100).latitude(location.getLatitude())
                    .longitude(location.getLongitude()).build();

            mBaiduMap.setMyLocationData(locData);
            if (isFirstLoc) {
                isFirstLoc = false;
                LatLng ll = new LatLng(location.getLatitude(),
                        location.getLongitude());
                MapStatusUpdate u = MapStatusUpdateFactory.newLatLng(ll);
                mBaiduMap.animateMapStatus(u);
            }
        }

        public void onReceivePoi(BDLocation poiLocation) {
        }
    }


    @Override
    protected void onPause() {
        mMapView.onPause();
        super.onPause();
    }

    @Override
    protected void onResume() {
        mMapView.onResume();
        super.onResume();

        if(Utilities.isAccessCodeExpired()) {
            Intent nextScreen = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(nextScreen);
        }
        else
        {
            MySharedPref.getInstance().setAccessCodeExpDate();
        }

    }

    @Override
    protected void onDestroy() {
        // 回收 bitmap 资源

        bdred.recycle();
        bdgreen.recycle();
        //bdGround.recycle();
        //unregisterReceiver(mReceiver);
        // 退出时销毁定位
        //mLocClient.stop();
        // 关闭定位图层
        mBaiduMap.setMyLocationEnabled(false);
        mMapView.onDestroy();
        mMapView = null;
        super.onDestroy();
    }
    /**
     * 清除所有Overlay
     *
     * @param view
     */
    public void clearOverlay(View view) {
        mBaiduMap.clear();
    }

    public void initOverlay( List<MeterProfileModel> listMeters) {
        // add marker overlay
        /*LatLng llA = new LatLng(39.963175, 116.400244);
        LatLng llB = new LatLng(39.942821, 116.369199);
        LatLng llC = new LatLng(39.939723, 116.425541);
        LatLng llD = new LatLng(39.906965, 116.401394);

        MarkerOptions ooA = new MarkerOptions().position(llA).icon(bdA)
                .zIndex(9).draggable(true);
        ooA.animateType(MarkerOptions.MarkerAnimateType.drop);
        mMarkerA = (Marker) (mBaiduMap.addOverlay(ooA));

        MarkerOptions ooB = new MarkerOptions().position(llB).icon(bdB)
                .zIndex(5);
        mMarkerB = (Marker) (mBaiduMap.addOverlay(ooB));

        MarkerOptions ooC = new MarkerOptions().position(llC).icon(bdC)
                .perspective(false).anchor(0.5f, 0.5f).rotate(30).zIndex(7);
        mMarkerC = (Marker) (mBaiduMap.addOverlay(ooC));

        ArrayList<BitmapDescriptor> giflist = new ArrayList<BitmapDescriptor>();
        giflist.add(bdA);
        giflist.add(bdB);
        giflist.add(bdC);
        MarkerOptions ooD = new MarkerOptions().position(llD).icons(giflist)
                .zIndex(0).period(10);
        mMarkerD = (Marker) (mBaiduMap.addOverlay(ooD));*/

        //listMeters = MeterProfilesDataHolder.getInstance().getListMeters();


        if(listMeters != null)
        {
            //Utilities.showToastMsg(MapActivity.this, "Showing " + listMeters.size() + " meters.");
            for (MeterProfileModel meter : listMeters) {
                LatLng llA = new LatLng(meter.Latitude, meter.Longitude);

                //Utilities.showToastMsg(MapActivity.this, meter.Latitude + " " + meter.Longitude);

                if(meter.isCollected)
                {
                    MarkerOptions ooA = new MarkerOptions().position(llA).icon(bdgreen)
                            .perspective(false).anchor(0.5f, 0.5f).zIndex(7);
                    //ooA.animateType(MarkerOptions.MarkerAnimateType.drop);
                    mBaiduMap.addOverlay(ooA);
                }
                else
                {
                    MarkerOptions ooA = new MarkerOptions().position(llA).icon(bdred)
                            .perspective(false).anchor(0.5f, 0.5f).zIndex(7);
                    //ooA.animateType(MarkerOptions.MarkerAnimateType.drop);
                    mBaiduMap.addOverlay(ooA);
                }

            }
        }

    }


}
