package my.ccs.projectrawdata;

import android.app.ActionBar;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class MeterProfilesDataHolder {
    List<MeterProfileModel> listMeters = new LinkedList<>();
    public List<MeterProfileModel> getListMeters() {return listMeters;}
    public void setListMeters(List<MeterProfileModel> data) {this.listMeters = data;}

    private static final MeterProfilesDataHolder holder = new MeterProfilesDataHolder();
    public static MeterProfilesDataHolder getInstance() {return holder;}
}


class MeterProfileModel
{

    public String MeterDataID;
    public String MeterSN;
    public String MeterNumber;
    public String MeterAddress;
    public String MeterApartmentNumber;
    public String MeterID;
    public double Latitude;
    public double Longitude;
    public String PhoneUUID;
    public boolean isCollected = false;
    public enum MeterTypes {
        WiFi,
        Bluetooth,
        Bus,
        Manual;

        public static MeterTypes fromInteger(int x) {
            switch(x) {
                case 0:
                    return WiFi;
                case 1:
                    return Bluetooth;
                case 2:
                    return Bus;
                case 3:
                    return Manual;

            }
            return Manual;
        }

    };
    public MeterTypes MeterType;


    public MeterProfileModel(String MeterID, double Latitude, double Longitude, String PhoneUUID, boolean isCollected)
    {
        this.MeterID = MeterID;
        this.Latitude = Latitude;
        this.Longitude = Longitude;
        this.PhoneUUID = PhoneUUID;
        Random  rand = new Random();
        this.MeterType = MeterTypes.fromInteger(rand.nextInt(4));
        this.isCollected = isCollected;
    }
}

class MeterProfilesFilter extends Filter {

    @Override
    protected FilterResults performFiltering(CharSequence constraint) {
        FilterResults result = new FilterResults();
        List<MeterProfileModel> allMeters = MeterProfilesDataHolder.getInstance().getListMeters();
        if(constraint == null || constraint.length() == 0){

            result.values = allMeters;
            result.count = allMeters.size();
        }else{
            ArrayList<MeterProfileModel> filteredList = new ArrayList<MeterProfileModel>();
            for(MeterProfileModel j: allMeters){
                if(j.MeterID.contains(constraint))
                    filteredList.add(j);
            }
            result.values = filteredList;
            result.count = filteredList.size();
        }

        return result;
    }
    @SuppressWarnings("unchecked")
    @Override
    protected void publishResults(CharSequence constraint, FilterResults results) {
        if (results.count == 0) {
           // notifyDataSetInvalidated();
        } else {
           // items = (ArrayList<JournalModel>) results.values;
           // notifyDataSetChanged();
        }
    }

}


class MetersListAdapter extends ArrayAdapter<MeterProfileModel> {

    public MetersListAdapter(Context context, int textViewResourceId) {
        super(context, textViewResourceId);
    }

    public MetersListAdapter(Context context, int resource, List<MeterProfileModel> items) {
        super(context, resource, items);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        View v = convertView;

        if (v == null) {
            LayoutInflater vi;
            vi = LayoutInflater.from(getContext());
            v = vi.inflate(R.layout.meterlistrow, parent, false);
            DisplayMetrics metrics = new DisplayMetrics();
            ((WindowManager)getContext().getSystemService(Context.WINDOW_SERVICE)).getDefaultDisplay().getMetrics(metrics);
            int screenHeight = metrics.heightPixels;

            v.setLayoutParams(new AbsListView.LayoutParams(AbsListView.LayoutParams.MATCH_PARENT, screenHeight/18));
        }




        MeterProfileModel p = getItem(position);

        if (p != null) {
            TextView tt1 = (TextView) v.findViewById(R.id.meterId);

            if (tt1 != null) {
                tt1.setText(p.MeterID);
            }


            /*ImageView img1 = (ImageView) v.findViewById(R.id.metercolorimg);
            if(p.isCollected)
            {
                img1.setImageResource(R.drawable.icon_ball_green);

            }
            else
            {
                img1.setImageResource(R.drawable.icon_ball_red);
            }*/


        }

        return v;
    }

}



