package my.ccs.projectrawdata;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import java.util.Date;

/**
 * Created by Hayk on 12/24/2015.
 */
public class MySharedPref {

    public static String MY_PREFS_NAME = "mysharedpref";
    public static String ACCESSCODE_EXP_DATE_TAG = "accesscodeexpdate";

    private static MySharedPref sInstance;
    public final SharedPreferences prefs;

    private MySharedPref(Context context)
    {
        prefs = context.getSharedPreferences(MY_PREFS_NAME, context.MODE_PRIVATE);
    }

    public static synchronized void initializeInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MySharedPref(context);
        }
    }

    public static synchronized MySharedPref getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException(MySharedPref.class.getSimpleName() +
                    " is not initialized, call initializeInstance(..) method first.");
        }
        return sInstance;
    }


    public void setAccessCodeExpDate()
    {


        Date now = new Date();
        Date validUntil = new Date(now.getTime() + Constants.ACCESSCODE_EXPIRATION_PERIOD);
        Log.i(Constants.MyTag, "Today is " + now);
        Log.i(Constants.MyTag, "Access code valid until " + validUntil.getTime());

        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(ACCESSCODE_EXP_DATE_TAG, validUntil.getTime());
        editor.commit();


    }

    public Date getAccessCodeExpDate()
    {
        long l = prefs.getLong(ACCESSCODE_EXP_DATE_TAG, -1);
        if(l != -1)
        {
            return  new Date(l);
        }

        return  null;
    }

    public boolean clear() {
        return prefs.edit()
                .clear()
                .commit();
    }

}
