package my.ccs.projectrawdata;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;

import java.util.LinkedList;

/**
 * Created by Hayk on 12/6/2015.
 */
public class UploadDataActivity extends Activity {

    ProgressBar progressBar;
    WebView webView;
    private ValueCallback<Uri> mUploadMessage;
    private final static int FILECHOOSER_RESULTCODE=1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_uploaddata);

        progressBar = (ProgressBar) findViewById(R.id.uploadDataProgressBar);
        initWebView();
        if(webView != null)
        {
            webView.loadUrl(Constants.uploadDataUrl);
        }
    }

    protected void initWebView()
    {
        webView = (WebView) findViewById(R.id.uploadDataWebView);
        if(webView != null) {
            WebSettings webSettings = webView.getSettings();
            webSettings.setBuiltInZoomControls(true);
            webSettings.setJavaScriptEnabled(true);
            webSettings.setGeolocationEnabled(true);
            webSettings.setAppCacheEnabled(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setDomStorageEnabled(true);

            webView.getSettings().setUserAgentString(
                    this.webView.getSettings().getUserAgentString()
                            + " "
                            + "ccschinaportalmobile/1.0"
            );
            //webView.setWebChromeClient(new WebChromeClient());
            webView.setWebChromeClient(new WebChromeClient() {
                //The undocumented magic method override
                //Eclipse will swear at you if you try to put @Override here
                // For Android 3.0+
                public void openFileChooser(ValueCallback<Uri> uploadMsg) {

                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    UploadDataActivity.this.startActivityForResult(Intent.createChooser(i, "File Chooser"), FILECHOOSER_RESULTCODE);

                }

                // For Android 3.0+
                public void openFileChooser(ValueCallback uploadMsg, String acceptType) {
                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    UploadDataActivity.this.startActivityForResult(
                            Intent.createChooser(i, "File Browser"),
                            FILECHOOSER_RESULTCODE);
                }

                //For Android 4.1
                public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    UploadDataActivity.this.startActivityForResult(Intent.createChooser(i, "File Chooser"), UploadDataActivity.FILECHOOSER_RESULTCODE);

                }

                public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                    callback.invoke(origin, true, false);
                }


            });


            webView.setWebViewClient(new Callback());
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode,
                                    Intent intent) {
        if(requestCode==FILECHOOSER_RESULTCODE)
        {
            if (null == mUploadMessage) return;
            Uri result = intent == null || resultCode != RESULT_OK ? null
                    : intent.getData();
            mUploadMessage.onReceiveValue(result);
            mUploadMessage = null;
        }
    }

    @Override
    protected void onResume() {
        Log.e("MyTag", "Resume called");
        super.onResume();

        if(Utilities.isAccessCodeExpired()) {
            Log.i("MyTag", "Expired");
            Intent nextScreen = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(nextScreen);
        }
        else
        {
            MySharedPref.getInstance().setAccessCodeExpDate();
        }

    }
    private class Callback extends WebViewClient {


        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if(progressBar != null) {
                progressBar.setVisibility(View.VISIBLE);

            }
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {

            return (false);
        }

        //This is called when page is finished loading
        @Override
        public void onPageFinished(WebView view, String url)
        {
            //Toast.makeText(MainActivity.this, url, Toast.LENGTH_LONG).show();
            if(progressBar != null) {
                progressBar.setVisibility(View.GONE);
            }



        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {

        }

    }


}
