package my.ccs.projectrawdata;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.mapapi.SDKInitializer;

import javax.net.ssl.HttpsURLConnection;

import my.ccs.projectrawdata.sqlite.MySQLiteHelper;

public class UploadMeterInfoActivity extends Activity {

    // LogCat tag
    private static final String TAG = "MyTag";


    // Camera activity request codes
    private static final int CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100;
    private static final int CAMERA_CAPTURE_VIDEO_REQUEST_CODE = 200;

    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;

    private Uri fileUri; // file url to store image/video

    private ImageButton btnUploadMeterInfo;
    private ImageButton imgPreview1;
    private ImageButton imgPreview2;
    private ImageButton imgPreview3;
    private ImageButton imgPreview4;
    private ImageButton locImg;

    private EditText meterAddressTextField;
    private EditText meterAreaTextField;
    private EditText meterLatTextField;
    private EditText meterLongTextField;

    Bitmap bitmapIconFrame;
    Bitmap bitmapIconUpload;

    List<ImageButton> imageButtons = new LinkedList<>();
    private ImageButton currentImageButton;
    int displayWidth;
    int displayHeight;
    ListView listView;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        SDKInitializer.initialize(getApplicationContext());
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_upload_meter_info);

        // Changing action bar background color
        // These two lines are not needed




        DisplayMetrics metrics = new DisplayMetrics();
        getWindow().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        //getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(0));
        displayWidth = metrics.widthPixels;
        displayHeight = metrics.heightPixels;


        listView = (ListView) findViewById(R.id.listView);

        // get data from the table by the ListAdapter
        //MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, MeterProfilesDataHolder.getInstance().getListMeters());
        MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, MeterProfilesDataHolder.getInstance().getListMeters());
        listView.setAdapter(customAdapter);


        btnUploadMeterInfo = (ImageButton) findViewById(R.id.btnUploadMeterInfo);
        imgPreview1 = (ImageButton) findViewById(R.id.imgPreview1);
        imgPreview2 = (ImageButton) findViewById(R.id.imgPreview2);
        imgPreview3 = (ImageButton) findViewById(R.id.imgPreview3);
        imgPreview4 = (ImageButton) findViewById(R.id.imgPreview4);
        imageButtons.add(imgPreview1);
        imageButtons.add(imgPreview2);
        imageButtons.add(imgPreview3);
        imageButtons.add(imgPreview4);

        meterAddressTextField = (EditText) findViewById(R.id.meterAddressTxtField);
        meterAreaTextField = (EditText) findViewById(R.id.meterAreaTxtField);
        meterLatTextField = (EditText) findViewById(R.id.meterLatTxtField);
        meterLongTextField = (EditText) findViewById(R.id.meterLongTxtField);

        meterLatTextField.setText("37.68");
        meterLongTextField.setText("112.17");


        locImg = (ImageButton) findViewById(R.id.locImg);
        locImg.setOnClickListener(new View.OnClickListener() {
            public void onClick(View view) {


                Intent nextScreen = new Intent(getApplicationContext(), MapDialogActivity.class);
                startActivity(nextScreen);

            }
        });


        bitmapIconUpload = BitmapFactory.decodeResource(getResources(), R.drawable.icon_document_save);
        bitmapIconUpload=Bitmap.createScaledBitmap(bitmapIconUpload, displayWidth/6, displayWidth/6, true);
        btnUploadMeterInfo.setImageBitmap(bitmapIconUpload);

        /**
         * Upload meter info button click event
         */
        btnUploadMeterInfo.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                Toast.makeText(getApplicationContext(),
                        "Upload pressed!!!",
                        Toast.LENGTH_LONG).show();
                new SendPostUploadTask().execute();
            }
        });


        // Checking camera availability
        if (!isDeviceSupportCamera()) {
            Toast.makeText(getApplicationContext(),
                    "Sorry! Your device doesn't support camera",
                    Toast.LENGTH_LONG).show();
            // will close the app if the device does't have camera
            finish();
        }

        bitmapIconFrame = BitmapFactory.decodeResource(getResources(), R.drawable.icon_frame);
        bitmapIconFrame=Bitmap.createScaledBitmap(bitmapIconFrame, displayWidth/5, displayWidth/5, true);

        imgPreview1.setImageBitmap(bitmapIconFrame);
        imgPreview2.setImageBitmap(bitmapIconFrame);
        imgPreview3.setImageBitmap(bitmapIconFrame);
        imgPreview4.setImageBitmap(bitmapIconFrame);

        for(final ImageButton imageButton : imageButtons)
        {
            imageButton.setOnClickListener(new View.OnClickListener() {
                public void onClick(View view) {

                    // custom dialog
                    final Dialog dialog = new Dialog(UploadMeterInfoActivity.this);
                    Window window = dialog.getWindow();
                    window.requestFeature(Window.FEATURE_NO_TITLE);
                    dialog.setContentView(R.layout.choose_picture_action);
                    window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                    dialog.setCancelable(true);


                    ImageButton btnCapturePicture;
                    ImageButton btnRemovePicture;

                    TextView btnCapturePictureTxt;
                    TextView btnRemovePictureTxt;



                    btnCapturePicture = (ImageButton) dialog.findViewById(R.id.btnCapturePicture);
                    btnRemovePicture = (ImageButton) dialog.findViewById(R.id.btnRemovePicture);
                    btnCapturePictureTxt = (TextView) dialog.findViewById(R.id.btnCapturePictureTxt);
                    btnRemovePictureTxt = (TextView) dialog.findViewById(R.id.btnRemovePictureTxt);
                    /**
                     * Capture image button click event
                     */
                    btnCapturePicture.setOnClickListener(new View.OnClickListener() {

                        @Override
                        public void onClick(View v) {
                            // capture picture
                            if(dialog != null)
                            {
                                dialog.dismiss();
                            }
                            currentImageButton = imageButton;
                            captureImage();



                        }
                    });
                    btnCapturePictureTxt.setOnClickListener(new View.OnClickListener() {
                        public void onClick(View view) {
                            // capture picture
                            if(dialog != null)
                            {
                                dialog.dismiss();
                            }
                            currentImageButton = imageButton;
                            captureImage();


                        }
                    });


                    /**
                     * Capture image button click event
                     */
                    btnRemovePicture.setOnClickListener(new View.OnClickListener() {

                        @Override
                        public void onClick(View v) {

                            if(dialog != null)
                            {
                                dialog.dismiss();
                            }
                            imageButton.setImageBitmap(bitmapIconFrame);

                        }
                    });
                    btnRemovePictureTxt.setOnClickListener(new View.OnClickListener() {
                        public void onClick(View view) {
                            if(dialog != null)
                            {
                                dialog.dismiss();
                            }
                            imageButton.setImageBitmap(bitmapIconFrame);


                        }
                    });

                    dialog.show();


                }
            });

        }


    }

    /**
     * Displaying captured image/video on the screen
     * */
    private void previewMedia(boolean isImage) {
        // Checking whether captured media is image or video
        if (isImage) {
            if(currentImageButton != null)
            {
                currentImageButton.setVisibility(View.VISIBLE);
                // bimatp factory

                DisplayMetrics metrics = new DisplayMetrics();
                getWindow().getWindowManager().getDefaultDisplay().getMetrics(metrics);
                //getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(0));
                int width = metrics.widthPixels/5;
                int height = width;



                Bitmap bitmap = BitmapFactory.decodeFile( fileUri.getPath());
                bitmap=Bitmap.createScaledBitmap(bitmap, width,height, true);
                currentImageButton.setImageBitmap(bitmap);
            }

        }
    }

    /**
     * Checking device has camera hardware or not
     * */
    private boolean isDeviceSupportCamera() {
        if (getApplicationContext().getPackageManager().hasSystemFeature(
                PackageManager.FEATURE_CAMERA)) {
            // this device has a camera
            return true;
        } else {
            // no camera on this device
            return false;
        }
    }

    /**
     * Launching camera app to capture image
     */
    private void captureImage() {
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

        fileUri = getOutputMediaFileUri(MEDIA_TYPE_IMAGE);

        intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);

        // start the image capture Intent
        startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE);
    }


    /**
     * Here we store the file url as it will be null after returning from camera
     * app
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);

        // save file url in bundle as it will be null on screen orientation
        // changes
        outState.putParcelable("file_uri", fileUri);
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);

        // get the file url
        fileUri = savedInstanceState.getParcelable("file_uri");
    }



    /**
     * Receiving activity result method will be called after closing the camera
     * */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        // if the result is capturing Image
        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {

                // successfully captured the image
                // launching upload activity
                //launchUploadActivity(true);
                String filePath = fileUri.getPath();
                if (filePath != null) {
                    /*Toast.makeText(getApplicationContext(),
                            "Filepath " + filePath, Toast.LENGTH_LONG).show();*/

                    // Displaying the image or video on the screen
                    previewMedia(true);
                } else {
                    Toast.makeText(getApplicationContext(),
                            "Sorry, file path is missing!", Toast.LENGTH_LONG).show();
                }



            } else if (resultCode == RESULT_CANCELED) {

                // user cancelled Image capture
                Toast.makeText(getApplicationContext(),
                        "User cancelled image capture", Toast.LENGTH_SHORT)
                        .show();

            } else {
                // failed to capture image
                Toast.makeText(getApplicationContext(),
                        "Sorry! Failed to capture image", Toast.LENGTH_SHORT)
                        .show();
            }

        }
    }

    /*private void launchUploadActivity(boolean isImage){
        Intent i = new Intent(UploadMeterInfoActivity.this, UploadActivity.class);
        i.putExtra("filePath", fileUri.getPath());
        i.putExtra("isImage", isImage);
        startActivity(i);
    }*/

    /**
     * ------------ Helper Methods ----------------------
     * */

    /**
     * Creating file uri to store image/video
     */
    public Uri getOutputMediaFileUri(int type) {
        return Uri.fromFile(getOutputMediaFile(type));
    }

    /**
     * returning image / video
     */
    private static File getOutputMediaFile(int type) {

        // External sdcard location
        File mediaStorageDir = new File(
                Environment
                        .getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES),
                Constants.IMAGE_DIRECTORY_NAME);

        // Create the storage directory if it does not exist
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                Log.d(TAG, "Oops! Failed create "
                        + Constants.IMAGE_DIRECTORY_NAME + " directory");
                return null;
            }
        }

        // Create a media file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss",
                Locale.getDefault()).format(new Date());
        File mediaFile;
        if (type == MEDIA_TYPE_IMAGE) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator
                    + "IMG_" + timeStamp + ".jpg");
        } else if (type == MEDIA_TYPE_VIDEO) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator
                    + "VID_" + timeStamp + ".mp4");
        } else {
            return null;
        }

        return mediaFile;
    }

    @Override
    public void onResume(){
        super.onResume();
        Log.e(Constants.MyTag, "Resume called");
        //Starting Home Activity
        if(Utilities.isAccessCodeExpired()) {
            Log.i(Constants.MyTag, "Expired");
            Intent nextScreen = new Intent(getApplicationContext(), MainActivity.class);
            startActivity(nextScreen);
        }
        else
        {
            MySharedPref.getInstance().setAccessCodeExpDate();

        }

    }

    static class DataUploadStatus
    {
        public enum STATUS{
            NO_DATA,
            FILE_DOESNOTEXIST,
            UNKNOWN_ERROR,
            SUCCESS
        }

        STATUS status;
        String msg;
        public DataUploadStatus(STATUS status, String msg)
        {
            this.status = status;
            this.msg = msg;
        }
    }

    private class S3TaskResult {
        public Uri uri = null;
        public String errorMessage = null;

    }

    private class SendPostUploadTask extends AsyncTask<Void, Void, DataUploadStatus> {

        ProgressDialog pleaseWaitDialog;

        String result= "";

        @Override
        protected void onPreExecute() {
            pleaseWaitDialog = ProgressDialog.show(UploadMeterInfoActivity.this, Constants.DIALOGTITLE, "Uploading meter info...", true, true);
            pleaseWaitDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {

                public void onCancel(DialogInterface dialog) {
                    Log.e(Constants.MyTag, "onCancel");
                    SendPostUploadTask.this.cancel(true);
                }
            });

        }


        @Override
        protected void onPostExecute(final DataUploadStatus result) {

            Log.i("MyTag", "onPostExecute");
            pleaseWaitDialog.dismiss();


            String responseMsg = "Undefined response.";

            if(result != null)
            {
                responseMsg = result.status + " " + result.msg;
            }



            final String responseMsgFinal = responseMsg;
            UploadMeterInfoActivity.this.runOnUiThread(new Runnable() {
                public void run() {

                    Utilities.showAlertDialog("Response", responseMsgFinal, UploadMeterInfoActivity.this, getWindow(), false);

                }
            });





        }
        @Override
        protected void onCancelled() {
            super.onCancelled();
            //Utilities.hideProgressBar(progressBarDownloadMeters, getWindow(), true);
            Log.e("MyTag", "onCanceled");
            pleaseWaitDialog.dismiss();

        }
        String targetUrl = "http://cloudcomspace.cloudapp.net/RawData/UploadMeterInfoMobile";
        String lineEnd = "\r\n";

        MySQLiteHelper dbhelper = new MySQLiteHelper(UploadMeterInfoActivity.this);
        int dataCount = 0;
        String response = "error";


        Bitmap ShrinkBitmap(String file, int width, int height)
        {

            BitmapFactory.Options bmpFactoryOptions = new BitmapFactory.Options();
            bmpFactoryOptions.inJustDecodeBounds = true;
            Bitmap bitmap = BitmapFactory.decodeFile(file, bmpFactoryOptions);

            int heightRatio = (int)Math.ceil(bmpFactoryOptions.outHeight/(float)height);
            int widthRatio = (int)Math.ceil(bmpFactoryOptions.outWidth/(float)width);

            if (heightRatio > 1 || widthRatio > 1)
            {
                if (heightRatio > widthRatio)
                {
                    bmpFactoryOptions.inSampleSize = heightRatio;
                } else {
                    bmpFactoryOptions.inSampleSize = widthRatio;
                }
            }

            bmpFactoryOptions.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile(file, bmpFactoryOptions);
            return bitmap;
        }

        @Override
        protected DataUploadStatus  doInBackground(Void... params) {



            try {


                /*File sqliteDB = getDatabasePath(MySQLiteHelper.DATABASE_NAME);
                if(sqliteDB ==null ||  !sqliteDB.exists())
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "SQLite database does not exist");





                dataCount = dbhelper.getAllRawData().size();
                dataCount=2;
                if(dataCount == 0)
                {
                    return  new DataUploadStatus(DataUploadStatus.STATUS.NO_DATA, "No data to upload.");

                }

                dbhelper.exportDB();

                File csvDB = getDatabasePath(MySQLiteHelper.ExportCSVName);
                if(csvDB == null || !csvDB.exists())
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "CSV database does not exist.");

                final String responseMsgFinal3 = csvDB.getAbsolutePath() + " path";
                UploadMeterInfoActivity.this.runOnUiThread(new Runnable() {
                    public void run() {

                        Utilities.showAlertDialog("Response", responseMsgFinal3, UploadMeterInfoActivity.this, getWindow(), false);

                    }
                });
                */
                /*if(params == null || params.length == 0)
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "Parameters list is empty.");

                Drawable drawable = params[0];
                if(drawable == null)
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "No image passed.");

                */
                if(fileUri ==null ||  fileUri.getPath() == null)
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "Image file does not exist");


                File imageFile = new File(fileUri.getPath()); //new File("/storage/emulated/0/photo.jpg"); //
                if(!imageFile.exists())
                    return  new DataUploadStatus(DataUploadStatus.STATUS.FILE_DOESNOTEXIST, "Image file does not exist");

                String pathToOurFile = imageFile.getAbsolutePath();//csvDB.getAbsolutePath();
                String urlServer = targetUrl;
                /*
                Bitmap bitmap = ShrinkBitmap(pathToOurFile, 200, 200 ); //((BitmapDrawable) drawable).getBitmap();//BitmapFactory.decodeFile( imageFile.getPath(), options);;



                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 0, bos);
                byte[] bitmapdata = bos.toByteArray();*/


                HttpURLConnection connection = null;
                DataOutputStream outputStream = null;
                // DataInputStream inputStream = null;



                int bytesRead, bytesAvailable, bufferSize;
                byte[] buffer;
                int maxBufferSize = 1 * 1024;

                //ByteArrayInputStream fileInputStream = new ByteArrayInputStream(bitmapdata);


                URL url = new URL(urlServer);
                connection = (HttpURLConnection) url.openConnection();

                // Allow Inputs & Outputs
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setChunkedStreamingMode(1024);
                // Enable POST method
                connection.setRequestMethod("POST");

                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setRequestProperty("Content-Type",
                        "multipart/form-data");

                connection.setRequestProperty("MeterId",
                        "Meter1");


                outputStream = new DataOutputStream(connection.getOutputStream());


                //outputStream.writeBytes("meterid=" + "testmeter"+ ";meterlatitude=" + "36.2" + ";meterlongitude" + "105.6" + lineEnd);

                outputStream.writeBytes("---Meterid=" + "Meter1" + "---");
                outputStream.writeBytes("Meterlat=" + "34.5" + "---");
                outputStream.writeBytes("Meterlong=" + "102.5" + "---");

                for(int i = 0; i < 5; i++) {
                    FileInputStream fileInputStream = new FileInputStream(new File(
                            pathToOurFile));

                    bytesAvailable = fileInputStream.available();
                    bufferSize = Math.min(bytesAvailable, maxBufferSize);
                    buffer = new byte[bufferSize];

                    // Read file
                    bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                    Log.e("MyTag", bytesAvailable + " bytes available");

                    final String responseMsgFinal = bytesAvailable + " bytes available";
                    UploadMeterInfoActivity.this.runOnUiThread(new Runnable() {
                        public void run() {


                            Utilities.showAlertDialog("Response", responseMsgFinal, UploadMeterInfoActivity.this, getWindow(), false);

                        }
                    });

                    try {
                        while (bytesRead > 0) {
                            try {
                                outputStream.write(buffer, 0, bufferSize);
                            } catch (OutOfMemoryError e) {
                                return new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, "Out of memory error occur.");
                            }
                            bytesAvailable = fileInputStream.available();
                            bufferSize = Math.min(bytesAvailable, maxBufferSize);
                            bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                        }
                    } catch (Exception e) {
                        Log.e("MyTag", "Exception in out is " + e.getMessage() + "");
                        final String responseMsgFinal2 = "Exception in out is " + e.getMessage() + "";
                        UploadMeterInfoActivity.this.runOnUiThread(new Runnable() {
                            public void run() {

                                Utilities.showAlertDialog("Response", responseMsgFinal2, UploadMeterInfoActivity.this, getWindow(), false);

                            }
                        });

                        return new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, e.getMessage());
                    }

                    fileInputStream.close();

                }
                /////////////


                /////////////

                outputStream.flush();
                outputStream.close();


                // Responses from the server (code and message)

                int responseCode=connection.getResponseCode();

                if (responseCode == HttpsURLConnection.HTTP_OK) {

                    response = "";
                    String line;
                    BufferedReader br=new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line=br.readLine()) != null) {
                        response+=line;
                    }
                }
                else {
                    return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, "Failed with response code: " + responseCode);

                }

                Log.e("MyTag", response);

            } catch (Exception ex) {
                return  new DataUploadStatus(DataUploadStatus.STATUS.UNKNOWN_ERROR, ex.getMessage());
            }



            return  new DataUploadStatus(DataUploadStatus.STATUS.SUCCESS, "Data have been uploaded successfully." + response);


        }
    }


}
