package my.ccs.projectrawdata;

import android.app.Activity;
import android.app.DialogFragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.LinearGradient;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.os.Bundle;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by Hayk on 12/12/2015.
 */
public class Utilities {



    // Strings to Show In Dialog with Radio Buttons
    static CharSequence[] collectDataMethods = {
            "通过蓝牙采集数据(开发中)",
            "通过无线采集数据(开发中)",
            "通过总线采集数据(开发中)",
            "手动输入采集读数(开发中)"

    };


    public static void showToastMsg(Activity activity, final String message) {
        final Context context = activity;
        activity.runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(context, message, Toast.LENGTH_LONG).show();
            }
        });

    }

    public static void showProgressDialog(ProgressDialog progressDialog, String message) {
        if (progressDialog != null && !progressDialog.isShowing()) {
            progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
            progressDialog.setMessage(message);
            progressDialog.setCancelable(false);
            progressDialog.setIndeterminate(true);
            progressDialog.show();
        }

    }

    public static void showAlertDialog(String title, String message, Activity activity, Window window, boolean disableUserInteraction)
    {
        if (disableUserInteraction && window != null) {
            window.setFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE, WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);

        }

        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setMessage(message)
                .setPositiveButton(android.R.string.ok, null);
        AlertDialog dialog = builder.create();
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        dialog.show();

    }



    public static void hideProgressDialog(ProgressDialog progressDialog) {
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
    }


    public static void showProgressBar(ProgressBar progressBar, Window window, boolean disableUserInteraction) {
        if (progressBar != null && !progressBar.isShown()) {
            progressBar.setVisibility(View.VISIBLE);
            if (disableUserInteraction && window != null) {
                window.setFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE, WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);

            }
        }
    }

    public static void hideProgressBar(ProgressBar progressBar, Window window, boolean enableUserInteraction) {
        if (progressBar != null && progressBar.isShown()) {
            progressBar.setVisibility(View.INVISIBLE);
            if (enableUserInteraction && window != null) {

                window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE);
            }
        }
    }

    public static int getHeight(Activity window) {
        DisplayMetrics metrics = new DisplayMetrics();
        window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int height = metrics.heightPixels;
        return  height;
    }

    public static int getWidth(Activity window) {
        DisplayMetrics metrics = new DisplayMetrics();
        window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int width = metrics.widthPixels;
        return  width;
    }


    static public boolean isAccessCodeExpired()
    {


        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd:MMMM:yyyy HH:mm:ss a");
        String strDate = sdf.format(new Date());
        Log.i("MyTag", "Current date is " + strDate);

        Date validUntil = MySharedPref.getInstance().getAccessCodeExpDate();
        if(validUntil == null)
        {
            Log.i("MyTag", "No date set");
            return  true;
        }
        Log.i("MyTag", "Preferences date is " + validUntil);
        if(new Date().before(validUntil))
        {
            Log.i("MyTag", "Current date is " + strDate);
            return  false;
        }
        return true;
    }
}


