package my.ccs.projectrawdata.sqlite;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import java.util.LinkedList;
import java.util.List;

import my.ccs.projectrawdata.Constants;
import my.ccs.projectrawdata.model.RawData;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.opencsv.CSVWriter;

public class MySQLiteHelper extends SQLiteOpenHelper {

    // Database Version
    private static final int DATABASE_VERSION = 1;
    // Database Name
    public static final String DATABASE_NAME = "RawData";
    public static final String ExportCSVName = "RawDataCSV";
    private Context context = null;
    public MySQLiteHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);

        this.context = context;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        // SQL statement to create book table
        String CREATE_RAWDATA_TABLE = "CREATE TABLE RawData ( " +
                "id INTEGER PRIMARY KEY AUTOINCREMENT, " +
                "measuretype TEXT NOT NULL, "+
                "meterid TEXT NOT NULL, "+
                "metertype TEXT, "+
                "metermodel TEXT, "+
                "manufacturer TEXT, "+
                "rateschedule TEXT, "+
                "readtype TEXT, "+
                "office TEXT, "+
                "meteraddress TEXT, "+
                "read REAL NOT NULL, "+
                "factor REAL, "+
                "consumption REAL NOT NULL, "+
                "status TEXT, "+
                "updatetimestamp datetime )";


        // create books table
        db.execSQL(CREATE_RAWDATA_TABLE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // Drop older books table if existed
        db.execSQL("DROP TABLE IF EXISTS rawdata");

        // create fresh books table
        this.onCreate(db);
    }
    //---------------------------------------------------------------------

    /**
     * CRUD operations (create "add", read "get", update, delete) rawdata + get all rawdata + delete all rawdata
     */

    // Books table name
    private static final String TABLE_RAWDATA = "rawdata";

    // Books Table Columns names
    private static final String KEY_ID = "id";
    private static final String KEY_MEASURETYPE= "measuretype";
    private static final String KEY_METERID = "meterid";
    private static final String KEY_METERTYPE = "metertype";
    private static final String KEY_METERMODEL = "metermodel";
    private static final String KEY_MANUFACTURER = "manufacturer";
    private static final String KEY_RATESCHEDULE = "rateschedule";
    private static final String KEY_READTYPE = "readtype";
    private static final String KEY_OFFICE = "office";
    private static final String KEY_METERADDRESS = "meteraddress";
    private static final String KEY_READ = "read";
    private static final String KEY_FACTOR = "factor";
    private static final String KEY_CONSUMPTION = "consumption";
    private static final String KEY_STATUS = "status";
    private static final String KEY_UPDATETIMESTAMP = "updatetimestamp";

    private static final String[] COLUMNS = {KEY_ID,KEY_MEASURETYPE,KEY_METERID,KEY_METERTYPE,KEY_METERMODEL,KEY_MANUFACTURER,
            KEY_RATESCHEDULE,KEY_READTYPE,KEY_OFFICE,KEY_METERADDRESS,KEY_READ,KEY_FACTOR,KEY_CONSUMPTION,KEY_STATUS,
            KEY_UPDATETIMESTAMP};

    public void addRawData(RawData rawData){
        Log.d("addRawData", rawData.toString());
        // 1. get reference to writable DB
        SQLiteDatabase db = this.getWritableDatabase();

        // 2. create ContentValues to add key "column"/value
        ContentValues values = new ContentValues();
        values.put(KEY_MEASURETYPE, rawData.MeasureType);
        values.put(KEY_METERID, rawData.MeterID);
        values.put(KEY_METERTYPE, rawData.MeterType);
        values.put(KEY_METERMODEL, rawData.MeterModel);
        values.put(KEY_MANUFACTURER, rawData.Manufacturer);
        values.put(KEY_RATESCHEDULE, rawData.RateSchedule);
        values.put(KEY_READTYPE, rawData.ReadType);
        values.put(KEY_OFFICE, rawData.Office);
        values.put(KEY_METERADDRESS, rawData.MeterAddress);
        values.put(KEY_READ, rawData.Read);
        values.put(KEY_FACTOR, rawData.Factor);
        values.put(KEY_CONSUMPTION, rawData.Consumption);
        values.put(KEY_STATUS, rawData.Status);

        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        values.put(KEY_UPDATETIMESTAMP, format.format(rawData.UpdateTimeStamp));

        // 3. insert
        db.insert(TABLE_RAWDATA, // table
                null, //nullColumnHack
                values); // key/value -> keys = column names/ values = column values

        // 4. close
        db.close();
    }

    public RawData getRawData(int id){

        // 1. get reference to readable DB
        SQLiteDatabase db = this.getReadableDatabase();

        // 2. build query
        Cursor cursor =
                db.query(TABLE_RAWDATA, // a. table
                        COLUMNS, // b. column names
                        " id = ?", // c. selections
                        new String[] { String.valueOf(id) }, // d. selections args
                        null, // e. group by
                        null, // f. having
                        null, // g. order by
                        null); // h. limit

        // 3. if we got results get the first one
        if (cursor != null)
            cursor.moveToFirst();

        // 4. build book object
        RawData rawdata = new RawData();
        rawdata.id = Integer.parseInt(cursor.getString(0));
        rawdata.MeasureType = cursor.getString(1);
        rawdata.MeterID = cursor.getString(2);
        rawdata.MeterType = cursor.getString(3);
        rawdata.MeterModel = cursor.getString(4);
        rawdata.Manufacturer = cursor.getString(5);
        rawdata.RateSchedule = cursor.getString(6);
        rawdata.ReadType = cursor.getString(7);
        rawdata.Office = cursor.getString(8);
        rawdata.MeterAddress = cursor.getString(9);
        try {
            rawdata.Read = Double.parseDouble(cursor.getString(10));

        }
        catch (NumberFormatException ex)
        {
            //pass
        }
        catch (Exception ex)
        {
            //pass
        }

        try {
            rawdata.Factor = Double.parseDouble(cursor.getString(11));

        }
        catch (NumberFormatException ex)
        {
            //pass
        }
        catch (Exception ex)
        {
            //pass
        }

        try {
            rawdata.Consumption = Double.parseDouble(cursor.getString(12));

        }
        catch (NumberFormatException ex)
        {
            //pass
        }
        catch (Exception ex)
        {
            //pass
        }




        rawdata.Status = cursor.getString(13);
        try {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");


            rawdata.UpdateTimeStamp = format.parse(cursor.getString(14));

        }
        catch (NumberFormatException ex)
        {
            //pass
        }
        catch (Exception ex)
        {
            //pass
        }


        Log.d("getRawData(" + id + ")", rawdata.toString());

        // 5. return book
        return rawdata;
    }

    // Get All Books
    public List<RawData> getAllRawData() {
        List<RawData> rawdatas = new LinkedList<RawData>();

        // 1. build the query
        String query = "SELECT  * FROM " + TABLE_RAWDATA;

        // 2. get reference to writable DB
        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = db.rawQuery(query, null);

        // 3. go over each row, build book and add it to list
        RawData rawdata = null;
        if (cursor.moveToFirst()) {
            do {
                rawdata = new RawData();
                rawdata.id = Integer.parseInt(cursor.getString(0));
                rawdata.MeasureType = cursor.getString(1);
                rawdata.MeterID = cursor.getString(2);
                rawdata.MeterType = cursor.getString(3);
                rawdata.MeterModel = cursor.getString(4);
                rawdata.Manufacturer = cursor.getString(5);
                rawdata.RateSchedule = cursor.getString(6);
                rawdata.ReadType = cursor.getString(7);
                rawdata.Office = cursor.getString(8);
                rawdata.MeterAddress = cursor.getString(9);
                try {
                    rawdata.Read = Double.parseDouble(cursor.getString(10));

                }
                catch (NumberFormatException ex)
                {
                    //pass
                }
                catch (Exception ex)
                {
                    //pass
                }

                try {
                    rawdata.Factor = Double.parseDouble(cursor.getString(11));

                }
                catch (NumberFormatException ex)
                {
                    //pass
                }
                catch (Exception ex)
                {
                    //pass
                }

                try {
                    rawdata.Consumption = Double.parseDouble(cursor.getString(12));

                }
                catch (NumberFormatException ex)
                {
                    //pass
                }
                catch (Exception ex)
                {
                    //pass
                }




                rawdata.Status = cursor.getString(13);
                try {
                    SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");


                    rawdata.UpdateTimeStamp = format.parse(cursor.getString(14));

                }
                catch (NumberFormatException ex)
                {
                    //pass
                }
                catch (Exception ex)
                {
                    //pass
                }
                // Add book to books
                rawdatas.add(rawdata);
            } while (cursor.moveToNext());
        }

        Log.d("getAllRawData()", rawdatas.toString());

        // return books
        return rawdatas;
    }

    // Updating single book
    public int updateBook(RawData rawData) {

        // 1. get reference to writable DB
        SQLiteDatabase db = this.getWritableDatabase();

        // 2. create ContentValues to add key "column"/value
        ContentValues values = new ContentValues();
        values.put(KEY_MEASURETYPE, rawData.MeasureType);
        values.put(KEY_METERID, rawData.MeterID);
        values.put(KEY_METERTYPE, rawData.MeterType);
        values.put(KEY_METERMODEL, rawData.MeterModel);
        values.put(KEY_MANUFACTURER, rawData.Manufacturer);
        values.put(KEY_RATESCHEDULE, rawData.RateSchedule);
        values.put(KEY_READTYPE, rawData.ReadType);
        values.put(KEY_OFFICE, rawData.Office);
        values.put(KEY_METERADDRESS, rawData.MeterAddress);
        values.put(KEY_READ, rawData.Read);
        values.put(KEY_FACTOR, rawData.Factor);
        values.put(KEY_CONSUMPTION, rawData.Consumption);
        values.put(KEY_STATUS, rawData.Status);
        values.put(KEY_UPDATETIMESTAMP, rawData.UpdateTimeStamp.toString());

        // 3. updating row
        int i = db.update(TABLE_RAWDATA, //table
                values, // column/value
                KEY_ID+" = ?", // selections
                new String[] { String.valueOf(rawData.id) }); //selection args

        // 4. close
        db.close();

        return i;

    }

    // Deleting single book
    public void deleteRawData(RawData rawData) {

        // 1. get reference to writable DB
        SQLiteDatabase db = this.getWritableDatabase();

        // 2. delete
        db.delete(TABLE_RAWDATA,
                KEY_ID+" = ?",
                new String[] { String.valueOf(rawData.id) });

        // 3. close
        db.close();

        Log.d("deleteRawData", rawData.toString());

    }


    public void deleteAllRawData() {
        List<RawData> rawdatas = new LinkedList<RawData>();

        // 1. build the query
        String query = "Delete FROM " + TABLE_RAWDATA;

        // 2. get reference to writable DB
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL(query);

        db.close();


    }


    public void exportDB() throws Exception{

        if (this.context == null)
        {
            throw new Exception("Cannot export to csv");
        }
        File dbFile = context.getDatabasePath(DATABASE_NAME);
        Log.e("MyTag", "Abs path " + dbFile.getAbsolutePath());
        File exportDir = new File(dbFile.getParent());
        Log.e("MyTag", "Abs path export " + exportDir.getAbsolutePath());

        File file = new File(exportDir, ExportCSVName);
        try {
            file.createNewFile();
            CSVWriter csvWrite = new CSVWriter(new FileWriter(file));
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor curCSV = db.rawQuery("SELECT * FROM " + TABLE_RAWDATA, null);
            String[] allColumns = curCSV.getColumnNames();
            if(allColumns.length == 0)
            {
                throw new Exception("Columns list is empty.");

            }
            String[] firstColumnRemoved = new String[allColumns.length - 1];
            for(int i = 0; i < firstColumnRemoved.length; i++)
            {
                firstColumnRemoved[i] = allColumns[i + 1];
            }
            csvWrite.writeNext(firstColumnRemoved);
            while (curCSV.moveToNext()) {

                /*String arrStr[] = { removeDoubleQuotes(curCSV.getString(1)), removeDoubleQuotes(curCSV.getString(2)), removeDoubleQuotes(curCSV.getString(3)),
                        removeDoubleQuotes(curCSV.getString(4)), removeDoubleQuotes(curCSV.getString(5)), removeDoubleQuotes(curCSV.getString(6)),
                        removeDoubleQuotes(curCSV.getString(7)), removeDoubleQuotes(curCSV.getString(8)), removeDoubleQuotes(curCSV.getString(9)),
                        removeDoubleQuotes(curCSV.getString(10)), removeDoubleQuotes(curCSV.getString(11)), removeDoubleQuotes(curCSV.getString(12)),
                        removeDoubleQuotes(curCSV.getString(13)), removeDoubleQuotes(curCSV.getString(14))};*/

                //Which column you want to exprort
                String arrStr[] = {curCSV.getString(1), curCSV.getString(2), curCSV.getString(3),
                        curCSV.getString(4), curCSV.getString(5), curCSV.getString(6),
                        curCSV.getString(7), curCSV.getString(8), curCSV.getString(9),
                        curCSV.getString(10), curCSV.getString(11), curCSV.getString(12),
                        curCSV.getString(13),curCSV.getString(14)};
                csvWrite.writeNext(arrStr);
            }
            csvWrite.close();
            curCSV.close();
        } catch (Exception sqlEx) {
            Log.e("MainActivity", sqlEx.getMessage(), sqlEx);
        }
    }


    public String removeDoubleQuotes(String str)
    {
        if(str.startsWith("\""))
            str = str.substring(1);

        if(str.endsWith("\""))
            str = str.substring(0, str.length() - 1);

        return  str;

    }
}
