package my.ccs.project;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.location.LocationListener;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;


import com.sensoro.beacon.kit.Beacon;
import com.sensoro.beacon.kit.BeaconManagerListener;
import com.sensoro.cloud.SensoroManager;

import java.util.ArrayList;
import java.util.HashMap;
import android.graphics.Bitmap;

import java.io.*;
import java.util.*;
import android.util.Xml;


//////////alipay
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Random;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.alipay.sdk.app.PayTask;

import com.tencent.mm.sdk.modelpay.PayReq;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.WXAPIFactory;

import my.ccs.project.wechatsdk.ConstantsWeChat;
import my.ccs.project.alipaysdk.ConstantsAliPay;
import my.ccs.project.wechatsdk.MD5;
import my.ccs.project.wechatsdk.Util;

import android.app.ProgressDialog;
import android.os.AsyncTask;


import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.xmlpull.v1.XmlPullParser;

import my.ccs.project.alipaysdk.PayResult;
import my.ccs.project.alipaysdk.SignUtils;

import android.app.AlertDialog.Builder;
import android.content.DialogInterface.OnClickListener;

public class MainActivity extends Activity implements LocationListener  {

    WebView webView;

    PayReq req;
    final IWXAPI msgApi = WXAPIFactory.createWXAPI(this, ConstantsWeChat.APP_ID, true);

    final Handler jsHandler = new Handler();
    StringBuffer sb;
    Map<String,String> resultunifiedorder;
    String WeChatPayAmount = "1";
    String WeChatOutTradeNo;

    private LocationManager locationManager;
    private String provider;
    private String lat = null;
    private String lng = null;
    private String showType = null;

    ProgressBar progressBar;

    private ValueCallback<Uri> mUploadMessage;
    private final static int FILECHOOSER_RESULTCODE=1;

    /*
     * Beacon Manager lister,use it to listen the appearence, disappearence and
     * updating of the beacons.
     */
    BeaconManagerListener beaconManagerListener;
    MyApp app;
    BluetoothManager bluetoothManager;
    BluetoothAdapter bluetoothAdapter;
    /*
     * Sensoro Manager
     */
    SensoroManager sensoroManager;

    private void initCtrl() {
        /*app = (MyApp) getApplication();
        sensoroManager = app.sensoroManager;
        */
        sensoroManager = SensoroManager.getInstance(getApplicationContext());
    }
    /*
	 * Start sensoro service.
	 */
    private void startSensoroService() {


        if(sensoroManager != null) {
            sensoroManager = SensoroManager.getInstance(getApplicationContext());
        }
        if(sensoroManager != null)
        {
            sensoroManager.setBeaconManagerListener(beaconManagerListener);
            try {
                sensoroManager.setCloudServiceEnable(true);
                sensoroManager.startService();
                runOnUiThread(new Runnable() {
                    public void run() {

                        Toast.makeText(MainActivity.this, "Sensoro detection started ", Toast.LENGTH_LONG).show();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }



    }

    private void stopSensoroService() {

        if(sensoroManager != null) {
            try {
                sensoroManager.setCloudServiceEnable(false);
                sensoroManager.stopService();

            } catch (Exception e) {
                e.printStackTrace();
            }
        }


    }

    private void requestBlueEnable() {
        bluetoothManager = (BluetoothManager) getSystemService(BLUETOOTH_SERVICE);
        if(bluetoothManager != null) {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN_MR2) {
                bluetoothAdapter = bluetoothManager.getAdapter();
            } else {
                bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            }
            if(bluetoothAdapter != null) {
                boolean status = bluetoothAdapter.isEnabled();
                if (!status) {
                    Builder builder = new Builder(MainActivity.this);
                    builder.setNegativeButton("Yes", new OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                            startActivity(intent);
                        }
                    }).setPositiveButton("No", new OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).setTitle("Turn on the bluetooth to be able to detect sensoros.");
                    if(builder != null) builder.show();
                }
            }
        }

    }

    private boolean isBlueEnable() {
        bluetoothManager = (BluetoothManager) getSystemService(BLUETOOTH_SERVICE);
        if(bluetoothManager != null) {
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN_MR2) {
                bluetoothAdapter = bluetoothManager.getAdapter();
            } else {
                bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            }

            boolean status = bluetoothAdapter.isEnabled();
            if (!status) {

                runOnUiThread(new Runnable() {
                    public void run() {
                        Builder builder = new Builder(MainActivity.this);
                        builder.setNegativeButton("Yes", new OnClickListener() {

                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                Intent intent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                                startActivity(intent);
                            }
                        }).setPositiveButton("No", new OnClickListener() {

                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        }).setTitle("Turn on the bluetooth to be able to detect sensoros.");
                        builder.show();
                    }
                });

            }
            return status;
        }
        return  false;

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode,
                                    Intent intent) {
        if(requestCode==FILECHOOSER_RESULTCODE)
        {
            if (null == mUploadMessage) return;
            Uri result = intent == null || resultCode != RESULT_OK ? null
                    : intent.getData();
            mUploadMessage.onReceiveValue(result);
            mUploadMessage = null;
        }
    }
    /*
    final String CCSNotifyURL = "http://cloudcomspace.cloudapp.net/Payments/PaymentNotifyAction";
    //ALIPAY START
    // 商户PID
    public static final String PARTNER = "2088021474273374";
    // 商户收款账号
    public static final String SELLER = "cloudcomspace@hotmail.com";
    // 商户私钥，pkcs8格式
    public static final String RSA_PRIVATE = "MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAOVAqfkPbLKLbBRH\n" +
            "UIlmFqTWj2i4MYVH79p06YnuoxmySQZogmVvozWqh8CKhyYLWbe6Rvk479Cnoa4t\n" +
            "YihNB9kYI0ajU3Ji2HYDcMQE3Iuj3LRVs43/JkzDRCtm+CMKpv8YvsuF2GPzVWnh\n" +
            "1MqYlBI+5HARmDqsaZXoA1gZUDBDAgMBAAECgYBRafdy9aFaftzxDqpxQQoFnBTt\n" +
            "0Yv0kymA4UgWreLKO2BnoDG+qDjD1D3FiOyZ/Cnub37I/wlbhkyKuJ9FRKXmLOsa\n" +
            "K4npbk0+SxBSMHf4p6JDPISbcfQCodL6BFzXPl6S6fPA+3C2hqw07fUOl2O2WL1V\n" +
            "vZAjUeWeIQKbp05p8QJBAPd3scGKJUJpfOquFfiMSHEz5cVlEkVl1RfF4dtcVzOp\n" +
            "IvFGbYClednAUV/9Pz7svS/MG67HNdQzITMHYwEr5MUCQQDtKDFaNPPlsHT39Bju\n" +
            "ezxcUKXsX44Fvd17biRUpWn/cw4yFpgmZf77ybiid2Gt+MCxsQ/fMvKmtII6tPAf\n" +
            "nuFnAkEA000Rq5cgn2dhMSV6PyLRTE+q9vSJOFZuMIFXi616C/N0kZ24LGue8q5D\n" +
            "DXo4war1E1XtoTwaG1mZFHBPOhXXnQJBAMbiyyi8ecIpjp6W3gW54fAFTnEB3cgg\n" +
            "50ppHxzBsDgjlEcbPbQOG52rGSVe+tL8ZxVdyVLElkyJ2yFCtpG+G4cCQQDa+yIj\n" +
            "FZiEB8hymZlRn0Cv3N9g2EcliKiAu/MP61gGYz0wbM5fTcCUlu78jMz1NW4Ndejh\n" +
            "yTHoQEiyqfxiBwh4";
    // 支付宝公钥
    public static final String RSA_PUBLIC = "";
    private static final int SDK_PAY_FLAG = 1;
    private static final int SDK_CHECK_FLAG = 2;
    */
    protected void chekcLocationServices()
    {
        boolean gps_enabled = false;
        boolean network_enabled = false;
        if(locationManager != null) {
            try {
                gps_enabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
            } catch (Exception ex) {
            }

            try {
                network_enabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            } catch (Exception ex) {
            }
        }

        if(!gps_enabled && !network_enabled) {
            // notify user
            AlertDialog.Builder dialog = new AlertDialog.Builder(this);
            //dialog.setMessage(this.getResources().getString(R.string.gps_network_not_enabled));
            dialog.setMessage("GPS not enabled");
            dialog.setPositiveButton("Open location settings", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub
                    Intent myIntent = new Intent( Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                    startActivity(myIntent);
                    //get gps
                }
            });
            dialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                    // TODO Auto-generated method stub

                }
            });
            dialog.show();
        }
    }

    protected  void initLocationManager() {
        // Get the location manager
        locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
        // Define the criteria how to select the locatioin provider -> use
        // default
        chekcLocationServices();

        Criteria criteria = new Criteria();
        provider = locationManager.getBestProvider(criteria, false);
        Location location = locationManager.getLastKnownLocation(provider);

        // Initialize the location fields
        if (location != null) {
            //Toast.makeText(this, provider + " has been selected",
            //        Toast.LENGTH_SHORT).show();
            onLocationChanged(location);
        } else {

            //Toast.makeText(this, "location not enabled",
            //        Toast.LENGTH_SHORT).show();
            if(locationManager != null)
                locationManager.requestLocationUpdates(provider, 400, 1, this);

        }
    }

    /* Request updates at startup */
    @Override
    protected void onResume() {

        if(locationManager != null) locationManager.requestLocationUpdates(provider, 400, 1, this);
        super.onResume();
    }

    /* Remove the locationlistener updates when Activity is paused */
    @Override
    protected void onPause() {
        super.onPause();
        if(locationManager != null)
            locationManager.removeUpdates(this);
    }

    @Override
    public void onLocationChanged(Location location) {

        lat = String.valueOf(location.getLatitude());
        lng = String.valueOf(location.getLongitude());


    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onProviderEnabled(String provider) {
        //Toast.makeText(this, "Enabled new provider " + provider,
        //        Toast.LENGTH_SHORT).show();

    }

    @Override
    public void onProviderDisabled(String provider) {
        //Toast.makeText(this, "Disabled provider " + provider,
        //        Toast.LENGTH_SHORT).show();
    }

    protected void initWebView()
    {
        webView = (WebView) findViewById(R.id.CCSWebView);
        if(webView != null) {
            WebSettings webSettings = webView.getSettings();
            webSettings.setBuiltInZoomControls(true);
            webSettings.setJavaScriptEnabled(true);
            webSettings.setGeolocationEnabled(true);
            webSettings.setAppCacheEnabled(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setDomStorageEnabled(true);

            webView.getSettings().setUserAgentString(
                    this.webView.getSettings().getUserAgentString()
                            + " "
                            + Constants.userAgentString
            );
            //webView.setWebChromeClient(new WebChromeClient());
            webView.setWebChromeClient(new WebChromeClient() {
                //The undocumented magic method override
                //Eclipse will swear at you if you try to put @Override here
                // For Android 3.0+
                public void openFileChooser(ValueCallback<Uri> uploadMsg) {

                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    MainActivity.this.startActivityForResult(Intent.createChooser(i, "File Chooser"), FILECHOOSER_RESULTCODE);

                }

                // For Android 3.0+
                public void openFileChooser(ValueCallback uploadMsg, String acceptType) {
                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    MainActivity.this.startActivityForResult(
                            Intent.createChooser(i, "File Browser"),
                            FILECHOOSER_RESULTCODE);
                }

                //For Android 4.1
                public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
                    mUploadMessage = uploadMsg;
                    Intent i = new Intent(Intent.ACTION_GET_CONTENT);
                    i.addCategory(Intent.CATEGORY_OPENABLE);
                    i.setType("*/*");
                    MainActivity.this.startActivityForResult(Intent.createChooser(i, "File Chooser"), MainActivity.FILECHOOSER_RESULTCODE);

                }

                public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                    callback.invoke(origin, true, false);
                }


            });


            webView.setWebViewClient(new Callback());
            final JavaScriptInterface myJavaScriptInterface
                    = new JavaScriptInterface(this);
            webView.addJavascriptInterface(myJavaScriptInterface, Constants.JavascriptInterfaceName);
        }
    }



    //flipscreen not loading again
    @Override
    public void onConfigurationChanged(Configuration newConfig){
        super.onConfigurationChanged(newConfig);
    }


    private void initSensoroListener() {
       beaconManagerListener = new BeaconManagerListener() {


                        @Override
                        public void onUpdateBeacon(ArrayList<Beacon> beacons) {
                            // Refresh sensor info

                            Message msg = Message.obtain(); // Creates an new Message instance
                            if(msg != null) {
                                msg.what = 1;
                                msg.obj = beacons; // Put the string into Message, into "obj" field.
                                if(sensoroHandler != null) {
                                    msg.setTarget(sensoroHandler);
                                    msg.sendToTarget();
                                }
                            }
                        }

                        @Override
                        public void onNewBeacon(Beacon beacon) {
                            // New sensor found

                            Message msg = Message.obtain(); // Creates an new Message instance
                            if(msg != null) {
                                msg.what = 2;
                                msg.obj = beacon; // Put the string into Message, into "obj" field.
                                if(sensoroHandler != null) {
                                    msg.setTarget(sensoroHandler);
                                    msg.sendToTarget();
                                }
                            }
                        }

                        @Override
                        public void onGoneBeacon(Beacon beacon) {
                            // A sensor disappears from the range

                            Message msg = Message.obtain(); // Creates an new Message instance
                            if(msg != null) {
                                msg.what = 3;
                                msg.obj = beacon; // Put the string into Message, into "obj" field.
                                if(sensoroHandler != null) {
                                    msg.setTarget(sensoroHandler);
                                    msg.sendToTarget();
                                }

                            }

                        }
                    };
        //sensoroManager.setBeaconManagerListener(beaconManagerListener);

    }



    @Override
    protected void onCreate(Bundle savedInstanceState) {

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        progressBar = (ProgressBar) findViewById(R.id.progressBar1);

        /*
        * Settings.Secure.ANDROID_ID returns the unique DeviceID
        * Works for Android 2.2 and above
        */
        String androidId = Settings.Secure.getString(getContentResolver(),
                Settings.Secure.ANDROID_ID);



        Toast.makeText(MainActivity.this, "AndroidID : " + androidId + "\n", Toast.LENGTH_LONG).show();
        /*Button clickButton = (Button) findViewById(R.id.button11);
        clickButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view looks good",
                        Toast.LENGTH_SHORT).show();

            }
        });

        Button clickButton2 = (Button) findViewById(R.id.button12);
        clickButton2.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view and load url looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);


            }
        });

        Button clickButton3 = (Button) findViewById(R.id.button13);
        clickButton3.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();

            }
        });

        Button clickButton4 = (Button) findViewById(R.id.button14);
        clickButton4.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager, initctl looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();
                initCtrl();

            }
        });

        Button clickButton5 = (Button) findViewById(R.id.button15);
        clickButton5.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager, initCtl, initSensoro looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();
                initCtrl();
                initSensoroListener();
            }
        });

        Button clickButton6 = (Button) findViewById(R.id.button16);
        clickButton6.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager, initctl, initSensoro, initPayReq looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();
                initCtrl();
                initSensoroListener();
                req = new PayReq();
                sb=new StringBuffer();
                msgApi.registerApp(ConstantsWeChat.APP_ID);


            }
        });


        Button clickButton7 = (Button) findViewById(R.id.button17);
        clickButton7.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager, initctl, initSensoro, initPayReq, thread1 looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();
                initCtrl();
                initSensoroListener();
                req = new PayReq();
                sb=new StringBuffer();
                msgApi.registerApp(ConstantsWeChat.APP_ID);

                new Thread(new Runnable() {

                    @Override
                    public void run() {
                        requestBlueEnable();
                        while(true)
                        {
                            try {

                                startSensoroService();

                                Thread.sleep(30000);

                                stopSensoroService();

                                Thread.sleep(5000);
                            }
                            catch(Exception e)
                            {

                            }
                        }
                        // Do the processing.
                    }
                }).start();

            }
        });

        Button clickButton8 = (Button) findViewById(R.id.button18);
        clickButton8.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                initWebView();
                Toast.makeText(MainActivity.this, "Init web view, load url, init location manager, initctl, initSensoro, initPayReq, thread2 looks good",
                        Toast.LENGTH_SHORT).show();

                initWebView();
                webView.loadUrl(Constants.loadUrl);
                initLocationManager();
                initCtrl();
                initSensoroListener();
                req = new PayReq();
                sb=new StringBuffer();
                msgApi.registerApp(ConstantsWeChat.APP_ID);

                new Thread(new Runnable() {

                    @Override
                    public void run() {
                        while(true)
                        {
                            try {
                                runOnUiThread(new Runnable() {
                                    public void run() {

                                        //Toast.makeText(MainActivity.this, "Check removal.", Toast.LENGTH_LONG).show();
                                    }
                                });

                                for (BeaconExt beacon : serialNumberToBeacon.values()) {

                                    if (beacon.checkRemove()) {
                                        serialNumberToBeacon.remove(beacon.b.getSerialNumber());
                                        runOnUiThread(new Runnable() {
                                            public void run() {

                                                Toast.makeText(MainActivity.this, "Removed",
                                                        Toast.LENGTH_SHORT).show();
                                            }
                                        });

                                    }

                                }

                                Thread.sleep(10000);
                            }
                            catch(Exception e)
                            {

                            }
                        }

                    }
                }).start();
            }
        });*/

        initWebView();
        webView.loadUrl(Constants.loadUrl);
        initLocationManager();
        initCtrl();
        initSensoroListener();

        req = new PayReq();
        sb=new StringBuffer();
        if(msgApi != null) msgApi.registerApp(ConstantsWeChat.APP_ID);
        requestBlueEnable();

        new Thread(new Runnable() {

            @Override
            public void run() {

                while(true)
                {
                    try {
                        startSensoroService();

                        Thread.sleep(5000);

                        stopSensoroService();

                        Thread.sleep(10000);
                    }
                    catch(Exception e)
                    {

                    }
                }
                // Do the processing.
            }
        }).start();

        new Thread(new Runnable() {

            @Override
            public void run() {
                while(true)
                {
                    try {
                        //runOnUiThread(new Runnable() {
                        //    public void run() {

                        //        Toast.makeText(MainActivity.this, "Check removal.", Toast.LENGTH_LONG).show();
                        //    }
                        //});
                        if(serialNumberToBeacon != null) {
                            Collection<BeaconExt> beaconList = serialNumberToBeacon.values();
                            if (beaconList != null) {
                                for (BeaconExt beacon : serialNumberToBeacon.values()) {

                                    if (beacon.checkRemove()) {
                                        serialNumberToBeacon.remove(beacon.b.getSerialNumber());
                                        runOnUiThread(new Runnable() {
                                            public void run() {

                                                Toast.makeText(MainActivity.this, "Removed",
                                                        Toast.LENGTH_SHORT).show();
                                            }
                                        });

                                    }

                                }
                            }

                        }
                        Thread.sleep(10000);

                    }
                    catch(Exception e)
                    {

                    }
                }

            }
        }).start();



    }



    /*
    class SensoroStopTimerTask extends TimerTask {

        @Override
        public void run() {
            //Toast.makeText(MainActivity.this, "Schedule task to stop triggered.",
            //        Toast.LENGTH_SHORT).show();
            stopSensoroService();
        }

    }*/


    /*
    public void scheduleSensoroStopTimer()
    {
        if(sensoroStopTimer != null){
            sensoroStopTimer.cancel();
        }

        Toast.makeText(MainActivity.this, "Schedule task to stop.",
                Toast.LENGTH_SHORT).show();
        sensoroStopTimer = new Timer();
        SensoroStopTimerTask sensoroStopTimerTask= new SensoroStopTimerTask();
        sensoroStopTimer.schedule(sensoroStopTimerTask, 30000);
    }*/

    private Handler aliPayResponseHandler = new Handler() {
        public void handleMessage(Message msg) {
            if(msg != null) {
                switch (msg.what) {
                    case ConstantsAliPay.SDK_PAY_FLAG: {

                        String msgStr = (String) msg.obj;
                        //JS method somehow has issues with backslashes so we just remove them
                        msgStr = msgStr == null ? "" : msgStr.replaceAll("\"", "");

                        int sepIndex = msgStr.lastIndexOf(";");
                        String orderInfo = msgStr.substring(0, sepIndex);
                        String paymentIdStr = msgStr.substring(sepIndex + 1);

                        PayResult payResult = new PayResult(orderInfo);

                        // 支付宝返回此次支付结果及加签，建议对支付宝签名信息拿签约时支付宝提供的公钥做验签
                        String resultInfo = payResult.getResult();
                        String resultStatus = payResult.getResultStatus();
                        if(resultInfo == null) resultInfo = "";
                        if(resultStatus == null) resultStatus ="";
                        String responseToServer = paymentIdStr + "&" + resultInfo.replaceAll("\"", "");

                        // 判断resultStatus 为“9000”则代表支付成功，具体状态码代表含义可参考接口文档
                        if (TextUtils.equals(resultStatus, "9000")) {
                            Toast.makeText(MainActivity.this, "The payment was processed. Thanks.",
                                    Toast.LENGTH_SHORT).show();
                            //webView.loadUrl("javascript:HandlePaymentResult(\"" + responseToServer + "\");");

                        } else {
                            // 判断resultStatus 为非“9000”则代表可能支付失败
                            // “8000”代表支付结果因为支付渠道原因或者系统原因还在等待支付结果确认，最终交易是否成功以服务端异步通知为准（小概率状态）
                            if (TextUtils.equals(resultStatus, "8000")) {
                                Toast.makeText(MainActivity.this, "支付结果确认中",
                                        Toast.LENGTH_SHORT).show();

                            } else {
                                // 其他值就可以判断为支付失败，包括用户主动取消支付，或者系统返回的错误
                                Toast.makeText(MainActivity.this, "支付失败",
                                        Toast.LENGTH_SHORT).show();

                            }
                        }
                        break;
                    }
                /*case ConstantsAliPay.SDK_CHECK_FLAG: {
                    Toast.makeText(MainActivity.this, "检查结果为：" + msg.obj,
                            Toast.LENGTH_SHORT).show();
                    break;
                }*/
                    default:
                        break;
                }
            }
        };
    };


    //Main function to be called for aliPay payment processing
    /**
     * call alipay sdk pay. 调用SDK支付
     *
     */
    public void payBillAliPay(final String paymentId, String amount, String _outTradeNo) {
        if (TextUtils.isEmpty(ConstantsAliPay.PARTNER) || TextUtils.isEmpty(ConstantsAliPay.RSA_PRIVATE)
                || TextUtils.isEmpty(ConstantsAliPay.SELLER)) {
            new AlertDialog.Builder(this)
                    .setTitle("警告")
                    .setMessage("需要配置PARTNER | RSA_PRIVATE| SELLER")
                    .setPositiveButton("确定",
                            new DialogInterface.OnClickListener() {
                                public void onClick(
                                        DialogInterface dialoginterface, int i) {
                                    //
                                    finish();
                                }
                            }).show();
            return;
        }
        String outTradeNo = _outTradeNo;//getOutTradeNo();
        // 订单
        String orderInfo = getOrderInfo("测试的商品", "该测试商品的详细描述", "0.01", outTradeNo);

        // 对订单做RSA 签名
        String sign = sign(orderInfo);
        try {
            // 仅需对sign 做URL编码
            sign = URLEncoder.encode(sign, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        // 完整的符合支付宝参数规范的订单信息
        final String payInfo = orderInfo + "&sign=\"" + sign + "\"&"
                + getSignType();

        Runnable payRunnable = new Runnable() {

            @Override
            public void run() {
                // 构造PayTask 对象
                PayTask alipay = new PayTask(MainActivity.this);
                // 调用支付接口，获取支付结果
                String result = alipay.pay(payInfo);

                Message msg = new Message();
                if(msg != null) {
                    msg.what = ConstantsAliPay.SDK_PAY_FLAG;
                    msg.obj = result + ";paymentId=" + "\"" + paymentId + "\"";
                    if(aliPayResponseHandler != null) {
                        aliPayResponseHandler.sendMessage(msg);
                    }
                }
            }
        };

        // 必须异步调用
        Thread payThread = new Thread(payRunnable);
        payThread.start();
    }



    /**
     * check whether the device has authentication alipay account.
     * 查询终端设备是否存在支付宝认证账户
     *
     */
    /*public void check(View v) {
        Runnable checkRunnable = new Runnable() {

            @Override
            public void run() {
                // 构造PayTask 对象
                PayTask payTask = new PayTask(MainActivity.this);
                // 调用查询接口，获取查询结果
                boolean isExist = payTask.checkAccountIfExist();

                Message msg = new Message();
                msg.what = ConstantsAliPay.SDK_CHECK_FLAG;
                msg.obj = isExist;
                aliPayResponseHandler.sendMessage(msg);
            }
        };

        Thread checkThread = new Thread(checkRunnable);
        checkThread.start();

    }*/

    /**
     * get the sdk version. 获取SDK版本号
     *
     */
    /*public void getSDKVersion() {
        PayTask payTask = new PayTask(this);
        String version = payTask.getVersion();
        Toast.makeText(this, version, Toast.LENGTH_SHORT).show();
    }*/

    /**
     * create the order info. 创建订单信息
     *
     */
    public String getOrderInfo(String subject, String body, String price, String outTradeNo) {

        // 签约合作者身份ID
        String orderInfo = "partner=" + "\"" + ConstantsAliPay.PARTNER + "\"";

        // 签约卖家支付宝账号
        orderInfo += "&seller_id=" + "\"" + ConstantsAliPay.SELLER + "\"";

        // 商户网站唯一订单号
        orderInfo += "&out_trade_no=" + "\"" + outTradeNo+ "\"";

        // 商品名称
        orderInfo += "&subject=" + "\"" + subject + "\"";

        // 商品详情
        orderInfo += "&body=" + "\"" + body + "\"";

        // 商品金额
        orderInfo += "&total_fee=" + "\"" + price + "\"";

        // 服务器异步通知页面路径
        orderInfo += "&notify_url=" + "\"" + ConstantsAliPay.CCSNotifyURL
                + "\"";

        // 服务接口名称， 固定值
        orderInfo += "&service=\"mobile.securitypay.pay\"";

        // 支付类型， 固定值
        orderInfo += "&payment_type=\"1\"";

        // 参数编码， 固定值
        orderInfo += "&_input_charset=\"utf-8\"";

        // 设置未付款交易的超时时间
        // 默认30分钟，一旦超时，该笔交易就会自动被关闭。
        // 取值范围：1m～15d。
        // m-分钟，h-小时，d-天，1c-当天（无论交易何时创建，都在0点关闭）。
        // 该参数数值不接受小数点，如1.5h，可转换为90m。
        orderInfo += "&it_b_pay=\"30m\"";

        // extern_token为经过快登授权获取到的alipay_open_id,带上此参数用户将使用授权的账户进行支付
        // orderInfo += "&extern_token=" + "\"" + extern_token + "\"";

        // 支付宝处理完请求后，当前页面跳转到商户指定页面的路径，可空
        orderInfo += "&return_url=\"m.alipay.com\"";

        // 调用银行卡支付，需配置此参数，参与签名， 固定值 （需要签约《无线银行卡快捷支付》才能使用）
        // orderInfo += "&paymethod=\"expressGateway\"";

        return orderInfo;
    }

    /**
     * get the out_trade_no for an order. 生成商户订单号，该值在商户端应保持唯一（可自定义格式规范）
     *
     */
    /*public String getOutTradeNo() {
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss",
                Locale.getDefault());
        Date date = new Date();
        String key = format.format(date);

        Random r = new Random();
        key = key + r.nextInt();
        key = key.substring(0, 15);
        return key;
    }*/

    /**
     * sign the order info. 对订单信息进行签名
     *
     * @param content
     *            待签名订单信息
     */
    public String sign(String content) {
        return SignUtils.sign(content, ConstantsAliPay.RSA_PRIVATE);
    }

    /**
     * get the sign type we use. 获取签名方式
     *
     */
    public String getSignType() {
        return "sign_type=\"RSA\"";
    }

    //ALIPAY END

    //Sensoro Start
    public static int removeInterval = 90000;
    class BeaconExt
    {

        Beacon b;
        boolean isMarkedToRemove;
        Date markedToRemoveDate;
        public BeaconExt(Beacon b, boolean isMarkedToRemove, Date markedToRemoveDate) {
            this.b = b;
            this.isMarkedToRemove = isMarkedToRemove;
            this.markedToRemoveDate = markedToRemoveDate;
        }

        public boolean checkRemove()
        {
            if(isMarkedToRemove && (Calendar.getInstance().getTime().getTime() - this.markedToRemoveDate.getTime() > removeInterval))
            {
                runOnUiThread(new Runnable() {
                    public void run() {
                        Toast.makeText(MainActivity.this, "Removed " + isMarkedToRemove + " " + Calendar.getInstance().getTime() + " " + markedToRemoveDate,
                                Toast.LENGTH_SHORT).show();
                    }
                });



                return true;
            }

            runOnUiThread(new Runnable() {
                public void run() {
                    Toast.makeText(MainActivity.this, "Cant remove yet " + isMarkedToRemove + " " + Calendar.getInstance().getTime() + " " + markedToRemoveDate,
                            Toast.LENGTH_SHORT).show();
                }
            });



            return  false;
        }

    }
    HashMap<String, BeaconExt> serialNumberToBeacon = new HashMap<String, BeaconExt>();
    LinkedList<BeaconExt> orderedList = new LinkedList<BeaconExt>();
    static Object lockObj = new Object();

    Timer sensoroStopTimer = new Timer();


    private final Handler sensoroHandler = new Handler(){
        @Override
        public void handleMessage(Message msg) {
            if (msg != null) {
                switch (msg.what) {
                    case 1:   //update sensoros
                    {

                        try
                        {

                            ArrayList<Beacon> listOfBeacons = (ArrayList<Beacon>) msg.obj;
                            if(serialNumberToBeacon != null) {
                                for (Beacon beacon : listOfBeacons) {
                                    if (beacon != null && !serialNumberToBeacon.containsKey(beacon.getSerialNumber())) {
                                        serialNumberToBeacon.put(beacon.getSerialNumber(), new BeaconExt(beacon, false, Calendar.getInstance().getTime()));
                                    } else {
                                        BeaconExt b = serialNumberToBeacon.get(beacon.getSerialNumber());
                                        if (b != null) {
                                            b.isMarkedToRemove = false;
                                            b.markedToRemoveDate = Calendar.getInstance().getTime();
                                        }
                                    }

                                }
                            }
                        }

                        catch (Exception e)
                        {

                        }
                        break;
                    }
                    case 2: //new sensoro found
                    {
                        try {

                            Beacon beacon = (Beacon) msg.obj;
                            String sn = beacon.getSerialNumber();

                            Toast.makeText(MainActivity.this, "Found a sensoro" + serialNumberToBeacon.containsKey(sn),
                                    Toast.LENGTH_SHORT).show();
                            if (!serialNumberToBeacon.containsKey(sn)) {
                                serialNumberToBeacon.put(sn, new BeaconExt(beacon, false, Calendar.getInstance().getTime()));
                            } else {
                                BeaconExt b = serialNumberToBeacon.get(beacon.getSerialNumber());

                                b.isMarkedToRemove = false;
                                b.markedToRemoveDate = Calendar.getInstance().getTime();

                            }
                        }

                        catch (Exception e)
                        {

                        }

                        //synchronized (lockObj) {
                        //don't use this webView.loadUrl("javascript:HandleSensoroList(\"" + lat + "\",\"" + lng + "\",\"" + str + "\",\"" + showType + "\");");
                        //webView.loadUrl("javascript:HandleSensoroList(\"" + str + "\");");
                        //}

                        break;
                    }
                    case 3: //some sensoro gone out of range
                    {
                        Toast.makeText(MainActivity.this, "Want to remove",
                                Toast.LENGTH_SHORT).show();
                        Beacon beacon = (Beacon) msg.obj;
                        try{
                            String sn = beacon.getSerialNumber();
                            if (serialNumberToBeacon.containsKey(sn)) {

                                BeaconExt b = serialNumberToBeacon.get(sn);
                                b.isMarkedToRemove = true;
                                b.markedToRemoveDate = Calendar.getInstance().getTime();
                            }


                        }
                        catch (Exception e)
                        {

                        }
                        //sensoroSnList.setText(globalStr);
                        //synchronized (lockObj) {
                        //webView.loadUrl("javascript:HandleSensoroList(\"" + str + "\");");
                        //}
                        break;
                    }
                }
            }
        }
    };


    private class Callback extends WebViewClient {

        boolean errorDetected = false;

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if(progressBar != null) {
                progressBar.setVisibility(View.VISIBLE);

            }
            errorDetected = false;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {

            return (false);
        }

        //This is called when page is finished loading
        @Override
        public void onPageFinished(WebView view, String url)
        {
            //Toast.makeText(MainActivity.this, url, Toast.LENGTH_LONG).show();
            if(progressBar != null) {
                progressBar.setVisibility(View.GONE);
            }

            if(errorDetected)
            {
                //do something
            } else {

                if(url != null && url.contains(Constants.ShowMapUrl + "?ShowType=list")) {
                    //Toast.makeText(MainActivity.this, "ShowMapurl", Toast.LENGTH_LONG).show();

                    //Toast.makeText(MainActivity.this, "location " + lat + " " + lng,
                     //       Toast.LENGTH_SHORT).show();
                    String str = "";

                    orderedList = new LinkedList<BeaconExt>();
                    if(serialNumberToBeacon != null) {
                        for (String key : serialNumberToBeacon.keySet()) {
                            int index = 0;
                            BeaconExt value = (BeaconExt) serialNumberToBeacon.get(key);
                            if (value != null) {
                                for (int i = 0; i < orderedList.size(); i++) {

                                    BeaconExt value2 = orderedList.get(i);
                                    if (value.b.getAccuracy() < value2.b.getAccuracy())
                                        break;
                                    index++;
                                }

                            }
                            //Toast.makeText(MainActivity.this, "Recreate ord list" + orderedList.size(),
                            //        Toast.LENGTH_SHORT).show();
                            orderedList.add(index, value);

                        }
                    }
                    try {
                        for (int i = 0; i < orderedList.size(); i++) {
                            str += orderedList.get(i).b.getSerialNumber() + ",";
                        }
                    /*if(serialNumberToBeacon != null) {
                        Toast.makeText(MainActivity.this, "size of serial numbers " + serialNumberToBeacon.size(),
                                Toast.LENGTH_SHORT).show();
                    }
                    if(orderedList != null) {
                        Toast.makeText(MainActivity.this, "size of ordered numbers " + orderedList.size(),
                                Toast.LENGTH_SHORT).show();
                    }*/
                    }
                    catch (Exception e)
                    {

                    }

                    if(str!=null) {
                        str = str.replaceAll(",$", "");
                        Toast.makeText(MainActivity.this, "list of sensoros " + str,
                                Toast.LENGTH_SHORT).show();
                    }
                    else
                    {
                        Toast.makeText(MainActivity.this, "list of sensoros is null",
                                Toast.LENGTH_SHORT).show();
                    }
                    Toast.makeText(MainActivity.this, "lat long " + lat + " " + lng + "",
                            Toast.LENGTH_SHORT).show();
                    /*synchronized (lockObj) {
                        webView.loadUrl("javascript:HandleRequestFromMobile(" + lat + "," + lng + ",\"" + str + "\");");
                        //webView.loadUrl("javascript:HandleLocation(" + lat + "," + lng + ",\"" + "str" + "\",\"" + "ShowType" + "\");");
                        //webView.loadUrl(url + "&CenterLatitude=" + lat + "&CenterLongitude="+lng+"&YunziIDs=;");
                    }*/
                    webView.loadUrl(Constants.ShowMapUrl + "?" + "CenterLatitude=" + lat + "&CenterLongitude=" + lng + "&YunziIDs=" + str + "&ShowType=list");

                }
            }

        }

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            errorDetected = true;
        }

    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    /*private String readTextFromResource(int resourceID)
    {
        InputStream raw = getResources().openRawResource(resourceID);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int i;
        try
        {
            i = raw.read();
            while (i != -1)
            {
                stream.write(i);
                i = raw.read();
            }
            raw.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        return stream.toString();
    }*/



    ///WECHAT START

    public void payBillWeChat(final String paymentId, String amount, String _outTradeNo)
    {
        //WeChatPayAmount = amount;
        WeChatOutTradeNo  = _outTradeNo;
        GetPrepayIdTask getPrepayId = new GetPrepayIdTask();

        if(getPrepayId != null) getPrepayId.execute();
    }


    private String genPackageSign(List<NameValuePair> params) {
        StringBuilder sb = new StringBuilder();
        if(params != null) {
            for (int i = 0; i < params.size(); i++) {
                sb.append(params.get(i).getName());
                sb.append('=');
                sb.append(params.get(i).getValue());
                sb.append('&');
            }
            sb.append("key=");
            sb.append(ConstantsWeChat.API_KEY);
        }

        String packageSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase();
        //Log.e("orion",packageSign);
        return packageSign;
    }

    private String genAppSign(List<NameValuePair> params) {
        StringBuilder sb = new StringBuilder();
        if(params != null) {
            for (int i = 0; i < params.size(); i++) {
                sb.append(params.get(i).getName());
                sb.append('=');
                sb.append(params.get(i).getValue());
                sb.append('&');
            }
            sb.append("key=");
            sb.append(ConstantsWeChat.API_KEY);

            this.sb.append("sign str\n" + sb.toString() + "\n\n");

        }
        String appSign = MD5.getMessageDigest(sb.toString().getBytes()).toUpperCase();
        Log.e("orion", appSign);
        return appSign;
    }

    private String toXml(List<NameValuePair> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        if(params != null) {
            for (int i = 0; i < params.size(); i++) {
                sb.append("<" + params.get(i).getName() + ">");


                sb.append(params.get(i).getValue());
                sb.append("</" + params.get(i).getName() + ">");
            }
        }
        sb.append("</xml>");

        Log.e("orion",sb.toString());
        return sb.toString();
    }

    private class GetPrepayIdTask extends AsyncTask<Void, Void, Map<String,String>> {

        private ProgressDialog dialog;


        @Override
        protected void onPreExecute() {
            dialog = ProgressDialog.show(MainActivity.this, getString(R.string.app_tip), getString(R.string.getting_prepayid));
        }

        @Override
        protected void onPostExecute(Map<String,String> result) {
            if (dialog != null) {
                dialog.dismiss();
            }
            if(sb != null) sb.append("prepay_id\n" + result.get("prepay_id") + "\n\n");
            //show.setText(sb.toString());
            resultunifiedorder=result;

            genPayReq();
            sendPayReq();

        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
        }

        @Override
        protected Map<String,String>  doInBackground(Void... params) {

            String url = String.format("https://api.mch.weixin.qq.com/pay/unifiedorder");
            String entity = genProductArgs();

            //Log.e("orion",entity);

            byte[] buf = Util.httpPost(url, entity);

            String content = new String(buf);
            //Log.e("orion", content);
            Map<String,String> xml=decodeXml(content);

            return xml;
        }
    }

    public Map<String,String> decodeXml(String content) {

        try {
            Map<String, String> xml = new HashMap<String, String>();
            XmlPullParser parser = Xml.newPullParser();
            if(content != null) parser.setInput(new StringReader(content));
            int event = parser.getEventType();
            while (event != XmlPullParser.END_DOCUMENT) {

                String nodeName=parser.getName();
                switch (event) {
                    case XmlPullParser.START_DOCUMENT:

                        break;
                    case XmlPullParser.START_TAG:

                        if("xml".equals(nodeName)==false){
                            //å®žä¾‹åŒ–studentå¯¹è±¡
                            xml.put(nodeName,parser.nextText());
                        }
                        break;
                    case XmlPullParser.END_TAG:
                        break;
                }
                event = parser.next();
            }

            return xml;
        } catch (Exception e) {
            Log.e("orion",e.toString());
        }
        return null;

    }

    private String genNonceStr() {
        Random random = new Random();
        return MD5.getMessageDigest(String.valueOf(random.nextInt(10000)).getBytes());
    }

    private long genTimeStamp() {
        return System.currentTimeMillis() / 1000;
    }

    private String genOutTradNo() {
        Random random = new Random();
        return MD5.getMessageDigest(String.valueOf(random.nextInt(10000)).getBytes());
    }

    private String genProductArgs() {
        StringBuffer xml = new StringBuffer();

        try {
            String	nonceStr = genNonceStr();


            xml.append("</xml>");
            List<NameValuePair> packageParams = new LinkedList<NameValuePair>();
            packageParams.add(new BasicNameValuePair("appid", ConstantsWeChat.APP_ID));
            packageParams.add(new BasicNameValuePair("body", "weixin"));
            packageParams.add(new BasicNameValuePair("mch_id", ConstantsWeChat.MCH_ID));
            packageParams.add(new BasicNameValuePair("nonce_str", nonceStr));
            packageParams.add(new BasicNameValuePair("notify_url", "http://cloudcomspace.cloudapp.net/Payments/PaymentNotifyActionWeChat"));
            packageParams.add(new BasicNameValuePair("out_trade_no", WeChatOutTradeNo));//genOutTradNo()));
            packageParams.add(new BasicNameValuePair("spbill_create_ip","127.0.0.1"));
            packageParams.add(new BasicNameValuePair("total_fee", WeChatPayAmount));
            packageParams.add(new BasicNameValuePair("trade_type", "APP"));


            String sign = genPackageSign(packageParams);
            packageParams.add(new BasicNameValuePair("sign", sign));


            String xmlstring =toXml(packageParams);

            return xmlstring;

        } catch (Exception e) {
            //Log.e(TAG, "genProductArgs fail, ex = " + e.getMessage());
            return null;
        }

    }

    private void genPayReq() {
        if(req != null) {
            req.appId = ConstantsWeChat.APP_ID;
            req.partnerId = ConstantsWeChat.MCH_ID;
            if (resultunifiedorder != null)
                req.prepayId = resultunifiedorder.get("prepay_id");
            req.packageValue = "Sign=WXPay";
            req.nonceStr = genNonceStr();
            req.timeStamp = String.valueOf(genTimeStamp());


            List<NameValuePair> signParams = new LinkedList<NameValuePair>();
            signParams.add(new BasicNameValuePair("appid", req.appId));
            signParams.add(new BasicNameValuePair("noncestr", req.nonceStr));
            signParams.add(new BasicNameValuePair("package", req.packageValue));
            signParams.add(new BasicNameValuePair("partnerid", req.partnerId));

            signParams.add(new BasicNameValuePair("prepayid", req.prepayId));
            signParams.add(new BasicNameValuePair("timestamp", req.timeStamp));

            req.sign = genAppSign(signParams);

            sb.append("sign\n" + req.sign + "\n\n");

            //show.setText(sb.toString());

            //Log.e("orion", signParams.toString());
        }

    }

    private void sendPayReq() {
        if(msgApi != null) {
            String wxappPayEntryClassname = (new com.tencent.mm.sdk.a(this)).getString("_wxapp_pay_entry_classname_", (String) null);
            msgApi.registerApp(ConstantsWeChat.APP_ID);
            msgApi.sendReq(req);
        }
    }
    //WECHAT END

    //Handle button clicks on WebView
    public class JavaScriptInterface {
        Context mContext;

        JavaScriptInterface(Context c) {
            mContext = c;
        }
        @JavascriptInterface
        public void performClick(final String  paymentId, final String  amount, final String outTradeNo, final String methodID){

            jsHandler.post(new Runnable() {
                @Override
                public void run() {
                    // This gets executed on the UI thread so it can safely modify Views
                    //Toast.makeText(mContext, paymentId + " " + amount + " " + methodID, Toast.LENGTH_LONG ).show();
                    if(methodID != null && methodID.equals(Constants.PaymentMethodAliPay))
                    {
                        payBillAliPay(paymentId, amount, outTradeNo);
                    }
                    else
                    {
                        if(methodID.equals(Constants.PaymentMethodWeChat))
                        {
                            payBillWeChat(paymentId, amount, outTradeNo);
                        }
                    }

                }
            });

        }
    }



}
