package ccs.project.myapplication;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.ProgressDialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import ccs.project.myapplication.model.RawData;
import ccs.project.myapplication.sqlite.MySQLiteHelper;


public class MainActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);


        ListView listView = (ListView) findViewById(R.id.listView);





        //Create fake meter profiles
        final List<MeterProfileModel> listMeters = new LinkedList<>();
        List<String> meterNames = new LinkedList<>();
        meterNames.add("City1");
        meterNames.add("City2");
        meterNames.add("City3");
        meterNames.add("City4");
        meterNames.add("City5");
        String phoneUUId = "TestPhone";
        Random rand = new Random();
        // nextInt is normally exclusive of the top value,
        // so add 1 to make it inclusive
        for(int i = 0; i<500; i++) {
            int randomNameInd = rand.nextInt(meterNames.size());
            String meterName = meterNames.get(randomNameInd);
            double latitude = 38 + (40 - 38) * rand.nextDouble();
            double longitude = 115 + (117 - 115) * rand.nextDouble();
            listMeters.add(new MeterProfileModel(meterName, latitude, longitude, phoneUUId, false));
        }


        // get data from the table by the ListAdapter
        //MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, MeterProfilesDataHolder.getInstance().getListMeters());
        MetersListAdapter customAdapter = new MetersListAdapter(this, R.layout.meterlistrow, listMeters);
        listView.setAdapter(customAdapter);




    }




    public static class MyDialogFragment extends DialogFragment {

        @Override
        public void onCancel(DialogInterface dialogInterface) {
            Log.e("my", "called");

        }

    }



}
