var $ = jQuery;
var selectat = new Array();
$(document).ready(function() {
    var table = $('#example').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": ajaxurl,
            "type": "POST",
            "data": function ( d ) {
                d.action = "my_action";
                d.do = 'pingoomp_referrals';
            }
        },
        "columnDefs": [ {
          "targets": 4,
          "searchable": false,
          "sortable": false
        } ],
        "columns": [
            { "data": "ID" }, 
            { "data": "user_login" },
            { "data": "user_email" },
            { "data": "nr" },
            { "data": "inputno"}
        ],
        "fnDrawCallback": function() {
            for(i=0;i<selectat.length;i++) {
                if (selectat[i].indexOf('row_')>-1) {
                    // select row
                    $('#'+selectat[i]).addClass('selected');
                    // set input value
                    $('#no_'+selectat[i].replace('row_','')).val(selectat[i+1]);
                }
            }
        }
    });


    var table2 = $('#example2').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": ajaxurl,
            "type": "POST",
            "data": function ( d ) {
                d.action = "my_action";
                d.do = 'pingoomp_transactions';
            }
        },
        "columnDefs": [ {
          "targets": 4,
          "searchable": false,
          "sortable": false
        } ],
        "columns": [
            { "data": "id" }, 
            { "data": "email" },
            { "data": "ammount" },
            { "data": "currency" },
            { "data": "status" },
            { "data": "date_added" },
            { "data": "date_modified" },
            { "data": "nr" }
        ]
    });
    
    $('#example tbody').on( 'click', 'tr', function (e) {
        if ( $(e.target).is(':input') )
            return;
        $(this).toggleClass('selected');
        var idrow = $(this).attr('id');
        var idrownumeric = idrow.replace('row_','');
        var norow = $('#no_'+idrownumeric).val();
        if ( $(this).hasClass('selected') ) {
            selectat.push(idrow,norow)                
        }
        else {
            var index = selectat.indexOf(idrow);
            if (index > -1) {
                selectat.splice(index, 2);
            }
        }
        getTotal();

    } );

} );

function changeVal(row,nr) {
    var valoare = $('#no_'+row).val();
    if (valoare>nr)
        $('#no_'+row).val(nr);
    else {
        // cautam daca exista randul in lista de selectate si actualizam valoarea
        var index = selectat.indexOf('row_'+row);
        if (index > -1) {
            selectat.splice(index, 2);
            selectat.push('row_'+row,valoare);
        }
    }
    getTotal();
}

function getTotal()
{
    var total = 0;
    for (i=0;i<selectat.length;i++)
        if (i%2!=0)
            total += parseFloat(selectat[i]);
    $('#comisiontotal').html('Total commission selected: '+total*commission+' '+currency);
}

function addToPendingPayments()
{
    jQuery('#paymentbtn').attr("disabled", "disabled");
    if (selectat.length==0)
    {
        jQuery('#alerts').html('<div class="alert alert-danger alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><strong>Error!</strong> You must select at least a user.</div>');
        $("#paymentbtn").removeAttr("disabled");
        return false;
    }
    var data = {
        'action': 'my_action',
        'do': 'pingoomp_addtopending',
        'selectat': selectat
    };
    jQuery.post(ajaxurl, data, function(response) {
        if (response=='ok')
        {
            jQuery('#alerts').html('<div class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button><strong>Success!</strong> The payments have been sent to PayPal.</div>');
            selectat = new Array();
            jQuery('#example').dataTable().fnDraw();
        }
        else
        {
            jQuery('#alerts').html('<div class="alert alert-danger alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+response+'</div>');
        }
    });
    $("#paymentbtn").removeAttr("disabled");
}