<?php
function wp_referral() {
	$active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'stats';
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( 'You do not have sufficient permissions to access this page.' );
	}
	wp_register_style( 'WPReferralStylesheet', plugins_url('/css/style.css', __FILE__) );	
    wp_enqueue_style( 'WPReferralStylesheet' );
$cookie_life = get_option( 'wp_referral_cookie_life' );
if ($cookie_life == 0) { 
	$cookie_life_text = "DISABLED";
} else {
	$cookie_life_text = "set to ".$cookie_life." days";
}
?>
<div><?php settings_errors(); ?></div>
<div class="wrap">

<h2></h2>
		<h2 class="nav-tab-wrapper">
		    <a href="?page=wp-referral&tab=stats" class="nav-tab <?php echo $active_tab == 'stats' ? 'nav-tab-active' : ''; ?>">Stats</a>
		    <a href="?page=wp-referral&tab=transactions" class="nav-tab <?php echo $active_tab == 'transactions' ? 'nav-tab-active' : ''; ?>">Transactions</a>
		    <a href="?page=wp-referral&tab=pay" class="nav-tab <?php echo $active_tab == 'pay' ? 'nav-tab-active' : ''; ?>">Pay</a>
		    <a href="?page=wp-referral&tab=settings" class="nav-tab <?php echo $active_tab == 'settings' ? 'nav-tab-active' : ''; ?>">Settings</a>
		    <a href="?page=wp-referral&tab=info" class="nav-tab <?php echo $active_tab == 'info' ? 'nav-tab-active' : ''; ?>">Info</a>
		    <span style="float: right; text-align: right;">WP Affiliate & Referral v3.0.1<br /><em class="wprmicro">Powered by <a href="http://markessence.com" target="_blank">MarkEssence</a></em></span>
		</h2>
		<br />

<?php
if( $active_tab == 'stats' ) { 
	require_once (plugin_dir_path( __FILE__ ).'/page-wp-referral-stats.php');
} elseif ($active_tab == 'transactions') {
	require_once (plugin_dir_path( __FILE__ ).'/page-wp-referral-transactions.php');
} elseif ($active_tab == 'pay') {
	require_once (plugin_dir_path( __FILE__ ).'/page-wp-referral-pay.php');
} elseif ($active_tab == 'settings') {
	require_once (plugin_dir_path( __FILE__ ).'/page-wp-referral-settings.php');
} elseif ($active_tab == 'info') {
	require_once (plugin_dir_path( __FILE__ ).'/side-info.php');
} ?>

</div>
<?php 
} ?>
