<?php
function WP_Referral_link_shortcode( $atts ){
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = __('Your referral id is' ,'wpreferral').' <strong>'.get_current_user_id().'</strong> '.__('and the default registration link with your referral id is','wpreferral').' '.$regurl.'. </p><pre>'.$regurl.'</pre><p>'.__('To refer this website you can share this link to your friends or any other link to this website but remember to add at the end of any link the following code:','wpreferral').' <strong>?ref='.get_current_user_id().'</strong>  '.__('(for example, this link will work just fine ','wpreferral').site_url().'/?ref='.get_current_user_id().').</p>';
		return $html;
	}
}
add_shortcode( 'referral_link', 'WP_Referral_link_shortcode' );
function WP_Referral_banner_shortcode( $atts, $content = null ) {
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = '<a href="'.$regurl.'" title="'.get_bloginfo('name').'">'.$content.'</a><pre>&lt;a href="'.$regurl.'" title="'.get_bloginfo('name').'">'.htmlentities($content).'&lt;/a></pre>';
		return $html;
	}
}
add_shortcode( 'referral_banner', 'WP_Referral_banner_shortcode' );

function get_user_referral($user_id){
    return $current_ref = get_user_meta($user_id, 'referral_id', true);
}
function WP_Referral_Downline_shortcode( $atts ){
	if ( is_user_logged_in() ) {
		$downline = get_users(array('orderby' => 'registered', 'meta_key' => 'referral_id','meta_value'=>get_current_user_id()));
		$html = '<p>';
		if (count($downline) > 0) {
			$html .= __('You have successfully recommend','wpreferral').' '.count($downline).' '.__('people.','wpreferral').'</p>';
		} else {
			$html .= __('You did not successfully recommend any people.','wpreferral').'</p>';
		}
		if (empty($downline)) {
			
		} else {
			$html .= "<ul class='wp-referral-downline'>";
			foreach ($downline as $user) {
				$html.= '<li>' . $user->display_name . '</li>';
			}
			$html .= "</ul>";
		}
		return $html;
	}
}
add_shortcode( 'referral_downline', 'WP_Referral_Downline_shortcode' );
function WP_Referral_Upline_shortcode( $atts ){
	if ( is_user_logged_in() ) {
		$upwnlineid = get_user_meta(get_current_user_id(), 'referral_id', true);
		$html = '';
		if ($upwnlineid != '') {
			$user_info = get_userdata($upwnlineid);
			$html .= $user_info->first_name.' '.$user_info->last_name;
		} else {
		}
		return $html;
	}
}
add_shortcode( 'referral_upline', 'WP_Referral_Upline_shortcode' );






add_shortcode( 'referral_fb', 'WP_Referral_FB_shortcode' );
function WP_Referral_FB_shortcode( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = '<style>iframe { max-width: inherit !important; }</style><div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId='.get_option('wp_referral_fb').'";
  fjs.parentNode.insertBefore(js, fjs);
}(document, "script", "facebook-jssdk"));</script><div class="fb-send" style="margin-bottom: 15px;" data-href="'.$regurl.'" data-colorscheme="light"></div> <div class="fb-share-button" style="margin-bottom: 15px;" data-href="'.$regurl.'" data-type="button"></div>';
		return $html;
	}
}
add_shortcode( 'referral_twitter', 'WP_Referral_Twitter_shortcode' );
function WP_Referral_Twitter_shortcode( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = "<a href='https://twitter.com/share' class='twitter-share-button' data-url='".$regurl."'>Tweet</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>";
		return $html;
	}
}
add_shortcode( 'referral_googleplus', 'WP_Referral_GooglePlus_shortcode' );
function WP_Referral_GooglePlus_shortcode( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = '<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>
<g:plusone href="'.$regurl.'" data-size="small"></g:plusone>';
		return $html;
	}
}
add_shortcode( 'referral_linkedin', 'WP_Referral_LinkedIn_shortcode' );
function WP_Referral_LinkedIn_shortcode( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl_check = get_option('wp_referral_register_url');
		if (!isset($regurl_check) || $regurl_check == '' || $regurl_check == '/wp-login.php?action=register') {
			$regurl = site_url().'/wp-login.php?action=register&ref='.get_current_user_id();
		} else {
			if(stripos($regurl_check, '?') !== false) {
				$regurl = site_url().$regurl_check.'&ref='.get_current_user_id();
			} else {
				$regurl = site_url().$regurl_check.'?ref='.get_current_user_id();
			}
		}
		$html = '<script src="//platform.linkedin.com/in.js" type="text/javascript">lang: en_US</script><script type="IN/Share" data-url="'.$regurl.'" data-counter="right"></script>';
		return $html;
	}
}



add_shortcode( 'referral_fb_current', 'WP_Referral_FB_shortcode_current' );
function WP_Referral_FB_shortcode_current( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl = get_permalink($post->ID).'?ref='.get_current_user_id();
		$html = '<style>iframe { max-width: inherit !important; }</style><div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId='.get_option('wp_referral_fb').'";
  fjs.parentNode.insertBefore(js, fjs);
}(document, "script", "facebook-jssdk"));</script><div class="fb-send" style="margin-bottom: 15px;" data-href="'.$regurl.'" data-colorscheme="light"></div> <div class="fb-share-button" style="margin-bottom: 15px;" data-href="'.$regurl.'" data-type="button"></div>';
		return $html;
	}
}
add_shortcode( 'referral_twitter_current', 'WP_Referral_Twitter_shortcode_current' );
function WP_Referral_Twitter_shortcode_current( $atts ) {
	if ( is_user_logged_in() ) {
		global $post;
		$regurl = get_permalink($post->ID).'?ref='.get_current_user_id();
		$html = "<a href='https://twitter.com/share' class='twitter-share-button' data-url='".$regurl."'>Tweet</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>";
		return $html;
	}
}
add_shortcode( 'referral_googleplus_current', 'WP_Referral_GooglePlus_shortcode_current' );
function WP_Referral_GooglePlus_shortcode_current( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl = get_permalink($post->ID).'?ref='.get_current_user_id();
		$html = '<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>
<g:plusone href="'.$regurl.'" data-size="small"></g:plusone>';
		return $html;
	}
}
add_shortcode( 'referral_linkedin_current', 'WP_Referral_LinkedIn_shortcode_current' );
function WP_Referral_LinkedIn_shortcode_current( $atts ) {
	if ( is_user_logged_in() ) {
		$regurl = get_permalink($post->ID).'?ref='.get_current_user_id();
		$html = '<script src="//platform.linkedin.com/in.js" type="text/javascript">lang: en_US</script><script type="IN/Share" data-url="'.$regurl.'" data-counter="right"></script>';
		return $html;
	}
}


?>