<?php
/*
Plugin Name: WordPress Referral
Description: WordPress Referral is a very useful plugin that extends your Wordpress website with a very effective referral system. You have an option to use cookies to track your website referrals. 
Author: markessence
Author URI: http://markessence.com
Text Domain: wpreferral
Version: 3.1.0
*/
ob_start();
require_once (plugin_dir_path( __FILE__ ).'/admin/wp-init.php');
require_once (plugin_dir_path( __FILE__ ).'/admin/charts.php');
require_once (plugin_dir_path( __FILE__ ).'/admin/page-wp-referral.php');
require_once (plugin_dir_path( __FILE__ ).'/wp-referral-shortcodes.php');


function wpreferral_install()
{
    global $wpdb;
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

    $sql = 'CREATE TABLE IF NOT EXISTS `'.$wpdb->prefix.'pingoo_payments` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `email` varchar(255) NOT NULL,
      `ammount` decimal(10,0) NOT NULL,
      `currency` varchar(3) NOT NULL,
      `sent_to_paypal` int(11) NOT NULL,
      `status` varchar(255) NOT NULL,
      `paypal_response` longtext NOT NULL,
      `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      `date_modified` timestamp NOT NULL DEFAULT \'0000-00-00 00:00:00\',
      PRIMARY KEY (`id`)
    );';

    dbDelta( $sql );

    $sql = 'CREATE TABLE IF NOT EXISTS `'.$wpdb->prefix.'pingoo_payed_referrals` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `user_email` varchar(255) NOT NULL,
      `user_id` varchar(255) NOT NULL,
      `referral_id` int(11) NOT NULL,
      `payment_id` int(11) NOT NULL,
      `date_added` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`)
    );';

    dbDelta( $sql );
}
register_activation_hook( __FILE__, 'wpreferral_install' );



// Settings Link
add_filter('plugin_action_links', 'wpreferral_plugin_action_links', 10, 2);
function wpreferral_plugin_action_links($links, $file) {
    static $this_plugin;
    if (!$this_plugin) {
        $this_plugin = plugin_basename(__FILE__);
    }
    if ($file == $this_plugin) {
        $settings_link = '<a href="' . site_url() . '/wp-admin/admin.php?page=wp-referral&tab=settings">Settings</a>';
        array_unshift($links, $settings_link);
    }
    return $links;
}

// Add languages
add_action('plugins_loaded', 'wpreferral_load', 0);
function wpreferral_load() {
    function wpreferral_action_init() {
        load_plugin_textdomain('wpreferral', false, basename(dirname(__FILE__)).'/languages/');
    }
    add_action('init', 'wpreferral_action_init');
}


$ref = 0;
//$ref = (int)$_GET['ref'];
if (isset($_GET['ref']) && !empty($_GET['ref']) && $_GET['ref'] != 0) {
	$ref = (int)$_GET['ref'];
	$cookie_life = (int)get_option( 'wp_referral_cookie_life' );
	if(isset($cookie_life) && $cookie_life != 0) {
		setcookie('wpref',(int)$_GET['ref'],time()+60*60*24*$cookie_life, '/', $_SERVER['SERVER_NAME'] );
	} elseif (isset($cookie_life) && $cookie_life == 0) {
		// do nothing
	} else {
		setcookie('wpref',(int)$_GET['ref'],time()+60*60*24*$cookie_life, '/', $_SERVER['SERVER_NAME'] );
	}
}
else if (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref']))
$ref = (int)$_COOKIE['wpref'];

$cookie_life = get_option( 'wp_referral_cookie_life' );
if ($cookie_life == 0) { 
	$cookie_life_text = "DISABLED";
} else {
	$cookie_life_text = "set to ".$cookie_life." days";
}

$wprefedit_check = get_option('wp_referral_wprefedit');
if (isset($wprefedit_check) && $wprefedit_check=='yes') {
	add_action( 'personal_options_update', 'update_extra_profile_fields_wpref' );
	add_action( 'edit_user_profile_update', 'update_extra_profile_fields_wpref' );
	function update_extra_profile_fields_wpref( $user_id ) { 
	    global $current_user,$wpdb;
	    get_currentuserinfo();
	    if ( !current_user_can( 'edit_user', $user_id ) )
	        return false;
		if (in_array('administrator', $current_user->roles)){
		    $userdata = array();
		    //$userdata['ID'] = $user_id;                    
		    $userdata['referral_id'] = $_POST['referral_id'];
		    update_user_meta( $user_id, 'referral_id', $_POST['referral_id'] );
	    }
	}
	add_filter('user_contactmethods', 'profile_fields_wpref');
	function profile_fields_wpref($profile_fields) {
	    global $current_user,$wpdb;
	    get_currentuserinfo();
		if (in_array('administrator', $current_user->roles)){
			$profile_fields['referral_id'] = 'Referral ID';
		}
		return $profile_fields;
	}
}



function get_total_referrals_per_user ($user_id)
{
	global $wpdb;
	global $post_id;
	$total_referred_by_user = $wpdb->get_var( "SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key='referral_id' AND meta_value='$user_id'" );
	return number_format_i18n($total_referred_by_user);
}










// WP - Adding Referral ID and Total Referrals to Users COLUMNS listing in admin
add_filter('manage_users_columns', 'wpref_add_user_data_column', 15, 1);
function wpref_add_user_data_column($columns) {
	$columns['user_id'] = 'User ID';
    $columns['referral_id'] = 'Referral ID';
    $columns['referrals'] = 'Referrals'; 
    return $columns;
}
// WP - Adding Referral ID and Total Referrals to Users CONTENT listing in admin
add_action('manage_users_custom_column',  'wpref_show_user_id_content', 15, 3);
function wpref_show_user_id_content($custom_column,$column_name,$id) {
	if( $column_name == 'user_id' ) { return $id; }
	if( $column_name == 'referral_id' ) { return get_the_author_meta('referral_id', $id); }
	if( $column_name == 'referrals' ) { return get_total_referrals('referral_id', $id); }
	return $custom_column;
}	
// WP - Total referrals for Users listing
function get_total_referrals ($meta_key, $meta_value)
{
	global $wpdb;
	global $post_id;
	if ($meta_value == '0') {
		$total_referred = $wpdb->get_var(  "SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key='$meta_key' AND meta_value!='0' AND meta_value!=''" );
		$total_referrals = $wpdb->get_var(  "SELECT COUNT(DISTINCT meta_value) FROM $wpdb->usermeta WHERE meta_key='$meta_key' AND meta_value!='0' AND meta_value!='' " );
		return array(number_format_i18n($total_referred),number_format_i18n($total_referrals));
	} else {
		$total_referred = $wpdb->get_var(  "SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key='$meta_key' AND meta_value='$meta_value'");
		return number_format_i18n($total_referred);
	}
	
}

//send_notification(39, 1);
function send_notification ($to, $refu) {
	if (is_admin()) require_once(ABSPATH . 'wp-includes/pluggable.php');
	


	$user_info = get_userdata($to);
	$toname = $user_info->user_nicename;
	$toemail = $user_info->user_email;
	$fromname = get_bloginfo('name');
	$fromemail = get_bloginfo('admin_email');

	$refu_info = get_userdata($refu);
	$refu_nicename  = $refu_info->user_nicename;

	
	//$headers = array('Content-Type: text/html; charset=UTF-8','To: '.$toname.' <'.$toemail.'>','From: '.$fromname.' <'.$fromemail.'>');

	//$headers = 'To: '.$toname.' <'.$toemail.'>' . "\r\n";
	$headers = 'From: '.get_bloginfo("name").' <'.get_bloginfo("admin_email").'>' . "\r\n";
	$headers .= 'Content-Type: text/html; charset=UTF-8' . "\r\n";

    $subject = get_option( 'wp_referral_notif_s' );
    $body = str_replace('{user_nicename}', $refu_nicename, get_option( 'wp_referral_notif_b'));
	
	
	wp_mail( $toname.' <'.$toemail.'>', $subject, $body, $headers );

}





////////////////////////////////
// DEFAULT WORDPRESS INTEGRATION
////////////////////////////////
add_action('register_form','wpref_register_extra_fields');
function wpref_register_extra_fields(){
	$ref = '0';
	if (isset($_GET['ref']) && !empty($_GET['ref'])) {
		$ref = (int)$_GET['ref'];
	} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
		$ref = (int)$_COOKIE['wpref'];
	}
	echo '<input type="hidden"  size="25" value="'.$ref.'" name="referral_id" readonly="readonly" />';
} 
add_action('user_register', 'wpref_register_post_fields');
function wpref_register_post_fields($user_id, $password='', $meta=array())  {
    $userdata = array();
    $userdata['ID'] = $user_id;
    $userdata['referral_id'] = $_POST['referral_id'];
    wp_update_user($userdata);
    update_user_meta( $user_id, 'referral_id', $_POST['referral_id'] );   
    send_notification ($_POST['referral_id'], $user_id); 
}

/////////////////////////////////////////
// S2MEMBER INTEGRATION (STANDARD + PAID)
/////////////////////////////////////////
add_action( 'user_register', 'wpref_referral_s2member' );
function wpref_referral_s2member($user_id) {
	$ref = '0';
	if (isset($_GET['ref']) && !empty($_GET['ref'])) {
		$ref = (int)$_GET['ref'];
	} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
		$ref = (int)$_COOKIE['wpref'];
	}
	update_user_meta( $user_id, 'referral_id', $ref );
    send_notification ($ref, $user_id); 
}


//////////////////////////////////
// USER PRO INTEGRATION (STANDARD)
//////////////////////////////////
add_action ('userpro_after_new_registration', 'wpref_referral_userpro', 10, 1);
function wpref_referral_userpro($user_id) {
	$ref = '0';
	$verif = get_user_meta('referral_id', $user_id, true); 
	if (isset($verif) && !empty($verif)) {
		if (isset($_GET['ref']) && !empty($_GET['ref'])) {
			$ref = (int)$_GET['ref'];
			update_user_meta( $user_id, 'referral_id', $ref );
			send_notification ($ref, $user_id); 
		} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
			$ref = (int)$_COOKIE['wpref'];
			update_user_meta( $user_id, 'referral_id', $ref );
			send_notification ($ref, $user_id); 
		}
	}
}

add_action('userpro_before_fields',  'wpref_add_referral_userpro');
function wpref_add_referral_userpro() {
	global  $current_user, $user_id;
	$ref = '0';
	$userID = get_current_user_id();
	$ref_temp = get_user_meta($userID, 'referral_id', true);
	if (isset($ref_temp) && !empty($ref_temp)) {
		$ref = $ref_temp;
		echo '<input type="hidden" size="25" value="'.$ref.'" name="referral_id" readonly="readonly" />';
	} elseif (isset($_GET['ref']) && !empty($_GET['ref'])) {
		$ref = (int)$_GET['ref'];
		echo '<input type="hidden" size="25" value="'.$ref.'" name="referral_id" readonly="readonly" />';
	} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
		$ref = (int)$_COOKIE['wpref'];
		echo '<input type="hidden" size="25" value="'.$ref.'" name="referral_id" readonly="readonly" />';
	}
}


/////////////////////////////////////
// BUDDY PRESS INTEGRATION (STANDARD)
/////////////////////////////////////
add_action( 'bp_before_registration_submit_buttons', 'wpref_bbg_add_reg_field' );
function wpref_bbg_add_reg_field() {
	$ref = '0';
	if (isset($_GET['ref']) && !empty($_GET['ref'])) {
		$ref = (int)$_GET['ref'];
	} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
		$ref = (int)$_COOKIE['wpref'];
	}
	echo '<input type="hidden"  size="25" value="'.$ref.'" name="referral_id" readonly="readonly" />';
}
// bp_core_signup_user


// WOOCOMMERCE INTEGRATION
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	// Set Woo Referral Order Column
	add_filter( "manage_edit-shop_order_columns", 'wpref_woo_column_set', 20, 1 ); 
	function wpref_woo_column_set( $columns ) {
	    $columns['wpref'] = "Referral";
	    return $columns;
	}
	// Display Woo Referral Order Column
	add_action( "manage_shop_order_posts_custom_column", 'wpref_woo_column_display', 20, 2 ); 
	function wpref_woo_column_display( $column_name, $post_id ) {
	    if ( 'wpref' != $column_name )
	        return;
	    echo get_post_meta( $post_id, 'wpref', true );
	}
	// Sort Woo Referral Order Column
	add_filter( "manage_edit-shop_order_sortable_columns", 'wpref_woo_column_sort' ); 
	function wpref_woo_column_sort( $columns ) {
	    $columns['wpref'] = 'wpref';
	    return $columns;
	}
	// Register referral's order
	add_action( 'woocommerce_order_status_pending', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_failed', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_on-hold', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_processing', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_completed', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_refunded', 'wpref_woo_order' );
	add_action( 'woocommerce_order_status_cancelled', 'wpref_woo_order' );
	function wpref_woo_order( $order_id ) {
		$check_guest = get_option('woocommerce_enable_guest_checkout');
		if ($check_guest=='yes') {
			$ref = '0';
			if (isset($_GET['ref']) && !empty($_GET['ref'])) {
				$ref = (int)$_GET['ref'];
			} elseif (isset($_COOKIE['wpref']) && !empty($_COOKIE['wpref'])) {
				$ref = (int)$_COOKIE['wpref'];
			}
		} else {
			$user_ID = get_current_user_id();
			$ref = get_user_meta( $user_ID, 'referral_id', true );
		}
	    add_post_meta( $order_id, 'wpref', $ref, true );
	}
}










add_action( 'wp_ajax_my_action', 'wpaffref_callback' );
function wpaffref_callback()
{
    global $wpdb;

    //$currency = get_option('pingoomp_currency');
    //$commission = get_option('pingoomp_value');
    //$threshold = get_option('pingoomp_threshold');
    $currency = get_option('wp_referral_amount_ccode');
    $commission = get_option('wp_referral_amount');
    $threshold = get_option('wp_referral_affcheck');
    
    if (isset($_POST['do']) && $_POST['do']=='pingoomp_addtopending')
    {
        if (isset($_POST['selectat']) && !empty($_POST['selectat']))
        {
            for ($i=0;$i<count($_POST['selectat']);$i+=2)
            {
                $user_id = str_replace('row_','',$_POST['selectat'][$i]);
                $value = $_POST['selectat'][$i+1];
                # get user info
                $user = $wpdb->get_row('SELECT * FROM '.$wpdb->users.' WHERE ID = '.mysql_real_escape_string($user_id));
                if (!empty($user))
                {
                    # check if number of referrals is allowed, if not, set it to the possible max that is not 0 and above threshold
                    $r = $wpdb->get_results('
                        SELECT meta_key FROM '.$wpdb->usermeta.'
                            WHERE meta_key=\'referral_id\' AND meta_value='.mysql_real_escape_string($user_id));
                    $total = count($r);
                    if ($value>$total) $value = $total;

                    if ($value>=$threshold && $value>0)
                    {
                        # add user transaction to database
                        $wpdb->insert( 
                            $wpdb->prefix.'pingoo_payments', 
                            array( 
                                'email' => $user->user_email, 
                                'ammount' => ($value*$commission),
                                'currency' => $currency ? $currency : 'USD',
                                'sent_to_paypal' => 0,
                                'status' => 'not sent',
                                'date_added' => date('Y-m-d H:i:s'),
                                'date_modified' => date('Y-m-d H:i:s')
                            )
                        );
                        # get transaction id
                        $trans_id = $wpdb->insert_id;
                        # get the referral ids that are being payed
                        $r = $wpdb->get_results('
                            SELECT user_id
                            FROM '.$wpdb->usermeta.' 
                            WHERE meta_key=\'referral_id\' AND meta_value='.mysql_real_escape_string($user_id).' AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals) LIMIT '.$value);
                        foreach ($r as $result)
                        {
                            # insert payed referral into the database
                            $wpdb->insert( 
                                $wpdb->prefix.'pingoo_payed_referrals', 
                                array( 
                                    'user_email' => $user->user_email, 
                                    'user_id' => $user->ID,
                                    'referral_id' => $result->user_id,
                                    'payment_id' => $trans_id,
                                    'date_added' => date('Y-m-d H:i:s')
                                )
                            );
                        }
                    }
                }
            }
            # send to paypal
            include('PayPal/includes/config.php');
            include('PayPal/autoload.php');
            $r = $wpdb->get_results('
                SELECT *,(SELECT COUNT(id) FROM '.$wpdb->prefix.'pingoo_payed_referrals WHERE payment_id='.$wpdb->prefix.'pingoo_payments.id) AS nr
                FROM '.$wpdb->prefix.'pingoo_payments 
                WHERE sent_to_paypal=0');

            $PayPalConfig = array(
                'Sandbox' => $sandbox,
                'APIUsername' => $api_username,
                'APIPassword' => $api_password,
                'APISignature' => $api_signature
            );

            $PayPal = new angelleye\PayPal\PayPal($PayPalConfig);

            $MPFields = array(
                'emailsubject' => 'Plata Pingoo', 
                'currencycode' => $currency,
                'receivertype' => 'EmailAddress'
            );
                                                
            $MPItems = array();

            $i=0;
            $error = '';
            foreach ($r as $row)
            {
                $i++;
                $item = array(
                    'l_email' => $row->email,
                    'l_receiverid' => '',
                    'l_amt' => $row->ammount,
                    'l_uniqueid' => $row->id,
                    'l_note' => 'Plata Pingoo pentru '.$row->nr.' afiliati'
                );
                $MPItems[] = $item;
                if ($i==250)
                {
                    $PayPalRequestData = array('MPFields'=>$MPFields, 'MPItems' => $MPItems);
                    $PayPalResult = $PayPal->MassPay($PayPalRequestData);
                    $i=0;
                    if (empty($PayPalResult))
                    {
                        $error = 'Empty response from PayPal. Possible connection error.';
                        echo $error;
                        # delete batch
                        $toDelete = array();
                        foreach ($MPItems as $it)
                            $toDelete[] = $it['l_uniqueid'];
                        if (!empty($toDelete))
                        {
                            $wpdb->query( 
                                '
                                DELETE FROM '.$wpdb->prefix.'pingoo_payments
                                WHERE id IN ('.implode(',',$toDelete).') 
                                '
                            );
                            $wpdb->query( 
                                '
                                DELETE FROM '.$wpdb->prefix.'pingoo_payed_referrals
                                WHERE payment_id IN ('.implode(',',$toDelete).') 
                                '
                            );
                        }
                        die();
                    }
                    if (!empty($PayPalResult['ERRORS']))
                    {
                        foreach ($PayPalResult['ERRORS'] as $err)
                            $error .= '<p>'.$err['L_LONGMESSAGE'].'</p>';
                        # delete batch
                        $toDelete = array();
                        foreach ($MPItems as $it)
                            $toDelete[] = $it['l_uniqueid'];
                        if (!empty($toDelete))
                        {
                            $wpdb->query( 
                                '
                                DELETE FROM '.$wpdb->prefix.'pingoo_payments
                                WHERE id IN ('.implode(',',$toDelete).') 
                                '
                            );
                            $wpdb->query( 
                                '
                                DELETE FROM '.$wpdb->prefix.'pingoo_payed_referrals
                                WHERE payment_id IN ('.implode(',',$toDelete).') 
                                '
                            );
                        }
                    }
                }
            }
            if ($i<250)
            {
                $PayPalRequestData = array('MPFields'=>$MPFields, 'MPItems' => $MPItems);
                $PayPalResult = $PayPal->MassPay($PayPalRequestData);
                if (empty($PayPalResult))
                {
                    $error = 'Empty response from PayPal. Possible connection error.';
                    echo $error;
                    # delete batch
                    $toDelete = array();
                    foreach ($MPItems as $it)
                        $toDelete[] = $it['l_uniqueid'];
                    if (!empty($toDelete))
                    {
                        $wpdb->query( 
                            '
                            DELETE FROM '.$wpdb->prefix.'pingoo_payments
                            WHERE id IN ('.implode(',',$toDelete).') 
                            '
                        );
                        $wpdb->query( 
                            '
                            DELETE FROM '.$wpdb->prefix.'pingoo_payed_referrals
                            WHERE payment_id IN ('.implode(',',$toDelete).') 
                            '
                        );
                    }
                    die();
                }
                if (!empty($PayPalResult['ERRORS']))
                {
                    foreach ($PayPalResult['ERRORS'] as $err)
                        $error .= '<p>'.$err['L_LONGMESSAGE'].'</p>';
                    # delete batch
                    $toDelete = array();
                    foreach ($MPItems as $it)
                        $toDelete[] = $it['l_uniqueid'];
                    if (!empty($toDelete))
                    {
                        $wpdb->query( 
                            '
                            DELETE FROM '.$wpdb->prefix.'pingoo_payments
                            WHERE id IN ('.implode(',',$toDelete).') 
                            '
                        );
                        $wpdb->query( 
                            '
                            DELETE FROM '.$wpdb->prefix.'pingoo_payed_referrals
                            WHERE payment_id IN ('.implode(',',$toDelete).') 
                            '
                        );
                    }
                }
                else
                {
                    # mark batch as sent
                    $wpdb->update( 
                        $wpdb->prefix.'pingoo_payments', 
                        array( 
                            'sent_to_paypal' => 1,
                            'status' => 'sent' 
                        ), 
                        array( 'sent_to_paypal' => 0 )
                    );
                }
            }

            if (!empty($error))
                echo $error;
            else
                echo 'ok';
        }
        else echo 'You must select at least a user.';
        die();
    }

    if (isset($_POST['do']) && $_POST['do']=='pingoomp_referrals')
    {
        # cautare
        $search = mysql_real_escape_string($_POST['search']['value']);

        # threshold
        $threshold = (int)get_option('wp_referral_affcheck');
        if (empty($threshold))
            $threshold = 0;

        # nr de rezultate
        if (!empty($search)) {
            $r = $wpdb->get_results('
                SELECT ID
                FROM '.$wpdb->users.'
                WHERE (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals)) >= '.$threshold.' AND (user_login LIKE \'%'.$search.'%\' OR user_email LIKE \'%'.$search.'%\' OR ID=\''.$search.'\')');
            $total = count($r);
        }
        else {
            $r = $wpdb->get_results('
                SELECT ID
                FROM '.$wpdb->users.' 
                WHERE (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals)) >= '.$threshold);
            $total = count($r);
        }

        # ordonare
        $order = $_POST['order'][0]['column'];
        $order_column = $_POST['columns'][$order]['data'];
        $order_dir = $_POST['order'][0]['dir'];

        # interogare
        if (!empty($search))
        {
            $results = $wpdb->get_results('
                SELECT user_login, user_email, ID,
                   (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals))
                    AS nr
                FROM '.$wpdb->users.'
                WHERE (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals)) >= '.$threshold.' AND (user_login LIKE \'%'.$search.'%\' OR user_email LIKE \'%'.$search.'%\' OR ID=\''.$search.'\')
                ORDER BY '.$order_column.' '.$order_dir.'
                LIMIT '.$_POST['start'].','.$_POST['length'],OBJECT
            );
        }
        else
        {
            $results = $wpdb->get_results('
                SELECT user_login, user_email, ID,
                   (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals))
                    AS nr
                FROM '.$wpdb->users.'
                WHERE (SELECT COUNT(*) FROM '.$wpdb->usermeta.'
                    WHERE meta_key=\'referral_id\' AND meta_value='.$wpdb->users.'.ID AND user_id NOT IN (SELECT referral_id FROM '.$wpdb->prefix.'pingoo_payed_referrals)) >= '.$threshold.'
                ORDER BY '.$order_column.' '.$order_dir.'
                LIMIT '.$_POST['start'].','.$_POST['length'],OBJECT
            );
        }

        # generam raspunsul
        $response = array(
            'draw' => $_POST['draw'],
            'recordsTotal' => $total,
            'recordsFiltered' => $total
        );

        # adaugam valorile la raspuns
        $data = array();
        foreach ($results as $result) {
            $data[] = array(
                'DT_RowId' => 'row_'.$result->ID,
                'ID' => $result->ID,
                'user_login' => $result->user_login,
                'user_email' => $result->user_email,
                'nr' => $result->nr,
                'inputno' => '<input type="text" class="nrinput" onchange="changeVal('.$result->ID.','.$result->nr.')" name="no_'.$result->ID.'" id="no_'.$result->ID.'" value="'.$result->nr.'" style="width: 60px" />'
            );
        }
        $response['data'] = $data;
        
        # trimitem raspunsul
        echo json_encode($response);
        die();
    }

    if (isset($_POST['do']) && $_POST['do']=='pingoomp_transactions')
    {
        # cautare
        $search = mysql_real_escape_string($_POST['search']['value']);

        # nr de rezultate
        if (!empty($search)) {
            $r = $wpdb->get_results('
                SELECT COUNT(id)
                FROM '.$wpdb->prefix.'pingoo_payments
                WHERE email LIKE \'%'.$search.'%\' OR id=\''.$search.'\'');
            $total = count($r);
        }
        else {
            $r = $wpdb->get_var('
                SELECT COUNT(id)
                FROM '.$wpdb->prefix.'pingoo_payments');
            $total = $r;
        }

        # ordonare
        $order = $_POST['order'][0]['column'];
        $order_column = $_POST['columns'][$order]['data'];
        $order_dir = $_POST['order'][0]['dir'];

        # interogare
        if (!empty($search))
        {
            $results = $wpdb->get_results('
                SELECT *, (SELECT COUNT(id) FROM '.$wpdb->prefix.'pingoo_payed_referrals WHERE payment_id='.$wpdb->prefix.'pingoo_payments.id) AS nr
                FROM '.$wpdb->prefix.'pingoo_payments
                WHERE email LIKE \'%'.$search.'%\' OR id=\''.$search.'\'
                ORDER BY '.$order_column.' '.$order_dir.'
                LIMIT '.$_POST['start'].','.$_POST['length'],OBJECT
            );
        }
        else
        {
            $results = $wpdb->get_results('
                SELECT *, (SELECT COUNT(id) FROM '.$wpdb->prefix.'pingoo_payed_referrals WHERE payment_id='.$wpdb->prefix.'pingoo_payments.id) AS nr
                FROM '.$wpdb->prefix.'pingoo_payments
                ORDER BY '.$order_column.' '.$order_dir.'
                LIMIT '.$_POST['start'].','.$_POST['length'],OBJECT
            );
        }

        # generam raspunsul
        $response = array(
            'draw' => $_POST['draw'],
            'recordsTotal' => $total,
            'recordsFiltered' => $total
        );

        # adaugam valorile la raspuns
        $data = array();
        foreach ($results as $result) {
            $data[] = array(
                'DT_RowId' => 'row_'.$result->id,
                'id' => $result->id,
                'email' => $result->email,
                'ammount' => $result->ammount,
                'currency' => $result->currency,
                'status' => $result->status,
                'date_added' => $result->date_added,
                'date_modified' => $result->date_modified,
                'nr' => $result->nr
            );
        }
        $response['data'] = $data;
        
        # trimitem raspunsul
        echo json_encode($response);
        die();
    }
    die();
}

function wpaffrefipn_func( $atts ) {
    global $wpdb;
    # find number of users payed in this array
    $no = count(preg_grep('/^receiver_email_[\d]*/', array_keys($_REQUEST)));
    # add to database
    if (!empty($no))
    {
        for ($i=1;$i<=$no;$i++)
        {
            $wpdb->update( 
                $wpdb->prefix.'pingoo_payments', 
                array( 
                    'status' => $_REQUEST['status_'.$i],
                    'paypal_response' => serialize($_REQUEST),
                    'date_modified' => date('Y-m-d H:i:s') 
                ), 
                array( 'id' => $_REQUEST['unique_id_'.$i] )
            );
        }
    }
    return;
}
add_shortcode( 'pingoompipn', 'wpaffrefipn_func' );





?>